;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:defclass TestOperMeths (unittest:testcase) ((unittest:tName :initform "TestOperMeths.twl") (unittest:tFuns :initform '(test-not-for-t test-not-for-bitVector test-and-for-t test-and-for-bitVector test-or-for-t test-or-for-bitVector test-xor-for-t test-xor-for-bitVector test-equality-for-numbers test-equality-for-strings test-equality-for-chars test-equality-for-lists test-equality-for-vectors test-equality-for-hashTable test-addition-for-lists test-addition-for-vectors test-addition-for-string-and-chars test-modulus-division test-exponentiation test-string-formatting test-insert-operator))))
(cl:defmethod test-not-for-t ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_not_ cl:nil) :textOnFail "(not nil) should always be true") (unittest:assertFalse ts (tl:_not_ cl:t) :textOnFail "(not t) should always be nil (false)") (unittest:assertFalse ts (tl:_not_ "string") :textOnFail "(not obj) should always be nil (false), when obj is not nil"))
(cl:defmethod test-not-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_not_ #*) #* :test #'equal :textOnFail "Bitwise-not of an empty bit-vector should be an empty bit-vector") (unittest:assertEqual ts (tl:_not_ #*0011) #*1100 :test #'equal :textOnFail "Bitwise-not should return a bit-vector with every bit flipped"))
(cl:defmethod test-and-for-t ((ts TestOperMeths)) (unittest:assertFalse ts (tl:_and_ cl:t cl:nil) :textOnFail "(t and nil) should always be nil (false)") (unittest:assertFalse ts (tl:_and_ cl:nil cl:t) :textOnFail "(nil and t) should always be nil (false)") (unittest:assertFalse ts (tl:_and_ cl:nil cl:t) :textOnFail "(nil and t) should always be nil (false)") (unittest:assertTrue ts (tl:_and_ cl:t cl:t) :textOnFail "(t and t) should always be true") (unittest:assertTrue ts (tl:_and_ 12 "string") :textOnFail "(obj1 and obj2) should always be true, when obj1 and obj2 or not nil"))
(cl:defmethod test-and-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_and_ #* #*) #* :test #'equal :textOnFail "Bitwise-and of an empty bit-vectors should be an empty bit-vector") (unittest:assertEqual ts (tl:_and_ #*1010 #*0011) #*0010 :test #'equal :textOnFail "Bitwise-and should produce a vector with every bit being bit-anding of corresponding bits from given vectors") (unittest:assertCondition ts error (tl:_and_ #*110 #*110011) :textOnFail "Bitwise-and should raise an error when given vectors have different length"))
(cl:defmethod test-or-for-t ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_or_ cl:t cl:nil) :textOnFail "(t or nil) should always be true") (unittest:assertTrue ts (tl:_or_ cl:nil cl:t) :textOnFail "(nil or t) should always be true") (unittest:assertTrue ts (tl:_or_ cl:t cl:t) :textOnFail "(t or t) should always be true") (unittest:assertFalse ts (tl:_or_ cl:nil cl:nil) :textOnFail "(nil or nil) should always be nil (false)") (unittest:assertTrue ts (tl:_or_ cl:nil "string") :textOnFail "(nil or obj) should be true, when obj is not nil"))
(cl:defmethod test-or-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_or_ #* #*) #* :test #'equal :textOnFail "Bitwise-or of an empty bit-vectors should be an empty bit-vector") (unittest:assertEqual ts (tl:_or_ #*1010 #*0110) #*1110 :test #'equal :textOnFail "Bitwise-or should produce a vector with every bit being bit-oring of corresponding bits from given vectors") (unittest:assertCondition ts error (tl:_or_ #*110 #*110011) :textOnFail "Bitwise-or should raise an error when given vectors have different length"))
(cl:defmethod test-xor-for-t ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_xor_ cl:t cl:nil) :textOnFail "(t xor nil) should always be true") (unittest:assertTrue ts (tl:_xor_ cl:nil cl:t) :textOnFail "(nil xor t) should always be true") (unittest:assertFalse ts (tl:_xor_ cl:t cl:t) :textOnFail "(t xor t) should always be nil (false)") (unittest:assertFalse ts (tl:_xor_ cl:nil cl:nil) :textOnFail "(nil xor nil) should always be nil (false)") (unittest:assertTrue ts (tl:_xor_ cl:nil "string") :textOnFail "(nil xor obj) should be true, when obj is not nil"))
(cl:defmethod test-xor-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_xor_ #* #*) #* :test #'equal :textOnFail "Bitwise-or of an empty bit-vectors should be an empty bit-vector") (unittest:assertEqual ts (tl:_xor_ #*1010 #*0110) #*1100 :test #'equal :textOnFail "Bitwise-or should produce a vector with every bit being bit-oring of corresponding bits from given vectors") (unittest:assertCondition ts error (tl:_xor_ #*110 #*110011) :textOnFail "Bitwise-or should raise an error when given vectors have different length"))
(cl:defmethod test-equality-for-numbers ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_==_ 1 1)) (unittest:assertFalse ts (tl:_!=_ 1 1)) (unittest:assertTrue ts (tl:_!=_ 1 2)) (unittest:assertFalse ts (tl:_==_ 1 2)) (unittest:assertTrue ts (tl:_==_ 1 1.0)) (unittest:assertFalse ts (tl:_!=_ 1 1.0)) (unittest:assertTrue ts (tl:_==_ 1 (cl:complex 1 0))) ; etc., like lisp's equality for numbers
)
(cl:defmethod test-equality-for-strings ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_==_ "abcde" "abcde")) (unittest:assertFalse ts (tl:_!=_ "abcde" "abcde")) (unittest:assertTrue ts (tl:_!=_ "abcde" "abcdef")) (unittest:assertFalse ts (tl:_==_ "abcde" "abcdef")) (unittest:assertTrue ts (tl:_!=_ "abcde" "Abcde")) (unittest:assertFalse ts (tl:_==_ "abcde" "Abcde")))
(cl:defmethod test-equality-for-chars ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_==_ #\a #\a)) (unittest:assertFalse ts (tl:_!=_ #\a #\a)) (unittest:assertTrue ts (tl:_!=_ #\a #\b)) (unittest:assertFalse ts (tl:_==_ #\a #\b)) (unittest:assertTrue ts (tl:_!=_ #\a #\A)) (unittest:assertFalse ts (tl:_==_ #\a #\A)))
(cl:defmethod test-equality-for-lists ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_==_ (cl:list) (cl:list))) (unittest:assertFalse ts (tl:_!=_ (cl:list) (cl:list))) (unittest:assertTrue ts (tl:_==_ (cl:list 1 2 "abc") (cl:list 1 2 "abc"))) (unittest:assertFalse ts (tl:_!=_ (cl:list 1 2 "abc") (cl:list 1 2 "abc"))) (unittest:assertTrue ts (tl:_!=_ (cl:list 1 3 "abc") (cl:list 1 2 "abc"))) (unittest:assertFalse ts (tl:_==_ (cl:list 1 3 "abc") (cl:list 1 2 "abc"))) (unittest:assertTrue ts (tl:_!=_ (cl:list 1 2 "abc" 3) (cl:list 1 2 "abc"))) (unittest:assertFalse ts (tl:_==_ (cl:list 1 2 "abc" 3) (cl:list 1 2 "abc"))))
(cl:defmethod test-equality-for-vectors ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_==_ (tl:_make-vector_) (tl:_make-vector_))) (unittest:assertFalse ts (tl:_!=_ (tl:_make-vector_) (tl:_make-vector_))) (unittest:assertTrue ts (tl:_==_ (tl:_make-vector_ :initContent (cl:list 1 2 "abc")) (tl:_make-vector_ :initContent (cl:list 1 2 "abc")))) (unittest:assertFalse ts (tl:_!=_ (tl:_make-vector_ :initContent (cl:list 1 2 "abc")) (tl:_make-vector_ :initContent (cl:list 1 2 "abc")))) (unittest:assertTrue ts (tl:_!=_ (tl:_make-vector_ :initContent (cl:list 1 3 "abc")) (tl:_make-vector_ :initContent (cl:list 1 2 "abc")))) (unittest:assertFalse ts (tl:_==_ (tl:_make-vector_ :initContent (cl:list 1 3 "abc")) (tl:_make-vector_ :initContent (cl:list 1 2 "abc")))) (unittest:assertTrue ts (tl:_!=_ (tl:_make-vector_ :initContent (cl:list 1 2 "abc" 3)) (tl:_make-vector_ :initContent (cl:list 1 2 "abc")))) (unittest:assertFalse ts (tl:_==_ (tl:_make-vector_ :initContent (cl:list 1 2 "abc" 3)) (tl:_make-vector_ :initContent (cl:list 1 2 "abc")))))
(cl:defmethod test-equality-for-hashTable ((ts TestOperMeths)) (unittest:assertTrue ts (tl:_==_ (tl:_make-hash-table_) (tl:_make-hash-table_))) (unittest:assertFalse ts (tl:_!=_ (tl:_make-hash-table_) (tl:_make-hash-table_))) (unittest:assertTrue ts (tl:_==_ (tl:_make-hash-table_ "abc" 1) (tl:_make-hash-table_ "abc" 1))) (unittest:assertFalse ts (tl:_!=_ (tl:_make-hash-table_ "abc" 1) (tl:_make-hash-table_ "abc" 1))) (unittest:assertTrue ts (tl:_==_ (tl:_make-hash-table_ "abc" (cl:list 1 2 (tl:_make-vector_ :initContent (cl:list "b" "a")))) (tl:_make-hash-table_ "abc" (cl:list 1 2 (tl:_make-vector_ :initContent (cl:list "b" "a")))))) (unittest:assertFalse ts (tl:_!=_ (tl:_make-hash-table_ "abc" (cl:list 1 2 (tl:_make-vector_ :initContent (cl:list "b" "a")))) (tl:_make-hash-table_ "abc" (cl:list 1 2 (tl:_make-vector_ :initContent (cl:list "b" "a")))))) (unittest:assertTrue ts (tl:_!=_ (tl:_make-hash-table_ "abc" 2) (tl:_make-hash-table_ "abc" 1))) (unittest:assertFalse ts (tl:_==_ (tl:_make-hash-table_ "abc" 2) (tl:_make-hash-table_ "abc" 1))) (unittest:assertTrue ts (tl:_!=_ (tl:_make-hash-table_ "abc" 1 23 "gh") (tl:_make-hash-table_ "abc" 1))) (unittest:assertFalse ts (tl:_==_ (tl:_make-hash-table_ "abc" 1 23 "gh") (tl:_make-hash-table_ "abc" 1))))
(cl:defmethod test-addition-for-lists ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_+_ (cl:list 1 2 3) (cl:list)) (cl:list 1 2 3)) (unittest:assertEqual ts (tl:_+_ (cl:list 1 2 3) (cl:list 4 5 6)) (cl:list 1 2 3 4 5 6)))
(cl:defmethod test-addition-for-vectors ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_+_ (tl:_make-vector_ :initContent (cl:list 1 2 3)) (tl:_make-vector_)) (tl:_make-vector_ :initContent (cl:list 1 2 3))) (unittest:assertEqual ts (tl:_+_ (tl:_make-vector_ :initContent (cl:list 1 2 3)) (tl:_make-vector_ :initContent (cl:list 4 5 6))) (tl:_make-vector_ :initContent (cl:list 1 2 3 4 5 6))))
(cl:defmethod test-addition-for-string-and-chars ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_+_ "" "def") "def") (unittest:assertEqual ts (tl:_+_ "abc " "def") "abc def") (unittest:assertEqual ts (tl:_+_ #\A "def") "Adef") (unittest:assertEqual ts (tl:_+_ "def" #\A) "defA"))
(cl:defmethod test-modulus-division ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_%_ 7 2) 3))
(cl:defmethod test-exponentiation ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_**_ 2 5) 32))
(cl:defmethod test-string-formatting ((ts TestOperMeths)) (unittest:assertEqual ts (tl:_%_ "num: ~d" 32) "num: 32") (unittest:assertEqual ts (tl:_%_ "string: ~A" "boo") "string: boo") (unittest:assertEqual ts (tl:_%_ "num1: ~d, num2: ~d" (tl:_make-vector_ :initContent (cl:list 32 65))) "num1: 32, num2: 65") (unittest:assertEqual ts (tl:_%_ "num1: ~d, num2: ~d" (cl:list 32 65)) "num1: 32, num2: 65") (unittest:assertEqual ts (tl:_%_ "nil: ~A" (cl:list)) "nil: NIL"))
(cl:defmethod test-insert-operator ((ts TestOperMeths)) (cl:let (a) (cl:setf a (tl:_make-vector_)) (tl:_<<_ a "a") (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a"))) (tl:_<<_ a (cl:list 1 2)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" (cl:list 1 2)))) (tl:_<<_ a (tl:_make-vector_ :initContent (cl:list 3 4))) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" (cl:list 1 2) (tl:_make-vector_ :initContent (cl:list 3 4))))) (unittest:assertEqual ts (tl:_<<_ a "e") a) (tl:_<<_ (tl:_<<_ a "c") "d") (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" (cl:list 1 2) (tl:_make-vector_ :initContent (cl:list 3 4)) "e" "c" "d"))) (cl:let (b) (cl:setf b (cl:list)) (unittest:assertCondition ts null-list-error (tl:_<<_ b "a")) (cl:setf b (cl:list "a")) (tl:_<<_ b "b") (unittest:assertEqual ts b (cl:list "a" "b")) (tl:_<<_ b (cl:list 1 2)) (unittest:assertEqual ts b (cl:list "a" "b" (cl:list 1 2))) (tl:_<<_ b (tl:_make-vector_ :initContent (cl:list 3 4))) (unittest:assertEqual ts b (cl:list "a" "b" (cl:list 1 2) (tl:_make-vector_ :initContent (cl:list 3 4)))) (unittest:assertEqual ts (tl:_<<_ b "e") b) (tl:_<<_ (tl:_<<_ b "c") "d") (unittest:assertEqual ts b (cl:list "a" "b" (cl:list 1 2) (tl:_make-vector_ :initContent (cl:list 3 4)) "e" "c" "d")) (cl:let (str) (cl:setf str (make-string-output-stream)) (tl:_<<_ str "Hi,") (tl:_<<_ str #\Space) (tl:_<<_ str "Bob!") (unittest:assertEqual ts (get-output-stream-string str) "Hi, Bob!") (unittest:assertEqual ts (tl:_<<_ str "-- ") str) (tl:_<<_ (tl:_<<_ (tl:_<<_ str "Bye,") #\Space) "Mike.") (unittest:assertEqual ts (get-output-stream-string str) "-- Bye, Mike.")))))
