;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:defclass TestContainerMeths (unittest:testcase) ((unittest:tName :initform "TestContainerMeths.twl") (unittest:tFuns :initform '(test-list-methods test-vector-methods test-array-methods test-hashTable-methods1 test-hashTable-methods2 test-iterator-methods1 test-iterator-methods2 test-get-slice-vector test-get-slice-list test-setf-slice-vector test-setf-slice-list))))
(cl:defmethod test-list-methods ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (cl:list)) (unittest:assertEqual ts (len a) 0) (cl:let (b) (cl:setf b (cl:list 1 2 "k")) (unittest:assertEqual ts (len b) 3) (unittest:assertCondition ts index-error (tl:_getitem_ a 0) :textOnFail "index should be out of range") (unittest:assertEqual ts (tl:_getitem_ b 0) 1) (unittest:assertEqual ts (tl:_getitem_ b (tl:_unary-_ 2)) 2) (cl:setf (tl:_getitem_ b (tl:_unary-_ 1)) 3) (unittest:assertEqual ts b (cl:list 1 2 3)) (unittest:assertCondition ts null-list-error (tl-append a "s") :textOnFail "assert is not supposed to work for nil, so error is raised") (tl-append b (cl:list "a" "b") (tl:_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (tl:_make-vector_)) (unittest:assertEqual ts b (cl:list 1 2 3 (cl:list "a" "b") (tl:_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (tl:_make-vector_))) (unittest:assertCondition ts null-list-error (extend a (cl:list "s" "t")) :textOnFail "extend is not supposed to work for nil, so error is raised") (cl:let (c) (cl:setf c (cons cl:nil cl:nil)) (extend c (cl:list "a" "b") (tl:_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (tl:_make-vector_)) (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c" "d")) (unittest:assertCondition ts null-list-error (insert a 0 "s") :textOnFail "insert is not supposed to work for nil, so error is raised") (insert c 0 "s") (unittest:assertEqual ts c (cl:list "s" cl:nil "a" "b" "c" "d")) (insert c (tl:_unary-_ 1) "t") (unittest:assertEqual ts c (cl:list "s" cl:nil "a" "b" "c" "d" "t")) (unittest:assertEqual ts (tl-pop c 0) "s") (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c" "d" "t")) (unittest:assertEqual ts (tl-pop c (tl:_unary-_ 1)) "t") (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c" "d")) (unittest:assertEqual ts (tl-pop c) "d") (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c")) (unittest:assertEqual ts (tl-remove c "c") 3) (unittest:assertEqual ts c (cl:list cl:nil "a" "b")) (unittest:assertEqual ts (tl-remove c "z") cl:nil) (unittest:assertEqual ts c (cl:list cl:nil "a" "b")) (unittest:assertEqual ts (index c cl:nil) 0) (unittest:assertEqual ts (index c "b") 2) (unittest:assertEqual ts (index c "z") cl:nil) (unittest:assertEqual ts (tl-count c "b") 1) (unittest:assertEqual ts (tl-count c "z") 0) (insert c 0 "b") (unittest:assertEqual ts (tl-count c "b") 2)))))
(cl:defmethod test-vector-methods ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (tl:_make-vector_)) (unittest:assertEqual ts (len a) 0) (cl:let (b) (cl:setf b (tl:_make-vector_ :initContent (cl:list 1 2 "k"))) (unittest:assertEqual ts (len b) 3) (unittest:assertCondition ts index-error (tl:_getitem_ a 0) :textOnFail "index should be out of range") (unittest:assertEqual ts (tl:_getitem_ b 0) 1) (unittest:assertEqual ts (tl:_getitem_ b (tl:_unary-_ 2)) 2) (cl:setf (tl:_getitem_ b (tl:_unary-_ 1)) 3) (unittest:assertEqual ts b (tl:_make-vector_ :initContent (cl:list 1 2 3))) (tl-append a 1 2) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2))) (tl-append b (cl:list "a" "b") (tl:_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (tl:_make-vector_)) (unittest:assertEqual ts b (tl:_make-vector_ :initContent (cl:list 1 2 3 (cl:list "a" "b") (tl:_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (tl:_make-vector_)))) (extend a (cl:list "a" "b") (tl:_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (tl:_make-vector_)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2 "a" "b" "c" "d"))) (insert a 0 "s") (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "s" 1 2 "a" "b" "c" "d"))) (insert a (tl:_unary-_ 1) "t") (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "s" 1 2 "a" "b" "c" "d" "t"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 5 cl:nil cl:nil)) (tl:_make-vector_ :initContent (cl:list "c" "d" "t"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 5 6 cl:nil)) (tl:_make-vector_ :initContent (cl:list "c"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 6 5 cl:nil)) (tl:_make-vector_)) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ cl:nil 2 cl:nil)) (tl:_make-vector_ :initContent (cl:list "s" 1))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 0 cl:nil 2)) (tl:_make-vector_ :initContent (cl:list "s" 2 "b" "d"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 3 6 2)) (tl:_make-vector_ :initContent (cl:list "a" "c"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 9 10 cl:nil)) (tl:_make-vector_)) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 6) (tl:_unary-_ 2) 2)) (tl:_make-vector_ :initContent (cl:list 2 "b"))) (unittest:assertEqual ts (tl-pop a 0) "s") (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2 "a" "b" "c" "d" "t"))) (unittest:assertEqual ts (tl-pop a (tl:_unary-_ 1)) "t") (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2 "a" "b" "c" "d"))) (unittest:assertEqual ts (tl-pop a) "d") (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2 "a" "b" "c"))) (unittest:assertEqual ts (tl-remove a "c") 4) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2 "a" "b"))) (unittest:assertEqual ts (tl-remove a "z") cl:nil) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2 "a" "b"))) (unittest:assertEqual ts (index a 1) 0) (unittest:assertEqual ts (index a "b") 3) (unittest:assertEqual ts (index a "z") cl:nil) (unittest:assertEqual ts (tl-count a "b") 1) (unittest:assertEqual ts (tl-count a "z") 0) (insert a 0 "b") (unittest:assertEqual ts (tl-count a "b") 2))))
(cl:defmethod test-array-methods ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (make-array '(2 2) :initial-contents '((1 2) (3 4)))) (unittest:assertEqual ts (tl:_getitem_ a '(0 0)) 1) (unittest:assertEqual ts (tl:_getitem_ a '(1 0)) 3) (cl:setf (tl:_getitem_ a '(1 0)) 99) (unittest:assertEqual ts (tl:_getitem_ a '(1 0)) 99)))
(cl:defmethod test-hashTable-methods1 ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (tl:_make-hash-table_)) (unittest:assertEqual ts (len a) 0) (cl:let (b) (cl:setf b (tl:_make-hash-table_ "abc" 1 "cde" 2 "nil" cl:nil)) (unittest:assertEqual ts (len b) 3) (cl:let (val keyFound) (cl:setf (cl:values val keyFound) (tl:_getitem_ b "abc")) (unittest:assertTrue ts keyFound) (unittest:assertEqual ts val 1) (cl:setf (cl:values val keyFound) (tl:_getitem_ b "nil")) (unittest:assertTrue ts keyFound) (unittest:assertEqual ts val cl:nil) (cl:setf (cl:values val keyFound) (tl:_getitem_ b "ABC")) (unittest:assertFalse ts keyFound) (unittest:assertEqual ts val cl:nil) (unittest:assertTrue ts (has_key b "abc")) (unittest:assertFalse ts (has_key b "ABC")) (unittest:assertTrue ts (vectorp (tKeys b))) (unittest:assertEqual ts (len (tKeys b)) 3) (unittest:assertTrue ts (vectorp (tValues b))) (unittest:assertEqual ts (len (tValues b)) 3) (unittest:assertTrue ts (vectorp (tItems b))) (unittest:assertEqual ts (len (tItems b)) 3) (unittest:assertTrue ts (listp (tl:_getitem_ (tItems b) 0))) (unittest:assertEqual ts (len (tl:_getitem_ (tItems b) 0)) 2) (unittest:assertEqual ts (tl:_getitem_ b "cde") 2) (cl:let (popedElem succ) (cl:setf (cl:values popedElem succ) (tl-pop b "cde")) (unittest:assertTrue ts succ) (unittest:assertEqual ts popedElem 2) (unittest:assertFalse ts (has_key b "cde")) (cl:setf (cl:values popedElem succ) (tl-pop b "xxx")) (unittest:assertFalse ts succ) (unittest:assertEqual ts popedElem cl:nil) (cl:setf (tl:_getitem_ b "vect") (tl:_make-vector_)))))))
(cl:defmethod test-hashTable-methods2 ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (tl:_make-hash-table_)) (update a (tl:_make-hash-table_ 1 "a" "b" 2)) (unittest:assertEqual ts a (tl:_make-hash-table_ 1 "a" "b" 2)) (update a (tl:_make-hash-table_ 1 "h" "c" 3)) (unittest:assertEqual ts a (tl:_make-hash-table_ 1 "h" "b" 2 "c" 3))))
(cl:defmethod test-iterator-methods1 ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (cl:let (iter) (cl:setf iter (iter a)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "a" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "b" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "b" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 2)) (cl:list "e" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "e" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 2))) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 10))) (cl:list cl:nil cl:nil)) (unittest:assertEqual ts (multiple-value-list (next iter 10)) (cl:list cl:nil cl:nil)) (cl:setf iter (iter a 2)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "a" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "e" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 1)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 2))) (cl:list "d" cl:t)) (cl:setf iter (iter a 2 3)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "d" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "h" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 1)) (cl:list "i" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "i" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 2))) (cl:list "g" cl:t)) (cl:setf iter (iter a (tl:_unary-_ 3) (tl:_unary-_ 1))) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "i" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list cl:nil cl:nil)) (cl:setf iter (iter a (tl:_unary-_ 3) (tl:_unary-_ 1))) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 0)) (cl:list 0 cl:t)) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 1)) (cl:list 1 cl:t)) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 2)) (cl:list 2 cl:t)) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 3)) (cl:list 3 cl:nil)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" 2 "d" "e" 1 "g" "h" 0))))))
(cl:defmethod test-iterator-methods2 ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (cl:let (iter) (cl:setf iter (iter a)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "a" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "b" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "b" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 2)) (cl:list "e" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "e" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 2))) (cl:list cl:nil cl:nil)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 10))) (cl:list cl:nil cl:nil)) (unittest:assertEqual ts (multiple-value-list (next iter 10)) (cl:list cl:nil cl:nil)) (cl:setf iter (iter a 2)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "a" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "c" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "e" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 1)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 2))) (cl:list cl:nil cl:nil)) (cl:setf iter (iter a 2 3)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "d" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "f" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list "h" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 1)) (cl:list "i" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "i" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter (tl:_unary-_ 2))) (cl:list cl:nil cl:nil)) (cl:setf iter (iter a (tl:_unary-_ 3) (tl:_unary-_ 3))) (unittest:assertEqual ts (multiple-value-list (next iter)) (cl:list cl:nil cl:nil)) (unittest:assertEqual ts (multiple-value-list (next iter 0)) (cl:list "g" cl:t)) (unittest:assertEqual ts (multiple-value-list (next iter 1)) (cl:list "h" cl:t)) (cl:setf iter (iter a 3)) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 0)) (cl:list 0 cl:t)) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 1)) (cl:list 1 cl:t)) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 2)) (cl:list 2 cl:t)) (unittest:assertEqual ts (multiple-value-list (cl:setf (next iter) 3)) (cl:list 3 cl:nil)) (unittest:assertEqual ts a (cl:list 0 "b" "c" 1 "e" "f" 2 "h" "i")))))
(cl:defmethod test-get-slice-vector ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 4 cl:nil cl:nil)) (tl:_make-vector_ :initContent (cl:list "e" "f" "g" "h" "i"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ cl:nil 3 cl:nil)) (tl:_make-vector_ :initContent (cl:list "a" "b" "c"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) cl:nil cl:nil)) (tl:_make-vector_ :initContent (cl:list "h" "i"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ cl:nil (tl:_unary-_ 5) cl:nil)) (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 3 (tl:_unary-_ 4) cl:nil)) (tl:_make-vector_ :initContent (cl:list "d" "e"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 4 6 cl:nil)) (tl:_make-vector_ :initContent (cl:list "e" "f"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 4) (tl:_unary-_ 2) cl:nil)) (tl:_make-vector_ :initContent (cl:list "f" "g"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 6 4 cl:nil)) (tl:_make-vector_)) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) (tl:_unary-_ 4) cl:nil)) (tl:_make-vector_)) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 6 4 (tl:_unary-_ 1))) (tl:_make-vector_ :initContent (cl:list "g" "f"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) (tl:_unary-_ 4) (tl:_unary-_ 1))) (tl:_make-vector_ :initContent (cl:list "h" "g"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 20) 2 cl:nil)) (tl:_make-vector_ :initContent (cl:list "a" "b"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) 20 cl:nil)) (tl:_make-vector_ :initContent (cl:list "h" "i"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 0 cl:nil cl:nil)) (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 1) 0 (tl:_unary-_ 1))) (tl:_make-vector_ :initContent (cl:list "i" "h" "g" "f" "e" "d" "c" "b"))) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 0 (tl:_unary-_ 1) 0)) (tl:_make-vector_))))
(cl:defmethod test-get-slice-list ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 4 cl:nil cl:nil)) (cl:list "e" "f" "g" "h" "i")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ cl:nil 3 cl:nil)) (cl:list "a" "b" "c")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) cl:nil cl:nil)) (cl:list "h" "i")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ cl:nil (tl:_unary-_ 5) cl:nil)) (cl:list "a" "b" "c" "d")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 3 (tl:_unary-_ 4) cl:nil)) (cl:list "d" "e")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 4 6 cl:nil)) (cl:list "e" "f")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 4) (tl:_unary-_ 2) cl:nil)) (cl:list "f" "g")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 6 4 cl:nil)) (cl:list)) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) (tl:_unary-_ 4) cl:nil)) (cl:list)) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 6 4 (tl:_unary-_ 1))) (cl:list "g" "f")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) (tl:_unary-_ 4) (tl:_unary-_ 1))) (cl:list "h" "g")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 20) 2 cl:nil)) (cl:list "a" "b")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) 20 cl:nil)) (cl:list "h" "i")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 0 cl:nil cl:nil)) (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 1) 0 (tl:_unary-_ 1))) (cl:list "i" "h" "g" "f" "e" "d" "c" "b")) (unittest:assertEqual ts (tl:_getitem_ a (tl:_make-slice_ 0 (tl:_unary-_ 1) 0)) (cl:list))))
(cl:defmethod test-setf-slice-vector ((ts TestContainerMeths)) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) cl:nil cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" 1 2 3)))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 4 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" 1 2 3 "e" "f" "g" "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 3 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" 1 2 3 "d" "e" "f" "g" "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 2 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" 1 2 3 "d" "e" "f" "g" "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" 1 2 3 "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_) (cl:list))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 7 1 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" 1 2 3 "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 1) 0 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" 1 2 3 "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 0 cl:nil cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list 1 2 3)))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 2)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" 1 "e" 2 "g" "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 1)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" 1 2 3 "g" "h" "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 7 3 (tl:_unary-_ 2))) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" 2 "g" 1 "i")))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i"))) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 7 3 (tl:_unary-_ 1))) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (tl:_make-vector_ :initContent (cl:list "a" "b" "c" "d" "e" 3 2 1 "i")))))
(cl:defmethod test-setf-slice-list ((ts TestContainerMeths)) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 2) cl:nil cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" "d" "e" "f" "g" 1 2 3))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 4 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" 1 2 3 "e" "f" "g" "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 3 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" 1 2 3 "d" "e" "f" "g" "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 2 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" 1 2 3 "d" "e" "f" "g" "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" 1 2 3 "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_) (cl:list))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 7 1 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" "d" "e" "f" "g" 1 2 3 "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ (tl:_unary-_ 1) 0 cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" 1 2 3 "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 0 cl:nil cl:nil)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list 1 2 3))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 2)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" 1 "e" 2 "g" "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 3 7 1)) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" 1 2 3 "g" "h" "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 7 3 (tl:_unary-_ 2))) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" "d" "e" 2 "g" 1 "i"))) (tl:tl-for (sliceToIns (tl:_make-vector_ :initContent (cl:list (tl:_make-vector_ :initContent (cl:list 1 2 3)) (cl:list 1 2 3))) a) (cl:nil) (cl:setf a (cl:list "a" "b" "c" "d" "e" "f" "g" "h" "i")) (unittest:assertTrue ts (eq (cl:setf (tl:_getitem_ a (tl:_make-slice_ 7 3 (tl:_unary-_ 1))) sliceToIns) sliceToIns)) (unittest:assertEqual ts a (cl:list "a" "b" "c" "d" "e" 3 2 1 "i"))))
