;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;; load TL before using its methods
(cl:let ((tlPath (namestring (ext:cd)))) (cl:let (pathStr) (cl:setf pathStr (concatenate 'string tlPath "/**/")) (cl:setf (logical-pathname-translations "tl-sys") (cl:list (cl:list "**;*.*" pathStr) (cl:list ";**;*.*" pathStr)))))
(cl:let ((*error-output* (make-broadcast-stream))) ; bit sink, like dev/null
 (cl:load (logical-pathname "tl-sys:core;tl-def")))
;; set paths
(cl:let ((envTlPath (getenv "TLPATH")) (pathList (cl:list))) (cl:cond (envTlPath (cl:do (colInd) (cl:nil) (cl:setf colInd (index envTlPath #\:)) (cl:cond (colInd (cl:cond ((tl:_!=_ (len (tl:_getitem_ envTlPath (tl:_make-slice_ cl:nil colInd cl:nil))) 0) (tl-append pathList (pathname (tl:_getitem_ envTlPath (tl:_make-slice_ cl:nil colInd cl:nil)))))) (cl:setf envTlPath (tl:_getitem_ envTlPath (tl:_make-slice_ (tl:_+_ colInd 1) cl:nil cl:nil)))) (cl:t (cl:cond ((tl:_!=_ (len envTlPath) 0) (tl-append pathList (pathname (tl:_getitem_ envTlPath (tl:_make-slice_ cl:nil colInd cl:nil)))))) (cl:return-from cl:nil ())))))) (cl:let (*tl-load-paths*) (cl:setf *tl-load-paths* (tl:_+_ (tl:_+_ (tl:_getitem_ *tl-load-paths* (tl:_make-slice_ cl:nil 1 cl:nil)) pathList) (tl:_getitem_ *tl-load-paths* (tl:_make-slice_ 1 cl:nil cl:nil))))))
;; adjust clisp's *load-paths*
(cl:setf *load-paths* (tl:_+_ *tl-load-paths* *load-paths*))
;; change functions in SYSTEM package that do main loop, break loop and stepping
(ext:without-package-lock ("SYSTEM" "EXT" "COMMON-LISP") (cl:let ((*error-output* (make-broadcast-stream))) ; bit sink, like dev/null
 (tl-load :clisp-pluggin)))
;; load TwinLisp startup file, if any.
(cl:handler-case (cl:progn (cl:let (startupFile) (cl:setf startupFile (getenv "TLSTARTUP")) (cl:cond ((tl:_!=_ (len startupFile) 0) (cl:load startupFile))))) (error (er) (tl:_<<_ (cout) (tl:_%_ "~%Error occured while loading startup file:~%~A" er))))
;; TwinLisp greeting
(tl:_<<_ (tl:_<<_ (tl:_<<_ (tl:_<<_ (cout) "Clisp with TwinLisp.") #\Newline) "Typing :h brings up a help message.") #\Newline)
