;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
; PHASE's are phases of string reading
(const REG_PHASE :regular_code)
(const STRING_PHASE :string_chars)
(const CLISP_PHASE :clisp_code)
; precompiled regular expressions
(const _NON_WHITE_RE (regexp:regexp-compile (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ "^[^" #\Space) #\Tab) #\Newline) #\Page) #\Return) "]\\+")))
(const _WHITE_RE (regexp:regexp-compile (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ "^[" #\Space) #\Tab) #\Newline) #\Page) #\Return) "]\\+")))
(const _ALPHA_NUM_RE (regexp:regexp-compile "^\\w\\+"))
(const _CLISP_START_RE (regexp:regexp-compile "^#t{"))
(const _CLISP_END_RE (regexp:regexp-compile "#t}"))
(const _CLISP_START_ANYWHERE_RE (regexp:regexp-compile "#t{"))
(const _DOT_FLOAT_RE (regexp:regexp-compile (tl:_+_ (tl:_+_ "^\\.[0-9]\\+[esfdlESFDL][+\\-]\\?[0-9]\\+" "\\|") "^\\.[0-9]\\+")))
(const _NUMBER_RE (regexp:regexp-compile (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ "^[0-9]\\+\\.\\?[0-9]*[esfdlESFDL][+\\-]\\?[0-9]\\+" "\\|") "^[0-9]\\+\\.[0-9]\\+") "\\|") "^[0-9]\\+\\.\\?")))
(cl:defun makeStrElem (elemType value strNum start end) (new StrElem :type elemType :value value :lineNum strNum :start start :end end))
(cl:defun _startStringPhase (strNum startIndex marks) (tl-append marks (makeStrElem STR_START_ELEM (string #\") strNum startIndex (tl:_+_ startIndex 1))) (cl:values (tl:_+_ startIndex 1) STRING_PHASE))
(cl:defun _findEndOfExprInStr (st startIndex termChars) "    Expressions are expected to end by any symbol in termChars. If the first
    return parameter is True, then expression was terminated correctly. If
    it is False, then the end of the line was reached.
    " (cl:do* ((end startIndex)) ((tl:_>=_ end (len st)) (cl:values cl:nil end)) (cl:let (ch) (cl:setf ch (tl:_getitem_ st end)) (cl:cond ((tl:_!=_ (tl-count termChars ch) 0) (cl:return-from cl:nil (cl:values cl:t end))) ((tl:_==_ ch #\\) (cl:cond ((tl:_<_ (tl:_+_ end 1) (len st)) (cl:setf end (tl:_+_ end 2))) (cl:t (cl:setf end (tl:_+_ end 1))))) (cl:t (cl:setf end (tl:_+_ end 1)))))))
(cl:defun _findEndOfExpr (st startIndex termChars) "    Symbol is terminated by one of termChars, or the end of line.
    " (nth-value 1 (_findEndOfExprInStr st startIndex termChars)))
(cl:defun _procStringPhase (initStr strNum startIndex marks) (cl:let (st) (cl:setf st initStr) (cl:let (endingInside end) (cl:setf (cl:values endingInside end) (_findEndOfExprInStr st startIndex (tl:_make-vector_ :initContent (cl:list #\")))) (cl:let (elemType phase) (cl:setf (cl:values elemType phase end) (cl:cond (endingInside ; include also ending quote
 (cl:values STR_END_ELEM REG_PHASE (tl:_+_ end 1))) (cl:t (cl:setf st (tl:_+_ st #\Newline)) (cl:values STR_MID_ELEM STRING_PHASE (len st))))) (tl-append marks (makeStrElem elemType (tl:_getitem_ st (tl:_make-slice_ startIndex end cl:nil)) strNum startIndex end)) (cl:values end phase)))))
(cl:defun _procCLispPhase (st strNum startIndex marks numOfSyntSwitchLevels) (cl:let (match) (cl:setf match (regexp:regexp-exec _CLISP_START_ANYWHERE_RE st :start startIndex)) (cl:cond (match (cl:let (endOfOpenning) (cl:setf endOfOpenning (cl:slot-value match 'regexp::end)) (cl:setf match (regexp:regexp-exec _CLISP_END_RE st :start startIndex :end (cl:slot-value match 'regexp::start))) (cl:cond (match (cl:cond ((tl:_==_ (tl:_-_ numOfSyntSwitchLevels 1) 0) (tl-append marks (makeStrElem CLISP_END_ELEM (tl:_+_ (tl:_getitem_ st (tl:_make-slice_ startIndex (cl:slot-value match 'regexp::start) cl:nil)) #\Newline) strNum startIndex (cl:slot-value match 'regexp::start))) (cl:values (cl:slot-value match 'regexp::end) REG_PHASE (tl:_-_ numOfSyntSwitchLevels 1))) (cl:t (tl-append marks (makeStrElem CLISP_MID_ELEM (tl:_getitem_ st (tl:_make-slice_ startIndex (cl:slot-value match 'regexp::end) cl:nil)) strNum startIndex (cl:slot-value match 'regexp::end))) (cl:values (cl:slot-value match 'regexp::end) CLISP_PHASE (tl:_-_ numOfSyntSwitchLevels 1))))) (cl:t (tl-append marks (makeStrElem CLISP_MID_ELEM (tl:_getitem_ st (tl:_make-slice_ startIndex endOfOpenning cl:nil)) strNum startIndex endOfOpenning)) (cl:values endOfOpenning CLISP_PHASE (tl:_+_ numOfSyntSwitchLevels 1)))))) (cl:t (cl:setf match (regexp:regexp-exec _CLISP_END_RE st :start startIndex)) (cl:cond (match (cl:cond ((tl:_==_ (tl:_-_ numOfSyntSwitchLevels 1) 0) (tl-append marks (makeStrElem CLISP_END_ELEM (tl:_+_ (tl:_getitem_ st (tl:_make-slice_ startIndex (cl:slot-value match 'regexp::start) cl:nil)) #\Newline) strNum startIndex (cl:slot-value match 'regexp::start))) (cl:values (cl:slot-value match 'regexp::end) REG_PHASE (tl:_-_ numOfSyntSwitchLevels 1))) (cl:t (tl-append marks (makeStrElem CLISP_MID_ELEM (tl:_getitem_ st (tl:_make-slice_ startIndex (cl:slot-value match 'regexp::end) cl:nil)) strNum startIndex (cl:slot-value match 'regexp::end))) (cl:values (cl:slot-value match 'regexp::end) CLISP_PHASE (tl:_-_ numOfSyntSwitchLevels 1))))) (cl:t (tl-append marks (makeStrElem CLISP_MID_ELEM (tl:_+_ (tl:_getitem_ st (tl:_make-slice_ startIndex cl:nil cl:nil)) #\Newline) strNum startIndex (len st))) (cl:values (len st) CLISP_PHASE numOfSyntSwitchLevels)))))))
(cl:defun _procAmpName (st strNum startIndex marks) ; how long is a symbol?
 (cl:let (end) (cl:setf end (_findEndOfExpr st (tl:_+_ startIndex 1) (tl:_make-vector_ :initContent (cl:list #\Space #\Tab #\( #\) #\, #\:)))) (cl:cond ((tl:_==_ end (tl:_+_ startIndex 1)) ; it is a lone operator &
 (tl-append marks (makeStrElem "&" "&" strNum startIndex (tl:_+_ startIndex 1))) (cl:setf end (tl:_+_ startIndex 1))) (cl:t (tl-append marks (makeStrElem SYMB_ELEM (tl:_getitem_ st (tl:_make-slice_ (tl:_+_ startIndex 1) end cl:nil)) strNum (tl:_+_ startIndex 1) end)))) end))
(cl:defun _OperLen (st startIndex) (cl:let (spChar) (cl:setf spChar (tl:_getitem_ st startIndex)) (cl:cond ((has_key MULTI_CHAR_OPERS spChar) (cl:let (opLen) (cl:setf opLen (tl:tl-for (oper (tl:_getitem_ MULTI_CHAR_OPERS spChar) (highestLenOper cl:nil)) ((len highestLenOper)) (cl:cond ((tl:_==_ (tl:_getitem_ st (tl:_make-slice_ startIndex (tl:_+_ startIndex (len oper)) cl:nil)) oper) (cl:cond ((tl:_<_ (len highestLenOper) (len oper)) (cl:setf highestLenOper oper))))))) (cl:cond ((tl:_==_ opLen 0) 1) (cl:t opLen)))) (cl:t 1))))
(cl:defun _procSpecialChars (st strNum startIndex marks) (cl:let (end) (cl:setf end (tl:_+_ startIndex (_OperLen st startIndex))) (tl-append marks (makeStrElem (tl:_getitem_ st (tl:_make-slice_ startIndex end cl:nil)) (tl:_getitem_ st (tl:_make-slice_ startIndex end cl:nil)) strNum startIndex end)) end))
(cl:defun _procSpecSynt (st strNum startIndex marks) (cl:let (operLen) (cl:setf operLen (_OperLen st startIndex)) (cl:let (end elemType) (cl:setf (cl:values end elemType) (cl:cond ((tl:_>_ operLen 1) (cl:values (tl:_+_ startIndex operLen) (tl:_getitem_ st (tl:_make-slice_ startIndex (tl:_+_ startIndex operLen) cl:nil)))) ((tl:_<_ (tl:_+_ startIndex 1) (len st)) (cl:let (end) (cl:setf end (_findEndOfExpr st (tl:_+_ startIndex 1) (tl:_make-vector_ :initContent (cl:list #\Space #\Tab #\( #\) #\,)))) (cl:cond ((tl:_==_ end (tl:_+_ startIndex 1)) (signalSyntaxError "Empty #-y structure"))) (cl:values end SYNT_STRUCT_ELEM))) (cl:t (signalSyntaxError "Empty #-y structure")))) (tl-append marks (makeStrElem elemType (tl:_getitem_ st (tl:_make-slice_ startIndex end cl:nil)) strNum startIndex end)) end)))
(cl:defun _procDotOrNum (st strNum startIndex marks) (cl:let (match) (cl:setf match (regexp:regexp-exec _DOT_FLOAT_RE st :start startIndex)) (cl:let (end elemType) (cl:setf (cl:values end elemType) (cl:cond (match ; this is a float number, like .34, or .34e-4
 (cl:values (cl:slot-value match 'regexp::end) NUM_ELEM)) (cl:t ; this a dot operator
 (cl:values (tl:_+_ startIndex 1) ".")))) (tl-append marks (makeStrElem elemType (tl:_getitem_ st (tl:_make-slice_ startIndex end cl:nil)) strNum startIndex end)) end)))
(cl:defun markElemsInStr (st strNum &optional (initPhase REG_PHASE) (clispSyntLevel 0)) (cl:let (marks) (cl:setf marks (tl:_make-vector_)) (cl:let (phase) (cl:setf phase initPhase) (cl:let (startIndex) (cl:setf startIndex 0) (cl:let (numOfSyntSwitchLevels) (cl:setf numOfSyntSwitchLevels clispSyntLevel) (cl:do () ((tl:_>=_ startIndex (len st))) (tl:tl-case phase cl:nil ((STRING_PHASE) (cl:setf (cl:values startIndex phase) (_procStringPhase st strNum startIndex marks))) ((CLISP_PHASE) (cl:setf (cl:values startIndex phase numOfSyntSwitchLevels) (_procCLispPhase st strNum startIndex marks numOfSyntSwitchLevels))) ((REG_PHASE) (cl:let (match) (cl:setf match (regexp:regexp-exec _WHITE_RE st :start startIndex)) (cl:cond (match (tl-append marks (makeStrElem WHITE_ELEM cl:nil strNum startIndex (cl:slot-value match 'regexp::end))) (cl:setf startIndex (cl:slot-value match 'regexp::end))) (cl:t (cl:setf match (regexp:regexp-exec _NON_WHITE_RE st :start startIndex)) (cl:let (nonWhiteEnd) (cl:setf nonWhiteEnd (cl:slot-value match 'regexp::end)) (cl:setf match (regexp:regexp-exec _CLISP_START_RE st :start startIndex :end nonWhiteEnd)) (cl:cond (match (cl:setf numOfSyntSwitchLevels 1) (tl-append marks (makeStrElem CLISP_START_ELEM cl:nil strNum startIndex cl:nil)) (cl:setf phase CLISP_PHASE) (cl:setf startIndex (cl:slot-value match 'regexp::end))) (cl:t (cl:setf match (regexp:regexp-exec _ALPHA_NUM_RE st :start startIndex :end nonWhiteEnd)) (cl:cond ((tl:_not_ match) ; have some special charachter (non alpha-num) in the beginning
 (cl:case (tl:_getitem_ st startIndex) ((#\&) (cl:setf startIndex (_procAmpName st strNum startIndex marks))) ((#\#) (cl:setf startIndex (_procSpecSynt st strNum startIndex marks))) ((#\.) (cl:setf startIndex (_procDotOrNum st strNum startIndex marks))) ((#\") (cl:setf (cl:values startIndex phase) (_startStringPhase strNum startIndex marks))) ((#\;) ; semicolomn starts comment, which extends till the end
 (tl-append marks (makeStrElem COMM_ELEM (tl:_getitem_ st (tl:_make-slice_ startIndex (len st) cl:nil)) strNum startIndex (len st))) (cl:setf startIndex (len st))) (cl:otherwise (cl:setf startIndex (_procSpecialChars st strNum startIndex marks))))) (cl:t ; have an alpha-num symbol or a number
 (cl:let (alphaNumEnd) (cl:setf alphaNumEnd (cl:slot-value match 'regexp::end)) (cl:setf match (regexp:regexp-exec _NUMBER_RE st :start startIndex)) (cl:cond (match (tl-append marks (makeStrElem NUM_ELEM (tl:_getitem_ st (tl:_make-slice_ startIndex (cl:slot-value match 'regexp::end) cl:nil)) strNum startIndex (cl:slot-value match 'regexp::end))) (cl:setf startIndex (cl:slot-value match 'regexp::end))) (cl:t ; have alpha-numeric symbol
 (cl:let (symb) (cl:setf symb (tl:_getitem_ st (tl:_make-slice_ startIndex alphaNumEnd cl:nil))) (cl:let (elType) (cl:setf elType (cl:cond ((tl:_==_ (tl-count SPEC_SYMB symb) 0) SYMB_ELEM) (cl:t (cl:cond ((tl:_==_ (tl-count OPER_SYMB symb) 0) SPEC_SYMB_ELEM) (cl:t symb))))) (tl-append marks (makeStrElem elType symb strNum startIndex alphaNumEnd)) (cl:setf startIndex alphaNumEnd))))))))))))))))) (cl:cond ((tl:_and_ (tl:_==_ (len st) 0) (tl:_==_ phase STRING_PHASE)) (tl-append marks (makeStrElem STR_MID_ELEM (string #\Newline) strNum 0 1)))) (tl-append marks (makeStrElem LINE_END_ELEM cl:nil strNum cl:nil cl:nil)) (cl:values marks phase numOfSyntSwitchLevels))))))
(cl:defclass GrowingVect () ((streamObj :initarg :streamObj) (lineNum :initarg :lineNum :initform 0) (stringPhase :initarg :stringPhase :initform REG_PHASE) (clispSyntLevel :initarg :clispSyntLevel :initform 0) (lineElems :initarg :lineElems :initform (tl:_make-vector_))))
(cl:defmethod initialize-instance :after ((gv GrowingVect) &key) (cl:let (firstLine) (cl:setf firstLine (__readLine (cl:slot-value gv 'streamObj))) (cl:cond (firstLine (cl:setf (cl:slot-value gv 'lineNum) 1) (cl:let (dropLine) (cl:setf dropLine (cl:cond ((tl:_>=_ (len firstLine) 2) (cl:cond ((tl:_==_ (tl:_getitem_ firstLine (tl:_make-slice_ cl:nil 2 cl:nil)) "#!") cl:t) (cl:t cl:nil))) (cl:t cl:nil))) (cl:cond (dropLine (__readLine gv)) (cl:t (cl:let (newElems) (cl:setf (cl:values newElems (cl:slot-value gv 'stringPhase) (cl:slot-value gv 'clispSyntLevel)) (markElemsInStr firstLine (cl:slot-value gv 'lineNum) (cl:slot-value gv 'stringPhase) (cl:slot-value gv 'clispSyntLevel))) (extend (cl:slot-value gv 'lineElems) newElems))))))) cl:nil))
(cl:defmethod __readLine ((str stream)) (read-line str cl:nil cl:nil))
(cl:defmethod __readLine ((gv GrowingVect)) (cl:let (line) (cl:setf line (__readLine (cl:slot-value gv 'streamObj))) (cl:cond (line (tl:_+=_ (cl:slot-value gv 'lineNum) 1) (cl:let (newElems) (cl:setf (cl:values newElems (cl:slot-value gv 'stringPhase) (cl:slot-value gv 'clispSyntLevel)) (markElemsInStr line (cl:slot-value gv 'lineNum) (cl:slot-value gv 'stringPhase) (cl:slot-value gv 'clispSyntLevel))) (extend (cl:slot-value gv 'lineElems) newElems)))) cl:nil))
(cl:defmethod len ((gv GrowingVect)) (len (cl:slot-value gv 'lineElems)))
(cl:defmethod _getitem_ ((gv GrowingVect) (index integer)) (tl:_getitem_ (cl:slot-value gv 'lineElems) index))
(cl:defmethod _getitem_ ((gv GrowingVect) (sl _slice_)) (tl:_getitem_ (cl:slot-value gv 'lineElems) sl))
(cl:defmethod growOnIndex ((gv GrowingVect) (index integer)) (cl:cond ((tl:_==_ index (len gv)) (__readLine gv))) index)
(cl:defmethod growOnIndex ((vec vector) (index integer)) index)
