;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defun formToText (form) (tl:tl-case (tl:_getitem_ form 0) ((error (tl:_%_ "Programming error: unknown form type: ~A" (tl:_getitem_ form 0)))) ((ATOM_TYPE) (tl:_getitem_ form 1)) ((FORM_TYPE) (cl:let (text) (cl:setf text "") (tl:tl-for (subForm (tl:_getitem_ form 1)) (cl:nil) (tl:_+=_ text (tl:_+_ (formToText subForm) " "))) (cl:cond ((tl:_>_ (len text) 0) (cl:setf text (tl:_getitem_ text (tl:_make-slice_ 0 (tl:_-_ (len text) 1) cl:nil))))) ; strip one space at the end
 (tl:_+_ (tl:_+_ "(" text) ")"))) ((COMMENT_TYPE) (tl:_+_ (tl:_getitem_ form 1) #\Newline)) ((SHORTCUT_TYPE) (tl:_+_ (tl:_getitem_ form 1) (formToText (tl:_getitem_ form 2))))))
(cl:defun writeTo (form &optional (dest cl:nil)) (cl:let (text) (cl:setf text (formToText form)) (cl:cond ((tl:_!=_ (tl:_getitem_ text (tl:_unary-_ 1)) #\Newline) (tl:_+=_ text #\Newline))) (cl:cond (dest (tl:_<<_ dest text)) (cl:t text))))
(cl:defun translate-streams (source dest &optional (lineNumbering cl:nil)) (tl:tl-for (form (getForms (new GrowingVect :streamObj source) (makeLevelInfo :implScope cl:t :explScopeWarn cl:t) lineNumbering)) (cl:nil) (writeTo form dest)))
(cl:defun translate-file (fName destFName) (with-open-file (sourceFile fName :direction :input) (with-open-file (destFile destFName :direction :output) (translate-streams sourceFile destFile))))
(cl:defclass ReaderWriter () ((firstLine :initform cl:t) (inStream :initarg :inStream :initform *standard-input*) (outStream :initarg :outStream :initform *standard-output*) (firstPrompt :initarg :firstPrompt :initform cl:nil) (secondPrompt :initarg :secondPrompt :initform cl:nil)))
(cl:defmethod __readLine ((rw ReaderWriter)) (cl:cond ((cl:slot-value rw 'firstLine) (cl:cond ((cl:slot-value rw 'firstPrompt) (fresh-line (cl:slot-value rw 'outStream)) (tl:_<<_ (cl:slot-value rw 'outStream) (cl:slot-value rw 'firstPrompt)))) (cl:setf (cl:slot-value rw 'firstLine) cl:nil)) (cl:t (cl:cond ((cl:slot-value rw 'secondPrompt) (fresh-line (cl:slot-value rw 'outStream)) (tl:_<<_ (cl:slot-value rw 'outStream) (cl:slot-value rw 'secondPrompt)))))) (__readLine (cl:slot-value rw 'inStream)))
(cl:defun getFormsOnOneExtendedLine (gL levelInfo source) (cl:handler-case (cl:progn (cl:let (form end) (cl:setf (cl:values form end) (getOneForm 0 gL levelInfo cl:nil)) (cl:cond (form (cl:let (lispString) (cl:setf lispString (writeTo form)) (cl:do () (cl:nil) (cl:let (newStartInd) (cl:setf newStartInd (cl:do ((i end (tl:_+_ i 1))) ((tl:_>=_ i (len (cl:slot-value gL 'lineElems))) cl:nil) (tl:tl-case (cl:slot-value (tl:_getitem_ (cl:slot-value gL 'lineElems) i) 'type) ((cl:return-from cl:nil i)) ((WHITE_ELEM LINE_END_ELEM COMM_ELEM ","))))) (cl:cond (newStartInd (cl:setf (cl:values form end) (getOneForm newStartInd gL levelInfo cl:nil)) (cl:cond (form (tl:_+=_ lispString (writeTo form))) (cl:t (cl:return-from cl:nil ())))) (cl:t (cl:return-from cl:nil ()))))) lispString)) (cl:t (translate levelInfo source))))) (tl-syntax-error (er) (tl:_<<_ (cl:slot-value source 'outStream) (tl:_%_ "SYNTAX ERROR:~%~A~%" er)) (translate levelInfo source))))
(cl:defun translate (&optional (levelInfo (makeLevelInfo)) (source (new ReaderWriter)) (output-bye cl:nil) (string-to-exit cl:nil)) (cl:setf (cl:slot-value source 'firstLine) cl:t) (cl:let (gL) (cl:setf gL (new GrowingVect :streamObj source)) ; read at least one line on initialization
 (cl:cond ((tl:_==_ (len gL) 0) ; this will be caused by Ctrl-D
 (cl:cond (output-bye (tl:_<<_ (tl:_<<_ (tl:_<<_ (cl:slot-value source 'outStream) #\Newline) "Bye.") #\Newline))) (cl:throw :exit ()))) (cl:cond (string-to-exit (cl:cond ((tl:_==_ (cl:slot-value (tl:_getitem_ gL 0) 'type) SYMB_ELEM) ; typing exit
 (cl:cond ((tl:_==_ (cl:slot-value (tl:_getitem_ gL 0) 'value) "exit") (cl:cond (output-bye (tl:_<<_ (tl:_<<_ (cl:slot-value source 'outStream) "Bye.") #\Newline))) (cl:throw :exit ()))))))) (getFormsOnOneExtendedLine gL levelInfo source)))
(cl:let ((twlType "twl") (lispType "lisp")) (cl:defun translate-files (fNames &optional (verbosity cl:nil)) (tl:tl-for (fName fNames) (cl:nil) (cl:let (destFName) (cl:setf destFName (cl:typecase fName (string (cl:cond ((tl:_==_ (tl:_getitem_ fName (tl:_make-slice_ (tl:_-_ (len fName) 4) cl:nil cl:nil)) (tl:_+_ "." twlType)) (tl:_+_ (tl:_+_ (tl:_getitem_ fName (tl:_make-slice_ 0 (tl:_-_ (len fName) 4) cl:nil)) ".") lispType)) (cl:t (tl:_+_ (tl:_+_ fName ".") lispType)))) (logical-pathname (merge-pathnames (make-pathname :type lispType) (translate-logical-pathname fName))) (pathname (merge-pathnames (make-pathname :type lispType) fName)) (cl:t (error "Function &translate-files accepts only either string or pathname as a filename")))) (cl:cond (verbosity (tl:_<<_ (cout) (tl:_%_ "~%Translating file ~A ..." fName)))) (cl:handler-case (cl:progn (translate-file fName destFName)) (tl-syntax-error (er) (tl:_<<_ (cout) (tl:_%_ "~%Syntax Error in file ~A:" fName)) (tl:_<<_ (cout) (tl:_%_ "~%~A~%" (cl:slot-value er 'message))) (tl:_<<_ (cout) (tl:_%_ "File ~A is empty" destFName)) (cl:return-from cl:nil ()))) (cl:cond (verbosity (tl:_<<_ (cout) (tl:_%_ "~%Wrote file ~A~%" destFName))))))))
