;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
; copying methods
(cl:defgeneric _copy_ (obj) (:documentation "This function is used by copy:copy(). Returns copy of an object.") (:method ((obj bit-vector)) obj) (:method ((obj character)) obj) (:method ((obj number)) obj) (:method ((obj string)) (copy-seq obj)) (:method ((obj symbol)) obj))
(cl:defgeneric _deepcopy_ (obj memo) (:documentation "This function is used by copy:deepcopy(). Returns a deep copy of an object and an update memo (hash-table with obj->objCopy mapping).") (:method ((obj bit-vector) memo) (cl:values obj memo)) (:method ((obj character) memo) (cl:values obj memo)) (:method ((obj number) memo) (cl:values obj memo)) (:method ((obj string) memo) (cl:values (copy-seq obj) memo)) (:method ((obj symbol) memo) (cl:values obj memo)))
;; getting states of objects or structure
(cl:flet ((slots-values-to-htab (obj) (tl:tl-for (slotDescr (clos:class-slots (class-of obj)) (tab (tl:_make-hash-table_))) (tab) (cl:cond ((slot-boundp obj (cl:slot-value slotDescr 'clos::$name)) (cl:setf (tl:_getitem_ tab (cl:slot-value slotDescr 'clos::$name)) (slot-value obj (cl:slot-value slotDescr 'clos::$name)))))))) (cl:defgeneric _getstate_ (obj) (:method ((obj structure-object)) (slots-values-to-htab obj)) (:method ((obj standard-object)) (slots-values-to-htab obj))))
;; setting states of objects or structure
(cl:flet ((set-slots-from-htab (obj state) (maphash #'(cl:lambda (key value) (cl:setf (slot-value obj key) value)) state))) (cl:defgeneric _setstate_ (obj state) (:method ((obj structure-object) state) (set-slots-from-htab obj state)) (:method ((obj standard-object) state) (set-slots-from-htab obj state))))
