;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
;; Macro new
(cl:defmacro new (c &rest rest) `(cl:cond ((subtypep ',c 'condition) (make-condition ',c ,@rest)) (cl:t (make-instance ',c ,@rest))))
;; TwinLisp's case
(cl:defmacro tl-case (x elseForm &rest isForms) (cl:let ((xval (gensym))) `(cl:let ((,xval ,x)) (cond ,@(mapcar #'(cl:lambda (isForm) `((or ,@(mapcar #'(cl:lambda (keyVal) `(_==_ ,xval ,keyVal)) (car isForm))) ,@(cdr isForm))) isForms) ,@(cl:cond (elseForm `((cl:t ,@elseForm))))))))
;; TwinLisp's for loop
(cl:defmacro tl-for ((var cont &rest restVars) resFormsList &body body) (cl:let ((it (gensym)) (nextPair (gensym))) `(cl:do* ((,it (iter ,cont)) (,nextPair (multiple-value-list (next ,it)) (multiple-value-list (next ,it))) (,var (first ,nextPair) (first ,nextPair)) ,@restVars) ((_not_ (second ,nextPair)) ,@resFormsList) ,@body)))
;; TwinLisp times loop
(cl:defmacro tl-times ((var maxVal &rest restVars) resFormsList &body body) `(cl:do* ((,var 0 (_+_ ,var 1)) ,@restVars) ((_>=_ ,var ,maxVal) ,@resFormsList) ,@body))
;; Shorter names macros
(cl:defmacro var (&rest rest) `(defvar ,@rest))
(cl:defmacro param (&rest rest) `(defparameter ,@rest))
(cl:defmacro const (&rest rest) `(defconstant ,@rest))
