;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;; load TL before using its methods
(cl:let ((tlPath (namestring (ext:cd)))) (cl:let (pathStr) (cl:setf pathStr (concatenate 'string tlPath "/**/")) (cl:setf (logical-pathname-translations "tl-sys") (cl:list (cl:list "**;*.*" pathStr) (cl:list ";**;*.*" pathStr)))))
(cl:let ((*error-output* (make-broadcast-stream))) ; bit sink, like dev/null
 (cl:load (logical-pathname "tl-sys:core;tl-def")))
;; set paths
(cl:let ((envTlPath (getenv "TLPATH")) (pathList (cl:list))) (cl:cond (envTlPath (cl:do (colInd) (cl:nil) (cl:setf colInd (index envTlPath #\:)) (cl:cond (colInd (cl:cond ((_!=_ (len (_getitem_ envTlPath (_make-slice_ cl:nil colInd cl:nil))) 0) (tl-append pathList (pathname (_getitem_ envTlPath (_make-slice_ cl:nil colInd cl:nil)))))) (cl:setf envTlPath (_getitem_ envTlPath (_make-slice_ (_+_ colInd 1) cl:nil cl:nil)))) (cl:t (cl:cond ((_!=_ (len envTlPath) 0) (tl-append pathList (pathname (_getitem_ envTlPath (_make-slice_ cl:nil colInd cl:nil)))))) (cl:return-from cl:nil ())))))) (cl:let (*tl-load-paths*) (cl:setf *tl-load-paths* (_+_ (_+_ (_getitem_ *tl-load-paths* (_make-slice_ cl:nil 1 cl:nil)) pathList) (_getitem_ *tl-load-paths* (_make-slice_ 1 cl:nil cl:nil))))))
;; adjust clisp's *load-paths*
(cl:setf *load-paths* (_+_ *tl-load-paths* *load-paths*))
;; act according to specified &*args*
(cl:let ((treplOn cl:nil) (verbose cl:nil) (fileToLoad cl:nil) (compiling cl:nil)) (cl:let (act) (cl:setf act (cl:block proc-arg (cl:do () ((endp *args*) :trepl) (cl:cond ((_==_ (_getitem_ (car *args*) 0) #\-) (tl-for (char (_getitem_ (car *args*) (_make-slice_ 1 cl:nil cl:nil))) (cl:nil) (cl:case char ((#\h) (cl:return-from proc-arg :help)) ((#\t) (cl:setf *args* (cdr *args*)) (cl:return-from proc-arg :translate)) ((#\i) (cl:setf treplOn cl:t)) ((#\v) (cl:setf verbose cl:t)) ((#\c) (cl:setf compiling cl:t))))) (cl:t (cl:setf fileToLoad (car *args*)) (cl:setf *args* (cdr *args*)) (cl:return-from proc-arg :load))) (cl:setf *args* (cdr *args*))))) (cl:case act ((:help) (_<<_ (cout) "usage: tlisp [ -h |
              [-i] [-v] -t files |
              [-i] [-v] [-c] file [args] ]
When no option or file given, TwinLisp interpreter is entered.
Available options:
 -h  : print this help message and exit
 -t  : translate files given after this option
 -i  : enter interpreter after loading a file, or translation
 -v  : verbose display
 -c  : file is loaded and statements are compiled on the fly
File is loaded and executed with &*args* == list(args).
Other environment variables:
TLSTARTUP : file executed on interactive startup (no default)")) ((:translate) (translate-files *args* verbose)) ((:trepl) (cl:handler-case (cl:progn (cl:let (startupFile) (cl:setf startupFile (getenv "TLSTARTUP")) (cl:cond ((_!=_ (len startupFile) 0) (cl:load startupFile))))) (error (er) (_<<_ (cout) (_%_ "~%Error occured while loading startup file:~%~A" er)))) (tl-load (logical-pathname "tl-sys:core;interpreter"))) ((:load) (tl-load fileToLoad :compiling compiling :verbose verbose :if-does-not-exist cl:t) (cl:cond (treplOn (tl-load (logical-pathname "tl-sys:core;interpreter"))))))))
