;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(_<<_ (_<<_ (_<<_ (cout) #\Newline) "Testing TwinLisp's copy module:") #\Newline)
(tl-require "copy")
(tl-require "unittest")
;;;
;;;  testing copying
;;;
(cl:defclass TestCopy (unittest:testcase) ((unittest:tName :initform "test-copy.twl") (unittest:tFuns :initform '(test-copy-list test-copy-vector test-copy-hash-table test-copy-atoms test-copy-structure test-copy-object))))
(cl:defmethod test-copy-list ((ts TestCopy)) (cl:let (a) (cl:setf a (cl:list)) (unittest:assertEqual ts (copy:copy a) (cl:list)) (cl:let (b) (cl:setf b (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4)) 6)) (cl:setf (_getitem_ b 3) b) (cl:let (d) (cl:setf d (copy:copy b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b 2) (_getitem_ d 2))) (unittest:assertTrue ts (eq (_getitem_ d 3) b))))))
(cl:defmethod test-copy-vector ((ts TestCopy)) (cl:let (a) (cl:setf a (_make-vector_)) (unittest:assertEqual ts (copy:copy a) (_make-vector_)) (cl:let (b) (cl:setf b (_make-vector_ :initContent (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4)) 6))) (cl:setf (_getitem_ b 3) b) (cl:let (d) (cl:setf d (copy:copy b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b 2) (_getitem_ d 2))) (unittest:assertTrue ts (eq (_getitem_ d 3) b))))))
(cl:defmethod test-copy-hash-table ((ts TestCopy)) (cl:let (a) (cl:setf a (_make-hash-table_)) (unittest:assertEqual ts (copy:copy a) (_make-hash-table_)) (cl:let (b) (cl:setf b (_make-hash-table_ "vect" (_make-vector_) "list" (cl:list 1 2) "a" 1)) (cl:let (d) (cl:setf d (copy:copy b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b "vect") (_getitem_ d "vect"))) (unittest:assertTrue ts (eq (_getitem_ b "list") (_getitem_ d "list")))))))
(cl:defmethod test-copy-atoms ((ts TestCopy)) (tl-for (a (_make-vector_ :initContent (cl:list 7 "abc" #\a #*1010 'ts)) b) (cl:nil) (cl:setf b (copy:copy a)) (unittest:assertEqual ts a b)))
; some structure
(cl:defstruct (strBar) a b c)
(cl:defmethod test-copy-structure ((ts TestCopy)) (cl:let (a) (cl:setf a (new strBar :a "a" :b (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4))) :c (new strBar))) (cl:let (b) (cl:setf b (copy:copy a)) (unittest:assertNotEqual ts a b) (unittest:assertEqual ts (cl:slot-value a 'a) (cl:slot-value b 'a)) (unittest:assertTrue ts (eq (cl:slot-value a 'b) (cl:slot-value b 'b))) (unittest:assertTrue ts (eq (cl:slot-value a 'c) (cl:slot-value b 'c))))))
; some class
(cl:defclass clBar () ((a :initarg :a) (b :initarg :b) (c :initarg :c) d))
(cl:defmethod test-copy-object ((ts TestCopy)) (cl:let (a) (cl:setf a (new clBar :a "a" :b (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4))) :c (new clBar))) (cl:let (b) (cl:setf b (copy:copy a)) (unittest:assertNotEqual ts a b) (unittest:assertEqual ts (cl:slot-value a 'a) (cl:slot-value b 'a)) (unittest:assertTrue ts (eq (cl:slot-value a 'b) (cl:slot-value b 'b))) (unittest:assertTrue ts (eq (cl:slot-value a 'c) (cl:slot-value b 'c))) (unittest:assertFalse ts (slot-boundp a 'd)))))
;;---------------------------------------
;;;
;;;  testing deepcopying
;;;
(cl:defclass TestDeepcopy (unittest:testcase) ((unittest:tName :initform "test-copy.twl") (unittest:tFuns :initform '(test-deepcopy-list test-deepcopy-vector test-deepcopy-hash-table test-deepcopy-atoms test-deepcopy-structure test-deepcopy-object))))
(cl:defmethod test-deepcopy-atoms ((ts TestDeepcopy)) (tl-for (a (_make-vector_ :initContent (cl:list 7 "abc" #\a #*1010 'ts)) b) (cl:nil) (cl:setf b (copy:deepcopy a)) (unittest:assertEqual ts a b)))
(cl:defmethod test-deepcopy-list ((ts TestDeepcopy)) (cl:let (a) (cl:setf a (cl:list)) (unittest:assertEqual ts (copy:deepcopy a) (cl:list)) (cl:let (b) (cl:setf b (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4)) 6)) (cl:setf (_getitem_ b 3) b) (cl:let (d) (cl:setf d (copy:deepcopy b)) (unittest:assertFalse ts (eq b d)) (tl-for (i (cl:list 0 1 2)) (cl:nil) (unittest:assertEqual ts (_getitem_ b i) (_getitem_ d i))) (unittest:assertFalse ts (eq (_getitem_ b 2) (_getitem_ d 2))) (unittest:assertFalse ts (eq (_getitem_ d 3) b)) (unittest:assertTrue ts (eq (_getitem_ d 3) d))))))
(cl:defmethod test-deepcopy-vector ((ts TestDeepcopy)) (cl:let (a) (cl:setf a (_make-vector_)) (unittest:assertEqual ts (copy:deepcopy a) (_make-vector_)) (cl:let (b) (cl:setf b (_make-vector_ :initContent (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4)) 6))) (cl:setf (_getitem_ b 3) b) (cl:let (d) (cl:setf d (copy:deepcopy b)) (unittest:assertFalse ts (eq b d)) (tl-for (i (cl:list 0 1 2)) (cl:nil) (unittest:assertEqual ts (_getitem_ b i) (_getitem_ d i))) (unittest:assertFalse ts (eq (_getitem_ b 2) (_getitem_ d 2))) (unittest:assertFalse ts (eq (_getitem_ d 3) b)) (unittest:assertTrue ts (eq (_getitem_ d 3) d))))))
(cl:defmethod test-deepcopy-hash-table ((ts TestDeepcopy)) (cl:let (a) (cl:setf a (_make-hash-table_)) (unittest:assertEqual ts (copy:deepcopy a) (_make-hash-table_)) (cl:let (b) (cl:setf b (_make-hash-table_ "vect" (_make-vector_) "list" (cl:list 1 2) "a" 1)) (cl:let (d) (cl:setf d (copy:deepcopy b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertFalse ts (eq (_getitem_ b "vect") (_getitem_ d "vect"))) (unittest:assertFalse ts (eq (_getitem_ b "list") (_getitem_ d "list")))))))
(cl:defmethod test-deepcopy-structure ((ts TestDeepcopy)) (cl:let (a) (cl:setf a (new strBar :a "a" :b (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4))) :c (new strBar))) (cl:let (b) (cl:setf b (copy:deepcopy a)) (unittest:assertNotEqual ts a b) (unittest:assertEqual ts (cl:slot-value a 'a) (cl:slot-value b 'a)) (unittest:assertEqual ts (cl:slot-value a 'b) (cl:slot-value b 'b)) (unittest:assertFalse ts (eq (cl:slot-value a 'b) (cl:slot-value b 'b))) (unittest:assertFalse ts (eq (cl:slot-value a 'c) (cl:slot-value b 'c))))))
(cl:defmethod test-deepcopy-object ((ts TestDeepcopy)) (cl:let (a) (cl:setf a (new clBar :a "a" :b (cl:list 1 2 (_make-vector_ :initContent (cl:list 3 4))) :c (new clBar))) (cl:let (b) (cl:setf b (copy:deepcopy a)) (unittest:assertNotEqual ts a b) (unittest:assertEqual ts (cl:slot-value a 'a) (cl:slot-value b 'a)) (unittest:assertEqual ts (cl:slot-value a 'b) (cl:slot-value b 'b)) (unittest:assertFalse ts (eq (cl:slot-value a 'b) (cl:slot-value b 'b))) (unittest:assertFalse ts (eq (cl:slot-value a 'c) (cl:slot-value b 'c))) (unittest:assertFalse ts (slot-boundp a 'd)))))
;; run the test
(unittest:runSuites '(TestCopy TestDeepcopy) :verbosity 1)
