;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defun formToText (form) (tl-case (_getitem_ form 0) ((error (_%_ "Programming error: unknown form type: ~A" (_getitem_ form 0)))) ((ATOM_TYPE) (_getitem_ form 1)) ((FORM_TYPE) (cl:let (text) (cl:setf text "") (tl-for (subForm (_getitem_ form 1)) (cl:nil) (_+=_ text (_+_ (formToText subForm) " "))) (cl:cond ((_>_ (len text) 0) (cl:setf text (_getitem_ text (_make-slice_ 0 (_-_ (len text) 1) cl:nil))))) ; strip one space at the end
 (_+_ (_+_ "(" text) ")"))) ((COMMENT_TYPE) (_+_ (_getitem_ form 1) #\Newline)) ((SHORTCUT_TYPE) (_+_ (_getitem_ form 1) (formToText (_getitem_ form 2))))))
(cl:defun writeTo (form &optional (dest cl:nil)) (cl:let (text) (cl:setf text (formToText form)) (cl:cond ((_!=_ (_getitem_ text (_unary-_ 1)) #\Newline) (_+=_ text #\Newline))) (cl:cond (dest (_<<_ dest text)) (cl:t text))))
(cl:defun translate-streams (source dest &optional (lineNumbering cl:nil)) (tl-for (form (getForms (new GrowingVect :streamObj source) (makeLevelInfo :implScope cl:t :explScopeWarn cl:t) lineNumbering)) (cl:nil) (writeTo form dest)))
(cl:defun translate-file (fName destFName) (with-open-file (sourceFile fName :direction :input) (with-open-file (destFile destFName :direction :output) (translate-streams sourceFile destFile))))
(cl:defclass ReaderWriter () ((firstLine :initform cl:t) (inStream :initarg :inStream :initform *standard-input*) (outStream :initarg :outStream :initform *standard-output*)))
(cl:defmethod __readLine ((rw ReaderWriter)) (cl:cond ((cl:slot-value rw 'firstLine) (_<<_ (cl:slot-value rw 'outStream) ">>> ") (cl:setf (cl:slot-value rw 'firstLine) cl:nil)) (cl:t (_<<_ (cl:slot-value rw 'outStream) "... "))) (__readLine (cl:slot-value rw 'inStream)))
(cl:defun translate (&optional (levelInfo (makeLevelInfo)) (source (new ReaderWriter))) (cl:setf (cl:slot-value source 'firstLine) cl:t) (cl:let (gL) (cl:setf gL (new GrowingVect :streamObj source)) (cl:cond ((_==_ (len gL) 0) ; this will be caused by Ctrl-D
 (_<<_ (_<<_ (_<<_ (cl:slot-value source 'outStream) #\Newline) "Bye.") #\Newline) (cl:throw :exit ()))) (cl:cond ((_==_ (cl:slot-value (_getitem_ gL 0) 'type) SYMB_ELEM) ; typing exit
 (cl:cond ((_==_ (cl:slot-value (_getitem_ gL 0) 'value) "exit") (_<<_ (_<<_ (cl:slot-value source 'outStream) "Bye.") #\Newline) (cl:throw :exit ()))))) (cl:handler-case (cl:progn (cl:let (form) (cl:setf form (getOneForm 0 gL levelInfo cl:nil)) (cl:cond (form (writeTo form)) (cl:t (translate levelInfo source))))) (tl-syntax-error (er) (_<<_ (cl:slot-value source 'outStream) (_%_ "SYNTAX ERROR:~%~A~%" er)) (translate levelInfo source)))))
(cl:let ((twlType "twl") (lispType "lisp")) (cl:defun translate-files (fNames &optional (verbosity cl:nil)) (tl-for (fName fNames) (cl:nil) (cl:let (destFName) (cl:setf destFName (cl:typecase fName (string (cl:cond ((_==_ (_getitem_ fName (_make-slice_ (_-_ (len fName) 4) cl:nil cl:nil)) (_+_ "." twlType)) (_+_ (_+_ (_getitem_ fName (_make-slice_ 0 (_-_ (len fName) 4) cl:nil)) ".") lispType)) (cl:t (_+_ (_+_ fName ".") lispType)))) (logical-pathname (merge-pathnames (make-pathname :type lispType) (translate-logical-pathname fName))) (pathname (merge-pathnames (make-pathname :type lispType) fName)) (cl:t (error "Function &translate-files accepts only either string or pathname as a filename")))) (cl:cond (verbosity (_<<_ (cout) (_%_ "~%Translating file ~A ..." fName)))) (cl:handler-case (cl:progn (translate-file fName destFName)) (tl-syntax-error (er) (_<<_ (cout) (_%_ "~%Syntax Error in file ~A:" fName)) (_<<_ (cout) (_%_ "~%~A~%" (cl:slot-value er 'message))) (_<<_ (cout) (_%_ "File ~A is empty" destFName)) (cl:return-from cl:nil ()))) (cl:cond (verbosity (_<<_ (cout) (_%_ "~%Wrote file ~A~%" destFName))))))))
