;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defclass TestTranslFormBuildingThree (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuildingThree.twl") (unittest:tFuns :initform '(test-getForms-Struct-1 test-getForms-Struct-2 test-getForms-Struct-3 test-getForms-Struct-4 test-getForms-Struct-5 test-getForms-Class-1 test-getForms-Class-2 test-getForms-Class-3 test-getForms-Class-4 test-getForms-Class-5 test-getForms-Meth-1 test-getForms-Meth-2 test-getForms-Meth-3 test-getForms-Use-1 test-getForms-Use-2 test-getForms-Use-3 test-getForms-Use-4 test-getForms-Use-5 test-getForms-ImplicitLexscope-1 test-getForms-ImplicitLexscope-2 test-getForms-ImplicitLexscope-3 test-getForms-ImplicitLexscope-4 test-getForms-ImplicitLexscope-5 test-getForms-ImplicitLexscope-6 test-getForms-ImplicitLexscope-7 test-getForms-ImplicitLexscope-8 test-getForms-ImplicitLexscope-9 test-getForms-ImplicitLexscope-10 test-getForms-ImplicitLexscope-11 test-getForms-ImplicitLexscope-12 test-getForms-ImplicitLexscope-13 test-getForms-ImplicitLexscope-14 test-getForms-ImplicitLexscope-15 test-getForms-ImplicitLexscope-16))))
(cl:defmethod test-getForms-Struct-1 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "struct foo {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defstruct") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))))))))))))
(cl:defmethod test-getForms-Struct-2 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "struct foo {a b
                      c}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defstruct") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))) (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "c"))))))))))
(cl:defmethod test-getForms-Struct-3 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "struct foo {a{0} b{1}
                      c}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defstruct") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "0")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "1")))) (cl:list ATOM_TYPE "c"))))))))))
(cl:defmethod test-getForms-Struct-4 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "struct foo { a {0,:type=integer}
                       b {1,:&read-only }
                       c}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defstruct") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "0") (cl:list ATOM_TYPE ":type") (cl:list ATOM_TYPE "integer")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "1") (cl:list ATOM_TYPE ":read-only")))) (cl:list ATOM_TYPE "c"))))))))))
(cl:defmethod test-getForms-Struct-5 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "struct foo { a {0,:type=integer}
                       b {1,:&read-only }}
          options {:include=boo,:named}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defstruct") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":include") (cl:list ATOM_TYPE "boo")))) (cl:list ATOM_TYPE ":named")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "0") (cl:list ATOM_TYPE ":type") (cl:list ATOM_TYPE "integer")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "1") (cl:list ATOM_TYPE ":read-only")))))))))))))
(cl:defmethod test-getForms-Class-1 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "class foo {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defclass") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_)) (cl:list FORM_TYPE (_make-vector_)))))))))))
(cl:defmethod test-getForms-Class-2 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "class foo {a b
                     c}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defclass") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_)) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "c")))))))))))))
(cl:defmethod test-getForms-Class-3 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "class foo {
              a {:type=integer}
              c}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defclass") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_)) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE ":type") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "c")))))))))))))
(cl:defmethod test-getForms-Class-4 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "class foo {
              a {:type=integer}
              c}
           options {
               :documentation=\"doc-string\"
               :metaclass=boo}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defclass") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_)) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE ":type") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "c")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"doc-string\"")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":metaclass") (cl:list ATOM_TYPE "boo")))))))))))))
(cl:defmethod test-getForms-Class-5 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "class foo (super1,super2) {
              a {:type=integer}
              ; this comment will be dropped out entirely
              c}
          options {
              :documentation=\"doc-string\"
              :metaclass=boo}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defclass") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "super1") (cl:list ATOM_TYPE "super2")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE ":type") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "c")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"doc-string\"")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":metaclass") (cl:list ATOM_TYPE "boo")))))))))))))
(cl:defmethod test-getForms-Meth-1 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "meth foo (a){}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmethod") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))))))))))))
(cl:defmethod test-getForms-Meth-2 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "meth foo :after (a){}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmethod") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE ":after") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))))))))))))
(cl:defmethod test-getForms-Meth-3 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "meth setter foo (a){}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmethod") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "foo")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))))))))))))
(cl:defmethod test-getForms-Use-1 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "use foo {x,y,z}
          x(a)
          y(b)
          z(c)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo:x") (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo:y") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo:z") (cl:list ATOM_TYPE "c"))))))))))
(cl:defmethod test-getForms-Use-2 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "use foo {x=e,y=f,z}
          e(a)
          x(a)
          f(b)
          y(b)
          z(c)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo:x") (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo:y") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo:z") (cl:list ATOM_TYPE "c"))))))))))
(cl:defmethod test-getForms-Use-3 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "use foo: {x,y,z}
          x(a)
          y(b)
          z(c)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo::x") (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo::y") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo::z") (cl:list ATOM_TYPE "c"))))))))))
(cl:defmethod test-getForms-Use-4 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "use foo {x}
          func(x)
          func(:x)
          func(cl:x)
          func(cl::x)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "func") (cl:list ATOM_TYPE "foo:x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "func") (cl:list ATOM_TYPE ":x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "func") (cl:list ATOM_TYPE "cl:x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "func") (cl:list ATOM_TYPE "cl::x"))))))))))
(cl:defmethod test-getForms-Use-5 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "use {x=a,y=b}
          a(1)
          b(2)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "2"))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-1 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=1
              foo(x)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x"))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-2 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=y=1
              foo(x)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "1"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x"))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-3 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=0
              y=1
              foo(x)
              z:a=2}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "0")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "z:a") (cl:list ATOM_TYPE "2")))))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-4 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=1
              global y
              y=0
              foo(x)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "0")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x"))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-5 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=1
              x=0
              foo(x)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "0")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x"))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-6 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=1
              lexscope explicit
              y=0
              foo(x)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "0")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x"))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-7 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=0
              lexscope explicit
              z=1
              lexscope implicit
              y=2
              foo(x)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "0")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "z") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "2")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-8 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=0
              lexscope explicit
              z=1
              lexscope implicit
              y=2
              foo(x)}") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo :implScope cl:t :explScopeWarn cl:t))))))
(cl:defmethod test-getForms-ImplicitLexscope-9 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              foo(x)
              x=0
              lexscope explicit
              global z
              z=1
              lexscope implicit
              y=2
              foo(x)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t :explScopeWarn cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "0")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "z") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "2")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "x")))))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-10 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "def foo (a) {
              a = 1
              b = 2}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t :explScopeWarn cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "2"))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-11 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "mac foo (a) {
              a = 1
              b = 2}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmacro") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "2")))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-12 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "a = 1
          b = 2
          mac foo (a) {
              a = 1
              b = 2}") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo :implScope cl:t :explScopeWarn cl:t))))))
(cl:defmethod test-getForms-ImplicitLexscope-13 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "a = 1
          b = 2
          mac foo (a) {
              a = 1
              global b
              b = 2}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t :explScopeWarn cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "2")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmacro") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "2")))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-14 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "a = 1
          b = 2
          def foo (a) {
              a = 1
              b = 2}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t :explScopeWarn cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "2")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "1")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "2"))))))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-15 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "def foo (a,b=lambda{a=1}) { a=9 }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t :explScopeWarn cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:lambda") (cl:list FORM_TYPE (_make-vector_)) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "1")))))))))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "9")))))))))))))
(cl:defmethod test-getForms-ImplicitLexscope-16 ((ts TestTranslFormBuildingThree)) (cl:let (st) (cl:setf st "progn{
              x @ y = foo()
              x+y}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:values") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y"))))))))))))))))
