;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
;; Operator 'not'
(cl:defgeneric _not_ (obj) (:method ((obj cl:t)) (not obj)) (:method ((bitVect bit-vector)) (bit-not bitVect)))
;; Operator 'and'
(cl:defgeneric _and_ (fst snd) (:method ((fst cl:t) (snd cl:t)) (and fst snd)) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-and fstBitVect sndBitVect)))
;; Operator 'or'
(cl:defgeneric _or_ (fst snd) (:method ((fst cl:t) (snd cl:t)) (or fst snd)) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-ior fstBitVect sndBitVect)))
;; Operator 'xor' (exclusive or)
(cl:defgeneric _xor_ (fst snd) (:method ((fst cl:t) (snd cl:t)) (_and_ (_or_ fst snd) (_or_ (_not_ fst) (_not_ snd)))) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-xor fstBitVect sndBitVect)))
;; Equality operator '=='
(cl:defgeneric _==_ (fst snd) (:method ((fstNum number) (sndNum number)) (= fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char= fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string= fstStr sndStr)) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (equal fstBitVect sndBitVect)) (:method ((fstVect vector) (sndVect vector)) (cl:cond ((eq fstVect sndVect) cl:t) ((_==_ (len fstVect) (len sndVect)) (cl:let (vecLen) (cl:setf vecLen (len fstVect)) (cl:do ((i 0 (_+_ i 1))) ((_>=_ i vecLen) cl:t) (cl:cond ((_!=_ (_getitem_ fstVect i) (_getitem_ sndVect i)) (cl:return-from cl:nil cl:nil)))))) (cl:t cl:nil))) (:method ((fstLst list) (sndLst list)) (cl:cond ((eq fstLst sndLst) cl:t) (cl:t (cl:do ((fstCons fstLst) (sndCons sndLst)) (cl:nil) (cl:cond ((endp fstCons) (cl:return-from cl:nil (endp sndCons))) (cl:t (cl:cond ((endp sndCons) (cl:return-from cl:nil cl:nil)) (cl:t (cl:cond ((_!=_ (car fstCons) (car sndCons)) (cl:return-from cl:nil cl:nil)) ((_==_ (cdr fstCons) (cdr sndCons)) (cl:return-from cl:nil cl:t)) (cl:t (cl:setf fstCons (cdr fstCons)) (cl:setf sndCons (cdr sndCons)) (cl:cond ((_or_ (eq fstCons fstLst) (eq sndCons sndLst)) (cl:return-from cl:nil (_and_ (eq fstCons fstLst) (eq sndCons sndLst))))))))))))))) (:method ((fstTab hash-table) (sndTab hash-table)) (cl:cond ((eq fstTab sndTab) cl:t) ((_==_ (len fstTab) (len sndTab)) (maphash #'(cl:lambda (fstKey fstVal) (cl:let (sndVal keyPresent) (cl:setf (cl:values sndVal keyPresent) (_getitem_ sndTab fstKey)) (cl:cond ((_or_ (_not_ keyPresent) (_!=_ sndVal fstVal)) (cl:return-from _==_ cl:nil))))) fstTab) cl:t) (cl:t cl:nil))) (:method ((fst cl:t) (snd cl:t)) (eq fst snd)))
;; Non-equality operator '!='
(cl:defgeneric _!=_ (fst snd) (:method ((fst cl:t) (snd cl:t)) (_not_ (_==_ fst snd))))
;; Smaller-then operator '<'
(cl:defgeneric _<_ (fst snd) (:method ((fstNum number) (sndNum number)) (< fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char< fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string< fstStr sndStr)))
;; Smaller-or-equal operator '<='
(cl:defgeneric _<=_ (fst snd) (:method ((fstNum number) (sndNum number)) (<= fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char<= fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string<= fstStr sndStr)))
;; Greater-then operator '>'
(cl:defgeneric _>_ (fst snd) (:method ((fstNum number) (sndNum number)) (> fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char> fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string> fstStr sndStr)))
;; Greater-or-equal operator '>='
(cl:defgeneric _>=_ (fst snd) (:method ((fstNum number) (sndNum number)) (>= fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char>= fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string>= fstStr sndStr)))
;; Addition operator '+'
(cl:defgeneric _+_ (fst snd) (:method ((fstNum number) (sndNum number)) (+ fstNum sndNum)) (:method ((fstLst list) (sndLst list)) (concatenate 'list fstLst sndLst)) (:method ((fstVect vector) (sndVect vector)) (cl:let (resultVect) (cl:setf resultVect (_make-vector_)) (extend resultVect fstVect sndVect) resultVect)) (:method ((fstStr string) (sndStr string)) (concatenate 'string fstStr sndStr)) (:method ((str string) (char character)) (concatenate 'string str (string char))) (:method ((char character) (str string)) (concatenate 'string (string char) str)))
;; Unary plus
(cl:defgeneric _unary+_ (obj) (:method ((num number)) num))
;; Subtraction operator '-'
(cl:defgeneric _-_ (fst snd) (:method ((fstNum number) (sndNum number)) (- fstNum sndNum)))
;; Unary minus
(cl:defgeneric _unary-_ (obj) (:method ((num number)) (- num)))
;; Multiplication operator '*'
(cl:defgeneric _*_ (fst snd) (:method ((fstNum number) (sndNum number)) (* fstNum sndNum)))
;; Division operator '/'
(cl:defgeneric _/_ (fst snd) (:method ((fstNum number) (sndNum number)) (/ fstNum sndNum)))
;; Modulus division operator '%'
(cl:defgeneric _%_ (fst snd) (:method ((fstInt integer) (sndInt integer)) (nth-value 0 (floor fstInt sndInt))) (:method ((fstStr string) (sndStr string)) (apply #'format (cl:list cl:nil fstStr sndStr))) (:method ((str string) (lst list)) (cl:cond ((null lst) (apply #'format (cl:list cl:nil str cl:nil))) (cl:t (apply #'format (_+_ (cl:list cl:nil str) lst))))) (:method ((str string) (obj cl:t)) (apply #'format (cl:list cl:nil str obj))) (:method ((str string) (seq sequence)) (apply #'format (_+_ (cl:list cl:nil str) (coerce seq 'list)))))
;; Exponentiation operator '**'
(cl:defgeneric _**_ (fst snd) (:method ((fstNum number) (sndNum number)) (expt fstNum sndNum)))
;; Appending operator '<<'
(cl:defgeneric _<<_ (fst snd) (:method ((lst list) (obj cl:t)) (err-on-null lst "Operator '<<' cannot append to null list") (cl:setf (cdr (last lst)) (cl:list obj)) lst) (:method ((vec vector) (obj cl:t)) (vector-push-extend obj vec) vec) (:method ((str stream) (s string)) (write-string s str) str) (:method ((str stream) (char character)) (write-char char str) str) (:method ((str stream) (int integer)) (write-byte int str) str))
