;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
; copying methods
(cl:defgeneric _copy_ (obj) (:documentation "This function is used by copy:copy(). Returns copy of an object.") (:method ((obj bit-vector)) obj) (:method ((obj character)) obj) (:method ((obj number)) obj) (:method ((obj string)) obj) (:method ((obj symbol)) obj))
(cl:defgeneric _deepcopy_ (obj memo) (:documentation "This function is used by copy:deepcopy(). Returns a deep copy of an object and an update memo (hash-table with obj->objCopy mapping).") (:method ((obj bit-vector) memo) (cl:values obj memo)) (:method ((obj character) memo) (cl:values obj memo)) (:method ((obj number) memo) (cl:values obj memo)) (:method ((obj string) memo) (cl:values obj memo)) (:method ((obj symbol) memo) (cl:values obj memo)))
