;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:defclass TestContainerMeths (unittest:testcase) ((unittest:tName :initform "TestContainerMeths.twl") (unittest:tFuns :initform '(test-list-methods test-vector-methods test-array-methods test-hashTable-methods1 test-hashTable-methods2))))
(cl:defmethod test-list-methods ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (cl:list)) (unittest:assertEqual ts (len a) 0) (cl:let (b) (cl:setf b (cl:list 1 2 "k")) (unittest:assertEqual ts (len b) 3) (unittest:assertCondition ts index-error (_getitem_ a 0) :textOnFail "index should be out of range") (unittest:assertEqual ts (_getitem_ b 0) 1) (unittest:assertEqual ts (_getitem_ b (_unary-_ 2)) 2) (cl:setf (_getitem_ b (_unary-_ 1)) 3) (unittest:assertEqual ts b (cl:list 1 2 3)) (unittest:assertCondition ts null-list-error (tl-append a "s") :textOnFail "assert is not supposed to work for nil, so error is raised") (tl-append b (cl:list "a" "b") (_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (_make-vector_)) (unittest:assertEqual ts b (cl:list 1 2 3 (cl:list "a" "b") (_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (_make-vector_))) (unittest:assertCondition ts null-list-error (extend a (cl:list "s" "t")) :textOnFail "extend is not supposed to work for nil, so error is raised") (cl:let (c) (cl:setf c (cons cl:nil cl:nil)) (extend c (cl:list "a" "b") (_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (_make-vector_)) (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c" "d")) (unittest:assertCondition ts null-list-error (insert a 0 "s") :textOnFail "insert is not supposed to work for nil, so error is raised") (insert c 0 "s") (unittest:assertEqual ts c (cl:list "s" cl:nil "a" "b" "c" "d")) (insert c (_unary-_ 1) "t") (unittest:assertEqual ts c (cl:list "s" cl:nil "a" "b" "c" "d" "t")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 4 cl:nil cl:nil)) (cl:list "c" "d" "t")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 4 5 cl:nil)) (cl:list "c")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 5 4 cl:nil)) (cl:list)) (unittest:assertEqual ts (_getitem_ c (_make-slice_ cl:nil 2 cl:nil)) (cl:list "s" cl:nil)) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 0 cl:nil 2)) (cl:list "s" "a" "c" "t")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 2 5 2)) (cl:list "a" "c")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 9 10 cl:nil)) (cl:list)) (unittest:assertEqual ts (tl-pop c 0) "s") (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c" "d" "t")) (unittest:assertEqual ts (tl-pop c (_unary-_ 1)) "t") (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c" "d")) (unittest:assertEqual ts (tl-pop c) "d") (unittest:assertEqual ts c (cl:list cl:nil "a" "b" "c")) (unittest:assertEqual ts (tl-remove c "c") 3) (unittest:assertEqual ts c (cl:list cl:nil "a" "b")) (unittest:assertEqual ts (tl-remove c "z") cl:nil) (unittest:assertEqual ts c (cl:list cl:nil "a" "b")) (unittest:assertEqual ts (index c cl:nil) 0) (unittest:assertEqual ts (index c "b") 2) (unittest:assertEqual ts (index c "z") cl:nil) (unittest:assertEqual ts (tl-count c "b") 1) (unittest:assertEqual ts (tl-count c "z") 0) (insert c 0 "b") (unittest:assertEqual ts (tl-count c "b") 2) (unittest:assertEqual ts (_copy_ a) (cl:list)) (cl:let (d) (cl:setf d (_copy_ b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b 3) (_getitem_ d 3))) (unittest:assertTrue ts (eq (_getitem_ b 4) (_getitem_ d 4))) (unittest:assertTrue ts (eq (_getitem_ b 6) (_getitem_ d 6))) (cl:setf c (cl:list 0 1 2 3 4 5 6 7 8 9)) (tl-pop c 5) (unittest:assertEqual ts c (cl:list 0 1 2 3 4 6 7 8 9)))))))
(cl:defmethod test-vector-methods ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (_make-vector_)) (unittest:assertEqual ts (len a) 0) (cl:let (b) (cl:setf b (_make-vector_ :initContent (cl:list 1 2 "k"))) (unittest:assertEqual ts (len b) 3) (unittest:assertCondition ts index-error (_getitem_ a 0) :textOnFail "index should be out of range") (unittest:assertEqual ts (_getitem_ b 0) 1) (unittest:assertEqual ts (_getitem_ b (_unary-_ 2)) 2) (cl:setf (_getitem_ b (_unary-_ 1)) 3) (unittest:assertEqual ts b (_make-vector_ :initContent (cl:list 1 2 3))) (tl-append a 1 2) (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 1 2))) (tl-append b (cl:list "a" "b") (_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (_make-vector_)) (unittest:assertEqual ts b (_make-vector_ :initContent (cl:list 1 2 3 (cl:list "a" "b") (_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (_make-vector_)))) (extend a (cl:list "a" "b") (_make-vector_ :initContent (cl:list "c" "d")) (cl:list) (_make-vector_)) (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 1 2 "a" "b" "c" "d"))) (insert a 0 "s") (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list "s" 1 2 "a" "b" "c" "d"))) (insert a (_unary-_ 1) "t") (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list "s" 1 2 "a" "b" "c" "d" "t"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 5 cl:nil cl:nil)) (_make-vector_ :initContent (cl:list "c" "d" "t"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 5 6 cl:nil)) (_make-vector_ :initContent (cl:list "c"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 6 5 cl:nil)) (_make-vector_)) (unittest:assertEqual ts (_getitem_ a (_make-slice_ cl:nil 2 cl:nil)) (_make-vector_ :initContent (cl:list "s" 1))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 0 cl:nil 2)) (_make-vector_ :initContent (cl:list "s" 2 "b" "d"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 3 6 2)) (_make-vector_ :initContent (cl:list "a" "c"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 9 10 cl:nil)) (_make-vector_)) (unittest:assertEqual ts (tl-pop a 0) "s") (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 1 2 "a" "b" "c" "d" "t"))) (unittest:assertEqual ts (tl-pop a (_unary-_ 1)) "t") (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 1 2 "a" "b" "c" "d"))) (unittest:assertEqual ts (tl-pop a) "d") (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 1 2 "a" "b" "c"))) (unittest:assertEqual ts (tl-remove a "c") 4) (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 1 2 "a" "b"))) (unittest:assertEqual ts (tl-remove a "z") cl:nil) (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 1 2 "a" "b"))) (unittest:assertEqual ts (index a 1) 0) (unittest:assertEqual ts (index a "b") 3) (unittest:assertEqual ts (index a "z") cl:nil) (unittest:assertEqual ts (tl-count a "b") 1) (unittest:assertEqual ts (tl-count a "z") 0) (insert a 0 "b") (unittest:assertEqual ts (tl-count a "b") 2) (unittest:assertEqual ts (_copy_ (_make-vector_)) (_make-vector_)) (cl:let (d) (cl:setf d (_copy_ b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b 3) (_getitem_ d 3))) (unittest:assertTrue ts (eq (_getitem_ b 4) (_getitem_ d 4))) (unittest:assertTrue ts (eq (_getitem_ b 6) (_getitem_ d 6))) (cl:let (c) (cl:setf c (_make-vector_ :initContent (cl:list 0 1 2 3 4 5 6 7 8 9))) (tl-pop c 5) (unittest:assertEqual ts c (_make-vector_ :initContent (cl:list 0 1 2 3 4 6 7 8 9))))))))
(cl:defmethod test-array-methods ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (make-array '(2 2) :initial-contents '((1 2) (3 4)))) (unittest:assertEqual ts (_getitem_ a '(0 0)) 1) (unittest:assertEqual ts (_getitem_ a '(1 0)) 3) (cl:setf (_getitem_ a '(1 0)) 99) (unittest:assertEqual ts (_getitem_ a '(1 0)) 99)))
(cl:defmethod test-hashTable-methods1 ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (_make-hash-table_)) (unittest:assertEqual ts (len a) 0) (cl:let (b) (cl:setf b (_make-hash-table_ "abc" 1 "cde" 2 "nil" cl:nil)) (unittest:assertEqual ts (len b) 3) (cl:let (val keyFound) (cl:setf (cl:values val keyFound) (_getitem_ b "abc")) (unittest:assertTrue ts keyFound) (unittest:assertEqual ts val 1) (cl:setf (cl:values val keyFound) (_getitem_ b "nil")) (unittest:assertTrue ts keyFound) (unittest:assertEqual ts val cl:nil) (cl:setf (cl:values val keyFound) (_getitem_ b "ABC")) (unittest:assertFalse ts keyFound) (unittest:assertEqual ts val cl:nil) (unittest:assertTrue ts (has_key b "abc")) (unittest:assertFalse ts (has_key b "ABC")) (unittest:assertTrue ts (vectorp (tKeys b))) (unittest:assertEqual ts (len (tKeys b)) 3) (unittest:assertTrue ts (vectorp (tValues b))) (unittest:assertEqual ts (len (tValues b)) 3) (unittest:assertTrue ts (vectorp (tItems b))) (unittest:assertEqual ts (len (tItems b)) 3) (unittest:assertTrue ts (listp (_getitem_ (tItems b) 0))) (unittest:assertEqual ts (len (_getitem_ (tItems b) 0)) 2) (unittest:assertEqual ts (_copy_ a) (_make-hash-table_)) (unittest:assertEqual ts (_getitem_ b "cde") 2) (cl:let (popedElem succ) (cl:setf (cl:values popedElem succ) (tl-pop b "cde")) (unittest:assertTrue ts succ) (unittest:assertEqual ts popedElem 2) (unittest:assertFalse ts (has_key b "cde")) (cl:setf (cl:values popedElem succ) (tl-pop b "xxx")) (unittest:assertFalse ts succ) (unittest:assertEqual ts popedElem cl:nil) (cl:setf (_getitem_ b "vect") (_make-vector_)) (cl:let (d) (cl:setf d (_copy_ b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b "vect") (_getitem_ d "vect")))))))))
(cl:defmethod test-hashTable-methods2 ((ts TestContainerMeths)) (cl:let (a) (cl:setf a (_make-hash-table_)) (update a (_make-hash-table_ 1 "a" "b" 2)) (unittest:assertEqual ts a (_make-hash-table_ 1 "a" "b" 2)) (update a (_make-hash-table_ 1 "h" "c" 3)) (unittest:assertEqual ts a (_make-hash-table_ 1 "h" "b" 2 "c" 3))))
