;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
; PHASE's are phases of string reading
(const REG_PHASE :regular_code)
(const STRING_PHASE :string_chars)
(const CLISP_PHASE :clisp_code)
; precompiled regular expressions
(const _NON_WHITE_RE (regexp:regexp-compile (_+_ (_+_ (_+_ (_+_ (_+_ (_+_ "^[^" #\Space) #\Tab) #\Newline) #\Page) #\Return) "]\\+")))
(const _WHITE_RE (regexp:regexp-compile (_+_ (_+_ (_+_ (_+_ (_+_ (_+_ "^[" #\Space) #\Tab) #\Newline) #\Page) #\Return) "]\\+")))
(const _ALPHA_NUM_RE (regexp:regexp-compile "^\\w\\+"))
(const _CLISP_START_RE (regexp:regexp-compile (_+_ "^" CLISP_START_STRING)))
(const _CLISP_END_RE (regexp:regexp-compile CLISP_END_STRING))
(const _ONE_DIGIT_RE (regexp:regexp-compile "^[0-9]"))
(const _DOT_FLOAT_RE (regexp:regexp-compile (_+_ (_+_ "^\\.[0-9]\\+[esfdlESFDL][+\\-]\\?[0-9]\\+" "\\|") "^\\.[0-9]\\+")))
(const _NUMBER_RE (regexp:regexp-compile (_+_ (_+_ (_+_ (_+_ "^[0-9]\\+\\.\\?[0-9]*[esfdlESFDL][+\\-]\\?[0-9]\\+" "\\|") "^[0-9]\\+\\.[0-9]\\+") "\\|") "^[0-9]\\+\\.\\?")))
(cl:defun makeStrElem (elemType value strNum start end) (new StrElem :type elemType :value value :lineNum strNum :start start :end end))
(cl:defun _startStringPhase (strNum startIndex marks) (tl-append marks (makeStrElem STR_START_ELEM (string #\") strNum startIndex (_+_ startIndex 1))) (cl:values (_+_ startIndex 1) STRING_PHASE))
(cl:defun _findEndOfExprInStr (st startIndex termChars) "    Expressions are expected to end by any symbol in termChars. If the first
    return parameter is True, then expression was terminated correctly. If
    it is False, then the end of the line was reached.
    " (cl:do* ((end startIndex)) ((_>=_ end (len st)) (cl:values cl:nil end)) (cl:let (ch) (cl:setf ch (_getitem_ st end)) (cl:cond ((_!=_ (tl-count termChars ch) 0) (cl:return-from cl:nil (cl:values cl:t end))) ((_==_ ch #\\) (cl:cond ((_<_ (_+_ end 1) (len st)) (cl:setf end (_+_ end 2))) (cl:t (cl:setf end (_+_ end 1))))) (cl:t (cl:setf end (_+_ end 1)))))))
(cl:defun _findEndOfExpr (st startIndex termChars) "    Symbol is terminated by one of termChars, or the end of line.
    " (nth-value 1 (_findEndOfExprInStr st startIndex termChars)))
(cl:defun _procStringPhase (initStr strNum startIndex marks) (cl:let (st) (cl:setf st initStr) (cl:let (endingInside end) (cl:setf (cl:values endingInside end) (_findEndOfExprInStr st startIndex (_make-vector_ :initContent (cl:list #\")))) (cl:let (elemType phase) (cl:setf (cl:values elemType phase end) (cl:cond (endingInside ; include also ending quote
 (cl:values STR_END_ELEM REG_PHASE (_+_ end 1))) (cl:t (cl:setf st (_+_ st #\Newline)) (cl:values STR_MID_ELEM STRING_PHASE (len st))))) (tl-append marks (makeStrElem elemType (_getitem_ st (_make-slice_ startIndex end cl:nil)) strNum startIndex end)) (cl:values st end phase)))))
(cl:defun _procCLispPhase (st strNum startIndex marks) (cl:let (match) (cl:setf match (regexp:regexp-exec _CLISP_END_RE st :start startIndex)) (cl:let (end codeEnd phase elemType) (cl:setf (cl:values end codeEnd phase elemType) (cl:cond (match (cl:values (_+_ (cl:slot-value match 'regexp::start) (len CLISP_END_STRING)) (cl:slot-value match 'regexp::start) REG_PHASE CLISP_END_ELEM)) (cl:t (cl:values (len st) (len st) CLISP_PHASE CLISP_MID_ELEM)))) (tl-append marks (makeStrElem elemType (_+_ (_getitem_ st (_make-slice_ startIndex codeEnd cl:nil)) #\Newline) strNum startIndex end)) (cl:values end phase))))
(cl:defun _procAmpName (st strNum startIndex marks) ; how long is a symbol?
 (cl:let (end) (cl:setf end (_findEndOfExpr st (_+_ startIndex 1) (_make-vector_ :initContent (cl:list #\Space #\Tab #\( #\) #\, #\:)))) (cl:cond ((_==_ end (_+_ startIndex 1)) ; it is a lone operator &
 (tl-append marks (makeStrElem "&" "&" strNum startIndex (_+_ startIndex 1))) (cl:setf end (_+_ startIndex 1))) (cl:t (tl-append marks (makeStrElem SYMB_ELEM (_getitem_ st (_make-slice_ (_+_ startIndex 1) end cl:nil)) strNum (_+_ startIndex 1) end)))) end))
(cl:defun _OperLen (st startIndex) (cl:let (spChar) (cl:setf spChar (_getitem_ st startIndex)) (cl:cond ((has_key MULTI_CHAR_OPERS spChar) (cl:let (opLen) (cl:setf opLen (tl-for (oper (_getitem_ MULTI_CHAR_OPERS spChar) (highestLenOper cl:nil)) ((len highestLenOper)) (cl:cond ((_==_ (_getitem_ st (_make-slice_ startIndex (_+_ startIndex (len oper)) cl:nil)) oper) (cl:cond ((_<_ (len highestLenOper) (len oper)) (cl:setf highestLenOper oper))))))) (cl:cond ((_==_ opLen 0) 1) (cl:t opLen)))) (cl:t 1))))
(cl:defun _procSpecialChars (st strNum startIndex marks) (cl:let (end) (cl:setf end (_+_ startIndex (_OperLen st startIndex))) (tl-append marks (makeStrElem (_getitem_ st (_make-slice_ startIndex end cl:nil)) (_getitem_ st (_make-slice_ startIndex end cl:nil)) strNum startIndex end)) end))
(cl:defun _procSpecSynt (st strNum startIndex marks) (cl:let (operLen) (cl:setf operLen (_OperLen st startIndex)) (cl:let (end elemType) (cl:setf (cl:values end elemType) (cl:cond ((_>_ operLen 1) (cl:values (_+_ startIndex operLen) (_getitem_ st (_make-slice_ startIndex (_+_ startIndex operLen) cl:nil)))) ((_<_ (_+_ startIndex 1) (len st)) (cl:let (end) (cl:setf end (_findEndOfExpr st (_+_ startIndex 1) (_make-vector_ :initContent (cl:list #\Space #\Tab #\( #\) #\,)))) (cl:cond ((_==_ end (_+_ startIndex 1)) (signalSyntaxError "Empty #-y structure"))) (cl:values end SYNT_STRUCT_ELEM))) (cl:t (signalSyntaxError "Empty #-y structure")))) (tl-append marks (makeStrElem elemType (_getitem_ st (_make-slice_ startIndex end cl:nil)) strNum startIndex end)) end)))
(cl:defun _procDotOrNum (st strNum startIndex marks) (cl:let (match) (cl:setf match (regexp:regexp-exec _DOT_FLOAT_RE st :start startIndex)) (cl:let (end elemType) (cl:setf (cl:values end elemType) (cl:cond (match ; this is a float number, like .34, or .34e-4
 (cl:values (cl:slot-value match 'regexp::end) NUM_ELEM)) (cl:t ; this a dot operator
 (cl:values (_+_ startIndex 1) ".")))) (tl-append marks (makeStrElem elemType (_getitem_ st (_make-slice_ startIndex end cl:nil)) strNum startIndex end)) end)))
(cl:defun _procNum (st strNum startIndex marks) (cl:let (end) (cl:setf end (cl:slot-value (regexp:regexp-exec _NUMBER_RE st :start startIndex) 'regexp::end)) (tl-append marks (makeStrElem NUM_ELEM (_getitem_ st (_make-slice_ startIndex end cl:nil)) strNum startIndex end)) end))
(cl:defun markElemsInStr (st strNum &optional (initPhase REG_PHASE)) (cl:let (marks) (cl:setf marks (_make-vector_)) (cl:let (phase) (cl:setf phase initPhase) (cl:let (startIndex) (cl:setf startIndex 0) (cl:do () ((_>=_ startIndex (len st))) (tl-case phase cl:nil ((STRING_PHASE) (cl:setf (cl:values st startIndex phase) (_procStringPhase st strNum startIndex marks))) ((CLISP_PHASE) (cl:setf (cl:values startIndex phase) (_procCLispPhase st strNum startIndex marks))) ((REG_PHASE) (cl:let (match) (cl:setf match (regexp:regexp-exec _WHITE_RE st :start startIndex)) (cl:cond (match (tl-append marks (makeStrElem WHITE_ELEM cl:nil strNum startIndex (cl:slot-value match 'regexp::end))) (cl:setf startIndex (cl:slot-value match 'regexp::end))) (cl:t (cl:setf match (regexp:regexp-exec _NON_WHITE_RE st :start startIndex)) (cl:let (nonWhiteEnd) (cl:setf nonWhiteEnd (cl:slot-value match 'regexp::end)) (cl:setf match (regexp:regexp-exec _ALPHA_NUM_RE st :start startIndex :end nonWhiteEnd)) (cl:cond ((_not_ match) ; have some special charachter (non alpha-num) in the beginning
 (cl:case (_getitem_ st startIndex) ((#\&) (cl:setf startIndex (_procAmpName st strNum startIndex marks))) ((#\#) (cl:setf startIndex (_procSpecSynt st strNum startIndex marks))) ((#\.) (cl:setf startIndex (_procDotOrNum st strNum startIndex marks))) ((#\") (cl:setf (cl:values startIndex phase) (_startStringPhase strNum startIndex marks))) ((#\;) ; semicolomn starts comment, which extends till the end
 (tl-append marks (makeStrElem COMM_ELEM (_getitem_ st (_make-slice_ startIndex (len st) cl:nil)) strNum startIndex (len st))) (cl:setf startIndex (len st))) (cl:otherwise (cl:setf startIndex (_procSpecialChars st strNum startIndex marks))))) (cl:t ; have an alpha-num symbol or a number
 (cl:let (alphaNumEnd) (cl:setf alphaNumEnd (cl:slot-value match 'regexp::end)) (cl:setf match (regexp:regexp-exec _ONE_DIGIT_RE st :start startIndex)) (cl:cond (match (cl:setf startIndex (_procNum st strNum startIndex marks))) (cl:t (cl:setf match (regexp:regexp-exec _CLISP_START_RE st :start startIndex)) (cl:cond (match (tl-append marks (makeStrElem CLISP_START_ELEM cl:nil strNum startIndex cl:nil)) (cl:setf phase CLISP_PHASE) (cl:setf startIndex (cl:slot-value match 'regexp::end))) (cl:t ; have alpha-numeric symbol
 (cl:let (symb) (cl:setf symb (_getitem_ st (_make-slice_ startIndex alphaNumEnd cl:nil))) (cl:let (elType) (cl:setf elType (cl:cond ((_==_ (tl-count SPEC_SYMB symb) 0) SYMB_ELEM) (cl:t (cl:cond ((_==_ (tl-count OPER_SYMB symb) 0) SPEC_SYMB_ELEM) (cl:t symb))))) (tl-append marks (makeStrElem elType symb strNum startIndex alphaNumEnd)) (cl:setf startIndex alphaNumEnd))))))))))))))))) (cl:cond ((_and_ (_==_ (len st) 0) (_==_ phase STRING_PHASE)) (tl-append marks (makeStrElem STR_MID_ELEM (string #\Newline) strNum 0 1)))) (tl-append marks (makeStrElem LINE_END_ELEM cl:nil strNum cl:nil cl:nil)) (cl:values marks phase)))))
(cl:defstruct (GrowingVect) streamObj (lineNum 0) (stringPhase REG_PHASE) (lineElems (_make-vector_)))
(cl:defmethod initialize-instance :after ((gv GrowingVect) &key) (cl:let (firstLine) (cl:setf firstLine (__readLine (cl:slot-value gv 'streamObj))) (cl:cond (firstLine (cl:setf (cl:slot-value gv 'lineNum) 1) (cl:let (dropLine) (cl:setf dropLine (cl:cond ((_>=_ (len firstLine) 2) (cl:cond ((_==_ (_getitem_ firstLine (_make-slice_ cl:nil 2 cl:nil)) "#!") cl:t) (cl:t cl:nil))) (cl:t cl:nil))) (cl:cond (dropLine (__readLine gv)) (cl:t (cl:let (newElems) (cl:setf (cl:values newElems (cl:slot-value gv 'stringPhase)) (markElemsInStr firstLine (cl:slot-value gv 'lineNum) (cl:slot-value gv 'stringPhase))) (extend (cl:slot-value gv 'lineElems) newElems))))))) cl:nil))
(cl:defmethod __readLine ((str stream)) (read-line str cl:nil cl:nil))
(cl:defmethod __readLine ((gv GrowingVect)) (cl:let (line) (cl:setf line (__readLine (cl:slot-value gv 'streamObj))) (cl:cond (line (_+=_ (cl:slot-value gv 'lineNum) 1) (cl:let (newElems) (cl:setf (cl:values newElems (cl:slot-value gv 'stringPhase)) (markElemsInStr line (cl:slot-value gv 'lineNum) (cl:slot-value gv 'stringPhase))) (extend (cl:slot-value gv 'lineElems) newElems)))) cl:nil))
(cl:defmethod len ((gv GrowingVect)) (len (cl:slot-value gv 'lineElems)))
(cl:defmethod _getitem_ ((gv GrowingVect) (index integer)) (_getitem_ (cl:slot-value gv 'lineElems) index))
(cl:defmethod _getitem_ ((gv GrowingVect) (sl _slice_)) (_getitem_ (cl:slot-value gv 'lineElems) sl))
(cl:defmethod growOnIndex ((gv GrowingVect) (index integer)) (cl:cond ((_==_ index (len gv)) (__readLine gv))) index)
(cl:defmethod growOnIndex ((vec vector) (index integer)) index)
