;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defclass TestTranslStringReading (unittest:testcase) ((unittest:tName :initform "TestTranslStringReading.twl") (unittest:tFuns :initform '(test-markElemsInStr-1 test-markElemsInStr-2 test-markElemsInStr-3 test-markElemsInStr-4 test-markElemsInStr-5 test-markElemsInStr-6 test-markElemsInStr-7 test-markElemsInStr-10 test-markElemsInStr-11 test-markElemsInStr-12 test-markElemsInStr-13 test-markElemsInStr-14 test-markElemsInStr-15 test-markElemsInStr-16 test-markElemsInStr-17 test-markElemsInStr-18 test-markElemsInStr-19 test-markElemsInStr-20 test-markElemsInStr-21 test-markElemsInStr-22 test-markElemsInStr-23 test-markElemsInStr-24 test-markElemsInStr-25 test-markElemsInStr-26 test-markElemsInStr-27 testGrowingVect))))
(defmethod test-markElemsInStr-1 ((ts TestTranslStringReading)) ; note unix end line character
 (let (st) (setf st "  &lisp-symbol = foo(x,y)*.45  ; this is comment") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil) (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'lineNum) 0) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "lisp-symbol") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (setf strElem (_getitem_ res 5)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "foo") (setf strElem (_getitem_ res 6)) (unittest:assertEqual ts (slot-value strElem 'type) "(") (unittest:assertEqual ts (slot-value strElem 'value) "(") (setf strElem (_getitem_ res 7)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 8)) (unittest:assertEqual ts (slot-value strElem 'type) ",") (unittest:assertEqual ts (slot-value strElem 'value) ",") (setf strElem (_getitem_ res 9)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "y") (setf strElem (_getitem_ res 10)) (unittest:assertEqual ts (slot-value strElem 'type) ")") (unittest:assertEqual ts (slot-value strElem 'value) ")") (setf strElem (_getitem_ res 11)) (unittest:assertEqual ts (slot-value strElem 'type) "*") (unittest:assertEqual ts (slot-value strElem 'value) "*") (setf strElem (_getitem_ res 12)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) ".45") (setf strElem (_getitem_ res 13)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil) (setf strElem (_getitem_ res 14)) (unittest:assertEqual ts (slot-value strElem 'type) COMM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "; this is comment") (setf strElem (_getitem_ res 15)) (unittest:assertEqual ts (slot-value strElem 'type) LINE_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil)))))
(defmethod test-markElemsInStr-2 ((ts TestTranslStringReading)) (let (st) (setf st "  &+symbol = foo+\"Some string\"  ; this is comment") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil) (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "+symbol") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (setf strElem (_getitem_ res 5)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "foo") (setf strElem (_getitem_ res 6)) (unittest:assertEqual ts (slot-value strElem 'type) "+") (unittest:assertEqual ts (slot-value strElem 'value) "+") (setf strElem (_getitem_ res 7)) (unittest:assertEqual ts (slot-value strElem 'type) STR_START_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "\"") (setf strElem (_getitem_ res 8)) (unittest:assertEqual ts (slot-value strElem 'type) STR_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "Some string\"") (setf strElem (_getitem_ res 9)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (setf strElem (_getitem_ res 10)) (unittest:assertEqual ts (slot-value strElem 'type) COMM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "; this is comment") (setf strElem (_getitem_ res 11)) (unittest:assertEqual ts (slot-value strElem 'type) LINE_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil)))))
(defmethod test-markElemsInStr-3 ((ts TestTranslStringReading)) (let (st) (setf st "foo==\"String spreads to several lines, has \\\"-quotes") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase STRING_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "foo") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "==") (unittest:assertEqual ts (slot-value strElem 'value) "==") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) STR_START_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "\"") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) STR_MID_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) (_+_ "String spreads to several lines, has \\\"-quotes" #\Newline))))))
(defmethod test-markElemsInStr-4 ((ts TestTranslStringReading)) ; line of a multiline string
 (let (st) (setf st "string started before, and does not end here") (let (res phase) (setf (values res phase) (markElemsInStr st 0 STRING_PHASE)) (unittest:assertEqual ts phase STRING_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) STR_MID_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) (_+_ "string started before, and does not end here" #\Newline)) (setf st "") (setf (values res phase) (markElemsInStr st 0 STRING_PHASE)) (unittest:assertEqual ts phase STRING_PHASE) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) STR_MID_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) (_+_ "" #\Newline))))))
(defmethod test-markElemsInStr-5 ((ts TestTranslStringReading)) ; line of a multiline string
 (let (st) (setf st "string started before, and ends here\"  ; some comment") (let (res phase) (setf (values res phase) (markElemsInStr st 0 STRING_PHASE)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) STR_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "string started before, and ends here\"") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) COMM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "; some comment")))))
(defmethod test-markElemsInStr-6 ((ts TestTranslStringReading)) (let (st) (setf st "x[0]=&+$%^\\(-symbol(23.4)") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "[") (unittest:assertEqual ts (slot-value strElem 'value) "[") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "0") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "]") (unittest:assertEqual ts (slot-value strElem 'value) "]") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 5)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "+$%^\\(-symbol") (setf strElem (_getitem_ res 6)) (unittest:assertEqual ts (slot-value strElem 'type) "(") (unittest:assertEqual ts (slot-value strElem 'value) "(") (setf strElem (_getitem_ res 7)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "23.4") (setf strElem (_getitem_ res 8)) (unittest:assertEqual ts (slot-value strElem 'type) ")") (unittest:assertEqual ts (slot-value strElem 'value) ")")))))
(defmethod test-markElemsInStr-7 ((ts TestTranslStringReading)) (let (st) (setf st "x=&&symbol[23.4]\\(()") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "&symbol[23.4]\\(") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "(") (unittest:assertEqual ts (slot-value strElem 'value) "(") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) ")") (unittest:assertEqual ts (slot-value strElem 'value) ")")))))
(defmethod test-markElemsInStr-10 ((ts TestTranslStringReading)) (let (st) (setf st "x=\"\"") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) STR_START_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "\"") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) STR_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "\"")))))
(defmethod test-markElemsInStr-11 ((ts TestTranslStringReading)) (let (st) (setf st "x=#b01010") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) SYNT_STRUCT_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "#b01010")))))
(defmethod test-markElemsInStr-12 ((ts TestTranslStringReading)) (let (st) (setf st "x=(#\L,4)") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) "(") (unittest:assertEqual ts (slot-value strElem 'value) "(") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) SYNT_STRUCT_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "#\L") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) ",") (unittest:assertEqual ts (slot-value strElem 'value) ",") (setf strElem (_getitem_ res 5)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "4") (setf strElem (_getitem_ res 6)) (unittest:assertEqual ts (slot-value strElem 'type) ")") (unittest:assertEqual ts (slot-value strElem 'value) ")")))))
(defmethod test-markElemsInStr-13 ((ts TestTranslStringReading)) (let (st) (setf st "x=#'foo") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) "#'") (unittest:assertEqual ts (slot-value strElem 'value) "#'") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "foo")))))
(defmethod test-markElemsInStr-14 ((ts TestTranslStringReading)) (let (st) (setf st "x!=#c(1.,2e-3)") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "!=") (unittest:assertEqual ts (slot-value strElem 'value) "!=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) "#c") (unittest:assertEqual ts (slot-value strElem 'value) "#c") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "(") (unittest:assertEqual ts (slot-value strElem 'value) "(") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "1.") (setf strElem (_getitem_ res 5)) (unittest:assertEqual ts (slot-value strElem 'type) ",") (unittest:assertEqual ts (slot-value strElem 'value) ",") (setf strElem (_getitem_ res 6)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "2e-3") (setf strElem (_getitem_ res 7)) (unittest:assertEqual ts (slot-value strElem 'type) ")") (unittest:assertEqual ts (slot-value strElem 'value) ")")))))
(defmethod test-markElemsInStr-15 ((ts TestTranslStringReading)) (let (st) (setf st " x = # C(1,2)") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0)) (setf st "x=#") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0)) (setf st "x=#(fg)") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0)) (setf st "x=#,fg") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0))))
(defmethod test-markElemsInStr-16 ((ts TestTranslStringReading)) (let (st) (setf st "x=#\\L()") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) SYNT_STRUCT_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "#\\L") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "(") (unittest:assertEqual ts (slot-value strElem 'value) "(") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) ")") (unittest:assertEqual ts (slot-value strElem 'value) ")")))))
(defmethod test-markElemsInStr-17 ((ts TestTranslStringReading)) (let (st) (setf st "x=3/4+3./4-.5f+7") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "3") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "/") (unittest:assertEqual ts (slot-value strElem 'value) "/") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "4") (setf strElem (_getitem_ res 5)) (unittest:assertEqual ts (slot-value strElem 'type) "+") (unittest:assertEqual ts (slot-value strElem 'value) "+") (setf strElem (_getitem_ res 6)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "3.") (setf strElem (_getitem_ res 7)) (unittest:assertEqual ts (slot-value strElem 'type) "/") (unittest:assertEqual ts (slot-value strElem 'value) "/") (setf strElem (_getitem_ res 8)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "4") (setf strElem (_getitem_ res 9)) (unittest:assertEqual ts (slot-value strElem 'type) "-") (unittest:assertEqual ts (slot-value strElem 'value) "-") (setf strElem (_getitem_ res 10)) (unittest:assertEqual ts (slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) ".5f+7")))))
(defmethod test-markElemsInStr-18 ((ts TestTranslStringReading)) (let (st) (setf st "x=&lisp-pack:&lisp-symb") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "x") (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) "=") (unittest:assertEqual ts (slot-value strElem 'value) "=") (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "lisp-pack") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) ":") (unittest:assertEqual ts (slot-value strElem 'value) ":") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "lisp-symb")))))
(defmethod test-markElemsInStr-19 ((ts TestTranslStringReading)) (let (st) (setf st "if a & b-c {") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "a") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) "&") (unittest:assertEqual ts (slot-value strElem 'value) "&") (setf strElem (_getitem_ res 5)) (unittest:assertEqual ts (slot-value strElem 'type) WHITE_ELEM) (setf strElem (_getitem_ res 6)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "b") (setf strElem (_getitem_ res 7)) (unittest:assertEqual ts (slot-value strElem 'type) "-") (unittest:assertEqual ts (slot-value strElem 'value) "-") (setf strElem (_getitem_ res 8)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "c")))))
(defmethod test-markElemsInStr-20 ((ts TestTranslStringReading)) (let (st) (setf st "if a &b-c {") (let (res phase) (setf (values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 2)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "a") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "b-c")))))
(defmethod test-markElemsInStr-21 ((ts TestTranslStringReading)) (let (res phase) (setf (values res phase) (markElemsInStr "" 0)) (unittest:assertEqual ts phase REG_PHASE) (unittest:assertEqual ts (len res) 1) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) LINE_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil))))
(defmethod test-markElemsInStr-22 ((ts TestTranslStringReading)) (let (res phase) (setf (values res phase) (markElemsInStr "def foo(&def ){}" 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) SPEC_SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "def") (setf strElem (_getitem_ res 4)) (unittest:assertEqual ts (slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "def"))))
(defmethod test-markElemsInStr-23 ((ts TestTranslStringReading)) (let (res phase) (setf (values res phase) (markElemsInStr "cl{{(+ 1 2)}} - 3" 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_START_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil) (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "(+ 1 2)
") (setf strElem (_getitem_ res 3)) (unittest:assertEqual ts (slot-value strElem 'type) "-") (unittest:assertEqual ts (slot-value strElem 'value) "-"))))
(defmethod test-markElemsInStr-24 ((ts TestTranslStringReading)) (let (res phase) (setf (values res phase) (markElemsInStr "cl{{(+ 1 2) ;comment in lisp code}}-3" 0)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_START_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil) (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "(+ 1 2) ;comment in lisp code
"))))
(defmethod test-markElemsInStr-25 ((ts TestTranslStringReading)) (let (res phase) (setf (values res phase) (markElemsInStr "cl{{(+ 1 2)" 0)) (unittest:assertEqual ts phase CLISP_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_START_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) nil) (unittest:assertEqual ts (slot-value strElem 'start) 0) (unittest:assertEqual ts (slot-value strElem 'end) nil) (unittest:assertEqual ts (slot-value strElem 'lineNum) 0) (setf strElem (_getitem_ res 1)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "(+ 1 2)
"))))
(defmethod test-markElemsInStr-26 ((ts TestTranslStringReading)) (let (res phase) (setf (values res phase) (markElemsInStr "(+ 1 2)  ;;comment" 0 CLISP_PHASE)) (unittest:assertEqual ts phase CLISP_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "(+ 1 2)  ;;comment
"))))
(defmethod test-markElemsInStr-27 ((ts TestTranslStringReading)) (let (res phase) (setf (values res phase) (markElemsInStr "(+ 1 2)  ;;comment}}" 0 CLISP_PHASE)) (unittest:assertEqual ts phase REG_PHASE) (let (strElem) (setf strElem (_getitem_ res 0)) (unittest:assertEqual ts (slot-value strElem 'type) CLISP_END_ELEM) (unittest:assertEqual ts (slot-value strElem 'value) "(+ 1 2)  ;;comment
"))))
(defmethod testGrowingVect ((ts TestTranslStringReading)) (let (st) (setf st "def foo(x,y) { ; definition of function
    \"foo adds x and y\"
    x+y}") (let (gv) (setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertEqual ts (len gv) 13) (unittest:assertEqual ts (slot-value (_getitem_ gv 0) 'value) "def") (unittest:assertEqual ts (slot-value (_getitem_ gv 1) 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value (_getitem_ gv 2) 'value) "foo") (unittest:assertEqual ts (slot-value (_getitem_ gv 3) 'value) "(") (unittest:assertEqual ts (slot-value (_getitem_ gv 4) 'value) "x") (unittest:assertEqual ts (slot-value (_getitem_ gv 5) 'value) ",") (unittest:assertEqual ts (slot-value (_getitem_ gv 6) 'value) "y") (unittest:assertEqual ts (slot-value (_getitem_ gv 7) 'value) ")") (unittest:assertEqual ts (slot-value (_getitem_ gv 8) 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value (_getitem_ gv 9) 'value) "{") (unittest:assertEqual ts (slot-value (_getitem_ gv 10) 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value (_getitem_ gv 11) 'value) "; definition of function") (unittest:assertEqual ts (slot-value (_getitem_ gv 12) 'type) LINE_END_ELEM) (growOnIndex gv 13) (unittest:assertEqual ts (len gv) 17) (unittest:assertEqual ts (slot-value (_getitem_ gv 13) 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value (_getitem_ gv 14) 'value) "\"") (unittest:assertEqual ts (slot-value (_getitem_ gv 15) 'value) "foo adds x and y\"") (unittest:assertEqual ts (slot-value (_getitem_ gv 16) 'type) LINE_END_ELEM) (growOnIndex gv 17) (unittest:assertEqual ts (len gv) 23) (unittest:assertEqual ts (slot-value (_getitem_ gv 17) 'type) WHITE_ELEM) (unittest:assertEqual ts (slot-value (_getitem_ gv 18) 'value) "x") (unittest:assertEqual ts (slot-value (_getitem_ gv 19) 'value) "+") (unittest:assertEqual ts (slot-value (_getitem_ gv 20) 'value) "y") (unittest:assertEqual ts (slot-value (_getitem_ gv 21) 'value) "}") (unittest:assertEqual ts (slot-value (_getitem_ gv 22) 'type) LINE_END_ELEM) (growOnIndex gv 23) (unittest:assertEqual ts (len gv) 23) (unittest:assertCondition ts error (_getitem_ gv 23)) (unittest:assertEqual ts (len (_getitem_ gv (_make-slice_ 10 20 nil))) 10) (unittest:assertTrue ts (typep (_getitem_ gv (_make-slice_ 10 20 nil)) 'vector)) (unittest:assertEqual ts (_getitem_ (_getitem_ gv (_make-slice_ 10 20 nil)) 0) (_getitem_ gv 10)) (unittest:assertEqual ts (_getitem_ (_getitem_ gv (_make-slice_ 10 20 nil)) 5) (_getitem_ gv 15)) (unittest:assertEqual ts (_getitem_ (_getitem_ gv (_make-slice_ 10 20 nil)) 9) (_getitem_ gv 19)))))
