;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defclass TestTranslFormBuildingFour (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuildingFour.twl") (unittest:tFuns :initform '(test-getForms-meth-specializers test-getForms-meth-specifiers test-getForms-defgen-1 test-getForms-defgen-2 test-getForms-defgen-3 test-getForms-defgen-4 test-getForms-gfun-1 test-getForms-gfun-2 test-getForms-glet-1 test-getForms-glet-2 test-getForms-glet-3 test-getForms-glabels-1 test-getForms-glabels-2 test-getForms-glabels-3))))
(defmethod test-getForms-meth-specializers ((ts TestTranslFormBuildingFour)) (let (st) (setf st "meth foo (a==integer,b,c==character,d=0) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmethod") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "b") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "c") (list ATOM_TYPE "character")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "d") (list ATOM_TYPE "0"))))))))))))))))
(defmethod test-getForms-meth-specifiers ((ts TestTranslFormBuildingFour)) (let (st) (setf st "meth foo progn, :&other-qualifier (a==integer) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmethod") (list ATOM_TYPE "foo") (list ATOM_TYPE "progn") (list ATOM_TYPE ":other-qualifier") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "integer"))))))))))))))))
(defmethod test-getForms-defgen-1 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "defgen foo (a,&&optional b)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defgeneric") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-defgen-2 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "defgen foo (a,&&optional b)
            options {
                :documentation=\"foo doc-string\"}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defgeneric") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"foo doc-string\"")))))))))))))
(defmethod test-getForms-defgen-3 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "defgen foo (a,&&optional b)
            options {
                :documentation=\"foo doc-string\"}
            meth (a==character,b=#\A) {
                return a }
            meth (a==integer,b=0) {
                return a }
            meth :before (a==t,b=nil) {
                print(a) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defgeneric") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"foo doc-string\"")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "character")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "#\A"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list ATOM_TYPE "a"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list ATOM_TYPE "a"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list ATOM_TYPE ":before") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "t")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "nil"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "print") (list ATOM_TYPE "a"))))))))))))))))
(defmethod test-getForms-defgen-4 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "defgen foo (a,&&optional b)
            meth (a==character,b=#\A) {
                return a }
            meth (a==integer,b=0) {
                return a }
            meth :before (a==t,b=nil) {
                print(a) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defgeneric") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "character")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "#\A"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list ATOM_TYPE "a"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list ATOM_TYPE "a"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list ATOM_TYPE ":before") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "t")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "nil"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "print") (list ATOM_TYPE "a"))))))))))))))))
(defmethod test-getForms-gfun-1 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "gfun (a,&&optional b)
            options {
                :documentation=\"foo doc-string\"}
            meth (a==character,b=#\A) {
                a+b }
            meth (a==integer,b=0) {
                a+b }
            meth :before (a==t,b=nil) {
                print(a) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-function") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"foo doc-string\"")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "character")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "#\A"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list ATOM_TYPE ":before") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "t")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "nil"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "print") (list ATOM_TYPE "a"))))))))))))))))
(defmethod test-getForms-gfun-2 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "gfun (a,&&optional b)
            meth (a==character,b=#\A) {
                a+b }
            meth (a==integer,b=0) {
                a+b }
            meth :before (a==t,b=nil) {
                print(a) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-function") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "character")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "#\A"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list ATOM_TYPE ":before") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "t")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "nil"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "print") (list ATOM_TYPE "a"))))))))))))))))
(defmethod test-getForms-glet-1 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "glet foo (a,&&optional b)
               bar (a) {
              foo(bar(1)) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-flet") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list ATOM_TYPE "1"))))))))))))))))
(defmethod test-getForms-glet-2 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "glet foo (a,&&optional b)
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-flet") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"bar doc-string\"")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list ATOM_TYPE "1"))))))))))))))))
(defmethod test-getForms-glet-3 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "glet foo (a,&&optional b)
                   meth (a==character,b=#\A) {
                       a+b }
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-flet") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "character")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "#\A"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"bar doc-string\"")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list ATOM_TYPE "1"))))))))))))))))
(defmethod test-getForms-glabels-1 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "glabels
               foo (a,&&optional b)
               bar (a) {
              foo(bar(1)) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-labels") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list ATOM_TYPE "1"))))))))))))))))
(defmethod test-getForms-glabels-2 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "glabels
               foo (a,&&optional b)
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-labels") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"bar doc-string\"")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list ATOM_TYPE "1"))))))))))))))))
(defmethod test-getForms-glabels-3 ((ts TestTranslFormBuildingFour)) (let (st) (setf st "glabels
               foo (a,&&optional b)
                   meth (a==character,b=#\A) {
                       a+b }
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "generic-labels") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":method") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "character")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "#\A"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"bar doc-string\"")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bar") (list ATOM_TYPE "1"))))))))))))))))
