;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(defclass TestOperMeths (unittest:testcase) ((unittest:tName :initform "TestOperMeths.twl") (unittest:tFuns :initform '(test-not-for-t test-not-for-bitVector test-and-for-t test-and-for-bitVector test-or-for-t test-or-for-bitVector test-xor-for-t test-xor-for-bitVector test-equality-for-numbers test-equality-for-strings test-equality-for-chars test-equality-for-lists test-equality-for-vectors test-equality-for-hashTable test-addition-for-lists test-addition-for-vectors test-addition-for-string-and-chars test-modulus-division test-exponentiation test-string-formatting test-insert-operator))))
(defmethod test-not-for-t ((ts TestOperMeths)) (unittest:assertTrue ts (_not_ nil) :textOnFail "(not nil) should always be true") (unittest:assertFalse ts (_not_ t) :textOnFail "(not t) should always be nil (false)") (unittest:assertFalse ts (_not_ "string") :textOnFail "(not obj) should always be nil (false), when obj is not nil"))
(defmethod test-not-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (_not_ #*) #* :test #'equal :textOnFail "Bitwise-not of an empty bit-vector should be an empty bit-vector") (unittest:assertEqual ts (_not_ #*0011) #*1100 :test #'equal :textOnFail "Bitwise-not should return a bit-vector with every bit flipped"))
(defmethod test-and-for-t ((ts TestOperMeths)) (unittest:assertFalse ts (_and_ t nil) :textOnFail "(t and nil) should always be nil (false)") (unittest:assertFalse ts (_and_ nil t) :textOnFail "(nil and t) should always be nil (false)") (unittest:assertFalse ts (_and_ nil t) :textOnFail "(nil and t) should always be nil (false)") (unittest:assertTrue ts (_and_ t t) :textOnFail "(t and t) should always be true") (unittest:assertTrue ts (_and_ 12 "string") :textOnFail "(obj1 and obj2) should always be true, when obj1 and obj2 or not nil"))
(defmethod test-and-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (_and_ #* #*) #* :test #'equal :textOnFail "Bitwise-and of an empty bit-vectors should be an empty bit-vector") (unittest:assertEqual ts (_and_ #*1010 #*0011) #*0010 :test #'equal :textOnFail "Bitwise-and should produce a vector with every bit being bit-anding of corresponding bits from given vectors") (unittest:assertCondition ts error (_and_ #*110 #*110011) :textOnFail "Bitwise-and should raise an error when given vectors have different length"))
(defmethod test-or-for-t ((ts TestOperMeths)) (unittest:assertTrue ts (_or_ t nil) :textOnFail "(t or nil) should always be true") (unittest:assertTrue ts (_or_ nil t) :textOnFail "(nil or t) should always be true") (unittest:assertTrue ts (_or_ t t) :textOnFail "(t or t) should always be true") (unittest:assertFalse ts (_or_ nil nil) :textOnFail "(nil or nil) should always be nil (false)") (unittest:assertTrue ts (_or_ nil "string") :textOnFail "(nil or obj) should be true, when obj is not nil"))
(defmethod test-or-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (_or_ #* #*) #* :test #'equal :textOnFail "Bitwise-or of an empty bit-vectors should be an empty bit-vector") (unittest:assertEqual ts (_or_ #*1010 #*0110) #*1110 :test #'equal :textOnFail "Bitwise-or should produce a vector with every bit being bit-oring of corresponding bits from given vectors") (unittest:assertCondition ts error (_or_ #*110 #*110011) :textOnFail "Bitwise-or should raise an error when given vectors have different length"))
(defmethod test-xor-for-t ((ts TestOperMeths)) (unittest:assertTrue ts (_xor_ t nil) :textOnFail "(t xor nil) should always be true") (unittest:assertTrue ts (_xor_ nil t) :textOnFail "(nil xor t) should always be true") (unittest:assertFalse ts (_xor_ t t) :textOnFail "(t xor t) should always be nil (false)") (unittest:assertFalse ts (_xor_ nil nil) :textOnFail "(nil xor nil) should always be nil (false)") (unittest:assertTrue ts (_xor_ nil "string") :textOnFail "(nil xor obj) should be true, when obj is not nil"))
(defmethod test-xor-for-bitVector ((ts TestOperMeths)) (unittest:assertEqual ts (_xor_ #* #*) #* :test #'equal :textOnFail "Bitwise-or of an empty bit-vectors should be an empty bit-vector") (unittest:assertEqual ts (_xor_ #*1010 #*0110) #*1100 :test #'equal :textOnFail "Bitwise-or should produce a vector with every bit being bit-oring of corresponding bits from given vectors") (unittest:assertCondition ts error (_xor_ #*110 #*110011) :textOnFail "Bitwise-or should raise an error when given vectors have different length"))
(defmethod test-equality-for-numbers ((ts TestOperMeths)) (unittest:assertTrue ts (_==_ 1 1)) (unittest:assertFalse ts (_!=_ 1 1)) (unittest:assertTrue ts (_!=_ 1 2)) (unittest:assertFalse ts (_==_ 1 2)) (unittest:assertTrue ts (_==_ 1 1.0)) (unittest:assertFalse ts (_!=_ 1 1.0)) (unittest:assertTrue ts (_==_ 1 (complex 1 0))) ; etc., like lisp's equality for numbers
)
(defmethod test-equality-for-strings ((ts TestOperMeths)) (unittest:assertTrue ts (_==_ "abcde" "abcde")) (unittest:assertFalse ts (_!=_ "abcde" "abcde")) (unittest:assertTrue ts (_!=_ "abcde" "abcdef")) (unittest:assertFalse ts (_==_ "abcde" "abcdef")) (unittest:assertTrue ts (_!=_ "abcde" "Abcde")) (unittest:assertFalse ts (_==_ "abcde" "Abcde")))
(defmethod test-equality-for-chars ((ts TestOperMeths)) (unittest:assertTrue ts (_==_ #\a #\a)) (unittest:assertFalse ts (_!=_ #\a #\a)) (unittest:assertTrue ts (_!=_ #\a #\b)) (unittest:assertFalse ts (_==_ #\a #\b)) (unittest:assertTrue ts (_!=_ #\a #\A)) (unittest:assertFalse ts (_==_ #\a #\A)))
(defmethod test-equality-for-lists ((ts TestOperMeths)) (unittest:assertTrue ts (_==_ (list) (list))) (unittest:assertFalse ts (_!=_ (list) (list))) (unittest:assertTrue ts (_==_ (list 1 2 "abc") (list 1 2 "abc"))) (unittest:assertFalse ts (_!=_ (list 1 2 "abc") (list 1 2 "abc"))) (unittest:assertTrue ts (_!=_ (list 1 3 "abc") (list 1 2 "abc"))) (unittest:assertFalse ts (_==_ (list 1 3 "abc") (list 1 2 "abc"))) (unittest:assertTrue ts (_!=_ (list 1 2 "abc" 3) (list 1 2 "abc"))) (unittest:assertFalse ts (_==_ (list 1 2 "abc" 3) (list 1 2 "abc"))))
(defmethod test-equality-for-vectors ((ts TestOperMeths)) (unittest:assertTrue ts (_==_ (_make-vector_) (_make-vector_))) (unittest:assertFalse ts (_!=_ (_make-vector_) (_make-vector_))) (unittest:assertTrue ts (_==_ (_make-vector_ :initContent (list 1 2 "abc")) (_make-vector_ :initContent (list 1 2 "abc")))) (unittest:assertFalse ts (_!=_ (_make-vector_ :initContent (list 1 2 "abc")) (_make-vector_ :initContent (list 1 2 "abc")))) (unittest:assertTrue ts (_!=_ (_make-vector_ :initContent (list 1 3 "abc")) (_make-vector_ :initContent (list 1 2 "abc")))) (unittest:assertFalse ts (_==_ (_make-vector_ :initContent (list 1 3 "abc")) (_make-vector_ :initContent (list 1 2 "abc")))) (unittest:assertTrue ts (_!=_ (_make-vector_ :initContent (list 1 2 "abc" 3)) (_make-vector_ :initContent (list 1 2 "abc")))) (unittest:assertFalse ts (_==_ (_make-vector_ :initContent (list 1 2 "abc" 3)) (_make-vector_ :initContent (list 1 2 "abc")))))
(defmethod test-equality-for-hashTable ((ts TestOperMeths)) (unittest:assertTrue ts (_==_ (_make-hash-table_) (_make-hash-table_))) (unittest:assertFalse ts (_!=_ (_make-hash-table_) (_make-hash-table_))) (unittest:assertTrue ts (_==_ (_make-hash-table_ "abc" 1) (_make-hash-table_ "abc" 1))) (unittest:assertFalse ts (_!=_ (_make-hash-table_ "abc" 1) (_make-hash-table_ "abc" 1))) (unittest:assertTrue ts (_==_ (_make-hash-table_ "abc" (list 1 2 (_make-vector_ :initContent (list "b" "a")))) (_make-hash-table_ "abc" (list 1 2 (_make-vector_ :initContent (list "b" "a")))))) (unittest:assertFalse ts (_!=_ (_make-hash-table_ "abc" (list 1 2 (_make-vector_ :initContent (list "b" "a")))) (_make-hash-table_ "abc" (list 1 2 (_make-vector_ :initContent (list "b" "a")))))) (unittest:assertTrue ts (_!=_ (_make-hash-table_ "abc" 2) (_make-hash-table_ "abc" 1))) (unittest:assertFalse ts (_==_ (_make-hash-table_ "abc" 2) (_make-hash-table_ "abc" 1))) (unittest:assertTrue ts (_!=_ (_make-hash-table_ "abc" 1 23 "gh") (_make-hash-table_ "abc" 1))) (unittest:assertFalse ts (_==_ (_make-hash-table_ "abc" 1 23 "gh") (_make-hash-table_ "abc" 1))))
(defmethod test-addition-for-lists ((ts TestOperMeths)) (unittest:assertEqual ts (_+_ (list 1 2 3) (list)) (list 1 2 3)) (unittest:assertEqual ts (_+_ (list 1 2 3) (list 4 5 6)) (list 1 2 3 4 5 6)))
(defmethod test-addition-for-vectors ((ts TestOperMeths)) (unittest:assertEqual ts (_+_ (_make-vector_ :initContent (list 1 2 3)) (_make-vector_)) (_make-vector_ :initContent (list 1 2 3))) (unittest:assertEqual ts (_+_ (_make-vector_ :initContent (list 1 2 3)) (_make-vector_ :initContent (list 4 5 6))) (_make-vector_ :initContent (list 1 2 3 4 5 6))))
(defmethod test-addition-for-string-and-chars ((ts TestOperMeths)) (unittest:assertEqual ts (_+_ "" "def") "def") (unittest:assertEqual ts (_+_ "abc " "def") "abc def") (unittest:assertEqual ts (_+_ #\A "def") "Adef") (unittest:assertEqual ts (_+_ "def" #\A) "defA"))
(defmethod test-modulus-division ((ts TestOperMeths)) (unittest:assertEqual ts (_%_ 7 2) 3))
(defmethod test-exponentiation ((ts TestOperMeths)) (unittest:assertEqual ts (_**_ 2 5) 32))
(defmethod test-string-formatting ((ts TestOperMeths)) (unittest:assertEqual ts (_%_ "num: ~d" 32) "num: 32") (unittest:assertEqual ts (_%_ "string: ~A" "boo") "string: boo") (unittest:assertEqual ts (_%_ "num1: ~d, num2: ~d" (_make-vector_ :initContent (list 32 65))) "num1: 32, num2: 65") (unittest:assertEqual ts (_%_ "num1: ~d, num2: ~d" (list 32 65)) "num1: 32, num2: 65") (unittest:assertEqual ts (_%_ "nil: ~A" (list)) "nil: NIL"))
(defmethod test-insert-operator ((ts TestOperMeths)) (let (a) (setf a (_make-vector_)) (_<<_ a "a") (unittest:assertEqual ts a (_make-vector_ :initContent (list "a"))) (_<<_ a (list 1 2)) (unittest:assertEqual ts a (_make-vector_ :initContent (list "a" (list 1 2)))) (_<<_ a (_make-vector_ :initContent (list 3 4))) (unittest:assertEqual ts a (_make-vector_ :initContent (list "a" (list 1 2) (_make-vector_ :initContent (list 3 4))))) (unittest:assertEqual ts (_<<_ a "e") a) (_<<_ (_<<_ a "c") "d") (unittest:assertEqual ts a (_make-vector_ :initContent (list "a" (list 1 2) (_make-vector_ :initContent (list 3 4)) "e" "c" "d"))) (let (b) (setf b (list)) (unittest:assertCondition ts null-list-error (_<<_ b "a")) (setf b (list "a")) (_<<_ b "b") (unittest:assertEqual ts b (list "a" "b")) (_<<_ b (list 1 2)) (unittest:assertEqual ts b (list "a" "b" (list 1 2))) (_<<_ b (_make-vector_ :initContent (list 3 4))) (unittest:assertEqual ts b (list "a" "b" (list 1 2) (_make-vector_ :initContent (list 3 4)))) (unittest:assertEqual ts (_<<_ b "e") b) (_<<_ (_<<_ b "c") "d") (unittest:assertEqual ts b (list "a" "b" (list 1 2) (_make-vector_ :initContent (list 3 4)) "e" "c" "d")) (let (str) (setf str (make-string-output-stream)) (_<<_ str "Hi,") (_<<_ str #\Space) (_<<_ str "Bob!") (unittest:assertEqual ts (get-output-stream-string str) "Hi, Bob!") (unittest:assertEqual ts (_<<_ str "-- ") str) (_<<_ (_<<_ (_<<_ str "Bye,") #\Space) "Mike.") (unittest:assertEqual ts (get-output-stream-string str) "-- Bye, Mike.")))))
