;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
;; Operator 'not'
(defgeneric _not_ (obj) (:method ((obj t)) (not obj)) (:method ((bitVect bit-vector)) (bit-not bitVect)))
;; Operator 'and'
(defgeneric _and_ (fst snd) (:method ((fst t) (snd t)) (and fst snd)) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-and fstBitVect sndBitVect)))
;; Operator 'or'
(defgeneric _or_ (fst snd) (:method ((fst t) (snd t)) (or fst snd)) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-ior fstBitVect sndBitVect)))
;; Operator 'xor' (exclusive or)
(defgeneric _xor_ (fst snd) (:method ((fst t) (snd t)) (_and_ (_or_ fst snd) (_or_ (_not_ fst) (_not_ snd)))) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-xor fstBitVect sndBitVect)))
;; Equality operator '=='
(defgeneric _==_ (fst snd) (:method ((fstNum number) (sndNum number)) (= fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char= fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string= fstStr sndStr)) (:method ((fstBitVect bit-vector) (sndBitVect bit-vector)) (equal fstBitVect sndBitVect)) (:method ((fstVect vector) (sndVect vector)) (cond ((eq fstVect sndVect) t) ((_==_ (len fstVect) (len sndVect)) (let (vecLen) (setf vecLen (len fstVect)) (do ((i 0 (_+_ i 1))) ((_>=_ i vecLen) t) (cond ((_!=_ (_getitem_ fstVect i) (_getitem_ sndVect i)) (return-from nil nil)))))) (t nil))) (:method ((fstLst list) (sndLst list)) (cond ((eq fstLst sndLst) t) (t (do ((fstCons fstLst) (sndCons sndLst)) (nil) (cond ((endp fstCons) (return-from nil (endp sndCons))) (t (cond ((endp sndCons) (return-from nil nil)) (t (cond ((_!=_ (car fstCons) (car sndCons)) (return-from nil nil)) ((_==_ (cdr fstCons) (cdr sndCons)) (return-from nil t)) (t (setf fstCons (cdr fstCons)) (setf sndCons (cdr sndCons)) (cond ((_or_ (eq fstCons fstLst) (eq sndCons sndLst)) (return-from nil (_and_ (eq fstCons fstLst) (eq sndCons sndLst))))))))))))))) (:method ((fstTab hash-table) (sndTab hash-table)) (cond ((eq fstTab sndTab) t) ((_==_ (len fstTab) (len sndTab)) (maphash #'(lambda (fstKey fstVal) (let (sndVal keyPresent) (setf (values sndVal keyPresent) (_getitem_ sndTab fstKey)) (cond ((_or_ (_not_ keyPresent) (_!=_ sndVal fstVal)) (return-from _==_ nil))))) fstTab) t) (t nil))) (:method ((fst t) (snd t)) (eq fst snd)))
;; Non-equality operator '!='
(defgeneric _!=_ (fst snd) (:method ((fst t) (snd t)) (_not_ (_==_ fst snd))))
;; Smaller-then operator '<'
(defgeneric _<_ (fst snd) (:method ((fstNum number) (sndNum number)) (< fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char< fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string< fstStr sndStr)))
;; Smaller-or-equal operator '<='
(defgeneric _<=_ (fst snd) (:method ((fstNum number) (sndNum number)) (<= fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char<= fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string<= fstStr sndStr)))
;; Greater-then operator '>'
(defgeneric _>_ (fst snd) (:method ((fstNum number) (sndNum number)) (> fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char> fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string> fstStr sndStr)))
;; Greater-or-equal operator '>='
(defgeneric _>=_ (fst snd) (:method ((fstNum number) (sndNum number)) (>= fstNum sndNum)) (:method ((fstChar character) (sndChar character)) (char>= fstChar sndChar)) (:method ((fstStr string) (sndStr string)) (string>= fstStr sndStr)))
;; Addition operator '+'
(defgeneric _+_ (fst snd) (:method ((fstNum number) (sndNum number)) (+ fstNum sndNum)) (:method ((fstLst list) (sndLst list)) (concatenate 'list fstLst sndLst)) (:method ((fstVect vector) (sndVect vector)) (let (resultVect) (setf resultVect (_make-vector_)) (extend resultVect fstVect sndVect) resultVect)) (:method ((fstStr string) (sndStr string)) (concatenate 'string fstStr sndStr)) (:method ((str string) (char character)) (concatenate 'string str (string char))) (:method ((char character) (str string)) (concatenate 'string (string char) str)))
;; Unary plus
(defgeneric _unary+_ (obj) (:method ((num number)) num))
;; Subtraction operator '-'
(defgeneric _-_ (fst snd) (:method ((fstNum number) (sndNum number)) (- fstNum sndNum)))
;; Unary minus
(defgeneric _unary-_ (obj) (:method ((num number)) (- num)))
;; Multiplication operator '*'
(defgeneric _*_ (fst snd) (:method ((fstNum number) (sndNum number)) (* fstNum sndNum)))
;; Division operator '/'
(defgeneric _/_ (fst snd) (:method ((fstNum number) (sndNum number)) (/ fstNum sndNum)))
;; Modulus division operator '%'
(defgeneric _%_ (fst snd) (:method ((fstInt integer) (sndInt integer)) (nth-value 0 (floor fstInt sndInt))) (:method ((fstStr string) (sndStr string)) (apply #'format (list nil fstStr sndStr))) (:method ((str string) (lst list)) (cond ((null lst) (apply #'format (list nil str nil))) (t (apply #'format (_+_ (list nil str) lst))))) (:method ((str string) (obj t)) (apply #'format (list nil str obj))) (:method ((str string) (seq sequence)) (apply #'format (_+_ (list nil str) (coerce seq 'list)))))
;; Exponentiation operator '**'
(defgeneric _**_ (fst snd) (:method ((fstNum number) (sndNum number)) (expt fstNum sndNum)))
;; Appending operator '<<'
(defgeneric _<<_ (fst snd) (:method ((lst list) (obj t)) (err-on-null lst "Operator '<<' cannot append to null list") (setf (cdr (last lst)) (list obj)) lst) (:method ((vec vector) (obj t)) (vector-push-extend obj vec) vec) (:method ((str stream) (s string)) (write-string s str) str) (:method ((str stream) (char character)) (write-char char str) str) (:method ((str stream) (int integer)) (write-byte int str) str))
