;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(defclass TestOtherMacs (unittest:testcase) ((unittest:tName :initform "TestOtherMacs.twl") (unittest:tFuns :initform '(test-new test-tl-case test-tl-for test-tl-times))))
(defclass foo () (a b))
(defstruct (soo) a b)
(define-condition boo () (c d))
(defmethod test-new ((ts TestOtherMacs)) (unittest:assertFalse ts (typep (new foo) 'condition) :textOnFail "If foo is not subtype of condition, then it is treated as class") (unittest:assertTrue ts (typep (new boo) 'condition) :textOnFail "If boo is subtype of condition, then it is treated as condition") (unittest:assertCondition ts error (new hoo) :textOnFail "It is not apparent here, but error will talk about missing class") (let (a) (setf a (new soo :a "a" :b 23)) (unittest:assertEqual ts (slot-value a 'a) "a") (unittest:assertEqual ts (slot-value a 'b) 23)))
(defmethod test-tl-case ((ts TestOtherMacs)) (let (a) (setf a (list 1 2 3)) (unittest:assertTrue ts (tl-case (tl-pop a) nil ((2) nil) (((_+_ 1 1)) nil) (((_-_ 3 1)) nil) ((3) t))) (setf a (list 1 2 3)) (unittest:assertTrue ts (tl-case (tl-pop a) (t) ((6) nil) (((_*_ 6 3)) nil) (((_+_ 8 2)) nil))) (unittest:assertTrue ts (tl-case (list 4 5) (nil) ((6) nil) (((list)) nil) (((list 4 5)) t))) (unittest:assertTrue ts (tl-case (list 4 5) (nil) ((6) nil) (((list) (list 4 5)) t)))))
(defmethod test-tl-for ((ts TestOtherMacs)) (let (a) (setf a (list 1 2 3 4 5)) (let (c) (setf c (_make-vector_)) (tl-for (elem a) (nil) (tl-append c elem)) (unittest:assertEqual ts c (_make-vector_ :initContent (list 1 2 3 4 5))) (setf c (_make-vector_)) (let (b) (setf b (_make-vector_ :initContent (list 6 7 8 9 0))) (tl-for (elem b) (nil) (tl-append c elem)) (unittest:assertEqual ts c b) (unittest:assertEqual ts (tl-for (elem b (i 1 (_+_ i 1))) ((_-_ i 1))) (len b))))))
(defmethod test-tl-times ((ts TestOtherMacs)) (let (a) (setf a (tl-times (i 9 (vec (_make-vector_))) (vec) (tl-append vec i))) (unittest:assertEqual ts a (_make-vector_ :initContent (list 0 1 2 3 4 5 6 7 8)))))
