;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(defclass TestContainerMeths (unittest:testcase) ((unittest:tName :initform "TestContainerMeths.twl") (unittest:tFuns :initform '(test-list-methods test-vector-methods test-array-methods test-hashTable-methods))))
(defmethod test-list-methods ((ts TestContainerMeths)) (let (a) (setf a (list)) (unittest:assertEqual ts (len a) 0) (let (b) (setf b (list 1 2 "k")) (unittest:assertEqual ts (len b) 3) (unittest:assertCondition ts index-error (_getitem_ a 0) :textOnFail "index should be out of range") (unittest:assertEqual ts (_getitem_ b 0) 1) (unittest:assertEqual ts (_getitem_ b (_unary-_ 2)) 2) (setf (_getitem_ b (_unary-_ 1)) 3) (unittest:assertEqual ts b (list 1 2 3)) (unittest:assertCondition ts null-list-error (tl-append a "s") :textOnFail "assert is not supposed to work for nil, so error is raised") (tl-append b (list "a" "b") (_make-vector_ :initContent (list "c" "d")) (list) (_make-vector_)) (unittest:assertEqual ts b (list 1 2 3 (list "a" "b") (_make-vector_ :initContent (list "c" "d")) (list) (_make-vector_))) (unittest:assertCondition ts null-list-error (extend a (list "s" "t")) :textOnFail "extend is not supposed to work for nil, so error is raised") (let (c) (setf c (cons nil nil)) (extend c (list "a" "b") (_make-vector_ :initContent (list "c" "d")) (list) (_make-vector_)) (unittest:assertEqual ts c (list nil "a" "b" "c" "d")) (unittest:assertCondition ts null-list-error (insert a 0 "s") :textOnFail "insert is not supposed to work for nil, so error is raised") (insert c 0 "s") (unittest:assertEqual ts c (list "s" nil "a" "b" "c" "d")) (insert c (_unary-_ 1) "t") (unittest:assertEqual ts c (list "s" nil "a" "b" "c" "d" "t")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 4 nil nil)) (list "c" "d" "t")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 4 5 nil)) (list "c")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 5 4 nil)) (list)) (unittest:assertEqual ts (_getitem_ c (_make-slice_ nil 2 nil)) (list "s" nil)) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 0 nil 2)) (list "s" "a" "c" "t")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 2 5 2)) (list "a" "c")) (unittest:assertEqual ts (_getitem_ c (_make-slice_ 9 10 nil)) (list)) (unittest:assertEqual ts (tl-pop c 0) "s") (unittest:assertEqual ts c (list nil "a" "b" "c" "d" "t")) (unittest:assertEqual ts (tl-pop c (_unary-_ 1)) "t") (unittest:assertEqual ts c (list nil "a" "b" "c" "d")) (unittest:assertEqual ts (tl-pop c) "d") (unittest:assertEqual ts c (list nil "a" "b" "c")) (unittest:assertEqual ts (tl-remove c "c") 3) (unittest:assertEqual ts c (list nil "a" "b")) (unittest:assertEqual ts (tl-remove c "z") nil) (unittest:assertEqual ts c (list nil "a" "b")) (unittest:assertEqual ts (index c nil) 0) (unittest:assertEqual ts (index c "b") 2) (unittest:assertEqual ts (index c "z") nil) (unittest:assertEqual ts (tl-count c "b") 1) (unittest:assertEqual ts (tl-count c "z") 0) (insert c 0 "b") (unittest:assertEqual ts (tl-count c "b") 2) (unittest:assertEqual ts (_copy_ a) (list)) (let (d) (setf d (_copy_ b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b 3) (_getitem_ d 3))) (unittest:assertTrue ts (eq (_getitem_ b 4) (_getitem_ d 4))) (unittest:assertTrue ts (eq (_getitem_ b 6) (_getitem_ d 6))) (setf c (list 0 1 2 3 4 5 6 7 8 9)) (tl-pop c 5) (unittest:assertEqual ts c (list 0 1 2 3 4 6 7 8 9)))))))
(defmethod test-vector-methods ((ts TestContainerMeths)) (let (a) (setf a (_make-vector_)) (unittest:assertEqual ts (len a) 0) (let (b) (setf b (_make-vector_ :initContent (list 1 2 "k"))) (unittest:assertEqual ts (len b) 3) (unittest:assertCondition ts index-error (_getitem_ a 0) :textOnFail "index should be out of range") (unittest:assertEqual ts (_getitem_ b 0) 1) (unittest:assertEqual ts (_getitem_ b (_unary-_ 2)) 2) (setf (_getitem_ b (_unary-_ 1)) 3) (unittest:assertEqual ts b (_make-vector_ :initContent (list 1 2 3))) (tl-append a 1 2) (unittest:assertEqual ts a (_make-vector_ :initContent (list 1 2))) (tl-append b (list "a" "b") (_make-vector_ :initContent (list "c" "d")) (list) (_make-vector_)) (unittest:assertEqual ts b (_make-vector_ :initContent (list 1 2 3 (list "a" "b") (_make-vector_ :initContent (list "c" "d")) (list) (_make-vector_)))) (extend a (list "a" "b") (_make-vector_ :initContent (list "c" "d")) (list) (_make-vector_)) (unittest:assertEqual ts a (_make-vector_ :initContent (list 1 2 "a" "b" "c" "d"))) (insert a 0 "s") (unittest:assertEqual ts a (_make-vector_ :initContent (list "s" 1 2 "a" "b" "c" "d"))) (insert a (_unary-_ 1) "t") (unittest:assertEqual ts a (_make-vector_ :initContent (list "s" 1 2 "a" "b" "c" "d" "t"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 5 nil nil)) (_make-vector_ :initContent (list "c" "d" "t"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 5 6 nil)) (_make-vector_ :initContent (list "c"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 6 5 nil)) (_make-vector_)) (unittest:assertEqual ts (_getitem_ a (_make-slice_ nil 2 nil)) (_make-vector_ :initContent (list "s" 1))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 0 nil 2)) (_make-vector_ :initContent (list "s" 2 "b" "d"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 3 6 2)) (_make-vector_ :initContent (list "a" "c"))) (unittest:assertEqual ts (_getitem_ a (_make-slice_ 9 10 nil)) (_make-vector_)) (unittest:assertEqual ts (tl-pop a 0) "s") (unittest:assertEqual ts a (_make-vector_ :initContent (list 1 2 "a" "b" "c" "d" "t"))) (unittest:assertEqual ts (tl-pop a (_unary-_ 1)) "t") (unittest:assertEqual ts a (_make-vector_ :initContent (list 1 2 "a" "b" "c" "d"))) (unittest:assertEqual ts (tl-pop a) "d") (unittest:assertEqual ts a (_make-vector_ :initContent (list 1 2 "a" "b" "c"))) (unittest:assertEqual ts (tl-remove a "c") 4) (unittest:assertEqual ts a (_make-vector_ :initContent (list 1 2 "a" "b"))) (unittest:assertEqual ts (tl-remove a "z") nil) (unittest:assertEqual ts a (_make-vector_ :initContent (list 1 2 "a" "b"))) (unittest:assertEqual ts (index a 1) 0) (unittest:assertEqual ts (index a "b") 3) (unittest:assertEqual ts (index a "z") nil) (unittest:assertEqual ts (tl-count a "b") 1) (unittest:assertEqual ts (tl-count a "z") 0) (insert a 0 "b") (unittest:assertEqual ts (tl-count a "b") 2) (unittest:assertEqual ts (_copy_ (_make-vector_)) (_make-vector_)) (let (d) (setf d (_copy_ b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b 3) (_getitem_ d 3))) (unittest:assertTrue ts (eq (_getitem_ b 4) (_getitem_ d 4))) (unittest:assertTrue ts (eq (_getitem_ b 6) (_getitem_ d 6))) (let (c) (setf c (_make-vector_ :initContent (list 0 1 2 3 4 5 6 7 8 9))) (tl-pop c 5) (unittest:assertEqual ts c (_make-vector_ :initContent (list 0 1 2 3 4 6 7 8 9))))))))
(defmethod test-array-methods ((ts TestContainerMeths)) (let (a) (setf a (make-array '(2 2) :initial-contents '((1 2) (3 4)))) (unittest:assertEqual ts (_getitem_ a '(0 0)) 1) (unittest:assertEqual ts (_getitem_ a '(1 0)) 3) (setf (_getitem_ a '(1 0)) 99) (unittest:assertEqual ts (_getitem_ a '(1 0)) 99)))
(defmethod test-hashTable-methods ((ts TestContainerMeths)) (let (a) (setf a (_make-hash-table_)) (unittest:assertEqual ts (len a) 0) (let (b) (setf b (_make-hash-table_ "abc" 1 "cde" 2 "nil" nil)) (unittest:assertEqual ts (len b) 3) (let (val keyFound) (setf (values val keyFound) (_getitem_ b "abc")) (unittest:assertTrue ts keyFound) (unittest:assertEqual ts val 1) (setf (values val keyFound) (_getitem_ b "nil")) (unittest:assertTrue ts keyFound) (unittest:assertEqual ts val nil) (setf (values val keyFound) (_getitem_ b "ABC")) (unittest:assertFalse ts keyFound) (unittest:assertEqual ts val nil) (unittest:assertTrue ts (has_key b "abc")) (unittest:assertFalse ts (has_key b "ABC")) (unittest:assertTrue ts (vectorp (tKeys b))) (unittest:assertEqual ts (len (tKeys b)) 3) (unittest:assertTrue ts (vectorp (tValues b))) (unittest:assertEqual ts (len (tValues b)) 3) (unittest:assertTrue ts (vectorp (tItems b))) (unittest:assertEqual ts (len (tItems b)) 3) (unittest:assertTrue ts (listp (_getitem_ (tItems b) 0))) (unittest:assertEqual ts (len (_getitem_ (tItems b) 0)) 2) (unittest:assertEqual ts (_copy_ a) (_make-hash-table_)) (unittest:assertEqual ts (_getitem_ b "cde") 2) (let (popedElem succ) (setf (values popedElem succ) (tl-pop b "cde")) (unittest:assertTrue ts succ) (unittest:assertEqual ts popedElem 2) (unittest:assertFalse ts (has_key b "cde")) (setf (values popedElem succ) (tl-pop b "xxx")) (unittest:assertFalse ts succ) (unittest:assertEqual ts popedElem nil) (setf (_getitem_ b "vect") (_make-vector_)) (let (d) (setf d (_copy_ b)) (unittest:assertFalse ts (eq b d)) (unittest:assertEqual ts b d) (unittest:assertTrue ts (eq (_getitem_ b "vect") (_getitem_ d "vect")))))))))
