;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defun getElemsInBrackets (indOpenBr elems &optional (retWithBrackets nil)) (let (indClosBr) (setf indClosBr nil) (do* ((expClosBr (_make-vector_ :initContent (list (_getitem_ BRACKETS (slot-value (_getitem_ elems indOpenBr) 'type))))) (numOpenBr 0) (ind (growOnIndex elems (_+_ indOpenBr 1)))) ((_>=_ ind (len elems)) (signalSyntaxError (_%_ "Expected closing bracket to match '~A' on line ~D, position ~D, is missing" (list (slot-value (_getitem_ elems indOpenBr) 'type) (slot-value (_getitem_ elems indOpenBr) 'lineNum) (slot-value (_getitem_ elems indOpenBr) 'start))))) (let (el) (setf el (_getitem_ elems ind)) (cond ((has_key BRACKETS (slot-value el 'type)) ; it is an openning bracket
 (setf numOpenBr (_+_ numOpenBr 1)) (tl-append expClosBr (_getitem_ BRACKETS (slot-value el 'type)))) (t (cond ((_!=_ (tl-count CLOSING_BRACKETS (slot-value el 'type)) 0) ; it is a closing bracket, but is it a correct one?
 (cond ((_==_ (slot-value el 'type) (string (_getitem_ expClosBr (_unary-_ 1)))) (setf numOpenBr (_-_ numOpenBr 1)) (tl-pop expClosBr) (cond ((_<_ numOpenBr 0) (setf indClosBr ind) (return-from nil ())))) (t (signalSyntaxError (_%_ "Expect closing bracket '~A' on line ~D, position ~D, but got '~A' instead" (list (_getitem_ expClosBr (_unary-_ 1)) (slot-value el 'lineNum) (slot-value el 'start) (slot-value el 'type)))))))))) (setf ind (growOnIndex elems (_+_ ind 1))))) (cond (retWithBrackets (values (_getitem_ elems (_make-slice_ indOpenBr (_+_ indClosBr 1) nil)) (_+_ indClosBr 1))) (t (values (_getitem_ elems (_make-slice_ (_+_ indOpenBr 1) indClosBr nil)) indClosBr)))))
(defun _getLineEndElemInd (startInd elems) "Return the first line end element, or None" (do ((ind startInd (_+_ ind 1))) ((_>=_ ind (len elems)) (values nil ind)) (cond ((_==_ (slot-value (_getitem_ elems ind) 'type) LINE_END_ELEM) (return-from nil (values t ind))))))
(defun skipElems (elemTypes startInd elems &optional (onSameLine t)) "Seeks index of the first element other then the ones that have to be skipped. If found, returns True and index, else False and len(elems) or LINE_END_ELEM index" (do ((ind startInd)) ((_>=_ ind (len elems)) (values nil ind)) (let (elType) (setf elType (slot-value (_getitem_ elems ind) 'type)) (cond ((_==_ elType LINE_END_ELEM) (cond (onSameLine (return-from nil (values nil ind))))) ((_==_ elType "\\") (let (lineEndFound) (setf (values lineEndFound ind) (_getLineEndElemInd ind elems)) (cond ((_not_ lineEndFound) (return-from nil (values nil (len elems))))))) ((_==_ (tl-count elemTypes elType) 0) (return-from nil (values t ind)))) (setf ind (growOnIndex elems (_+_ ind 1))))))
(defun getRequiredElemInd (elemType startInd elems &optional (onSameLine t)) "Required element shall always be on the same line (or continued line)" (let (elemFound ind) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM)) startInd elems onSameLine)) (cond ((_not_ elemFound) (cond (onSameLine (signalSyntaxError (_%_ "Expect element '~A' on line ~D, but line ends" (list elemType (slot-value (_getitem_ elems startInd) 'lineNum))))) (t (cond ((_<_ startInd (len elems)) (signalSyntaxError (_%_ "Expected element '~A' is missing on/after line ~D" (list elemType (slot-value (_getitem_ elems startInd) 'lineNum))))) (t (signalSyntaxError (_%_ "Expected element '~A' is missing" elemType)))))))) (cond ((_==_ (slot-value (_getitem_ elems ind) 'type) elemType) ind) (t (signalSyntaxError (_%_ "Expected element '~A', but got instead element '~A' on line ~D" (list elemType (slot-value (_getitem_ elems ind) 'type) (slot-value (_getitem_ elems ind) 'lineNum))))))))
(defun getRequiredElemInd2 (elemType startInd elems &optional (onSameLine t)) (handler-case (progn (values t (getRequiredElemInd elemType startInd elems onSameLine))) (tl-syntax-error () (values nil startInd))))
(defun getShortcutInd (startInd elems &optional (onSameLine t)) (tl-for (elemType (tKeys SHORTCUT_OPERS)) ((values nil startInd)) (let (elemFound ind) (setf (values elemFound ind) (getRequiredElemInd2 elemType startInd elems onSameLine)) (cond (elemFound (return-from nil (values t ind)))))))
(defun getElemIndInOperExpr (elemType startInd elems) (do ((ind startInd)) ((_>=_ ind (len elems)) (values nil nil)) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM)) ind elems)) (cond ((_not_ elemFound) (return-from nil (values nil nil)))) (cond ((_==_ (slot-value (_getitem_ elems ind) 'type) elemType) (return-from nil (values t ind))) ((has_key BRACKETS (slot-value (_getitem_ elems ind) 'type)) (let (elemsInBrack) (setf (values elemsInBrack ind) (getElemsInBrackets ind elems t)))) ((_or_ (_==_ (slot-value (_getitem_ elems ind) 'type) LINE_END_ELEM) (_==_ (slot-value (_getitem_ elems ind) 'type) ",")) (return-from nil (values nil nil))) (t (setf ind (_+_ ind 1)))))))
