;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defstruct (LevelInfo) blockName implScope explScopeWarn isTopLevel (_lowerLevelFuncName nil) _nickToRealNames (currImplVar (_make-vector_)) (newVars (_make-vector_)) (_lowerLevelImplVar (_make-vector_)))
(defun makeLevelInfo (&key ((:blockName blockName) nil) ((:implScope implScope) nil) ((:isTopLevel isTopLevel) t) ((:explScopeWarn explScopeWarn) nil) ((:nickToRealNames nickToRealNames) nil)) (new LevelInfo :blockName blockName :implScope implScope :explScopeWarn explScopeWarn :isTopLevel isTopLevel :_nickToRealNames (cond (nickToRealNames (_copy_ nickToRealNames)) (t (_copy_ TWL_METH_NICKNAMES)))))
(defmethod lowerFuncLevel (li) (cond ((_not_ (slot-value li '_lowerLevelFuncName)) (error "Programming error: function name should be set before calling LevelInfo.lowerFuncLevel"))) (let (funcName) (setf funcName (slot-value li '_lowerLevelFuncName)) (setf (slot-value li '_lowerLevelFuncName) nil) (let (lowerLevel) (setf lowerLevel (lowerMacLevel li)) (setf (slot-value lowerLevel 'blockName) funcName) (setf (slot-value lowerLevel 'implScope) (slot-value li 'implScope)) lowerLevel)))
(defmethod lowerRegLevel (li) (let (lowerLevel) (setf lowerLevel (makeLevelInfo :blockName (slot-value li 'blockName) :implScope (slot-value li 'implScope) :isTopLevel nil :explScopeWarn (slot-value li 'explScopeWarn) :nickToRealNames (slot-value li '_nickToRealNames))) (setf (slot-value lowerLevel 'currImplVar) (_+_ (slot-value li '_lowerLevelImplVar) (slot-value li 'currImplVar))) (setf (slot-value li '_lowerLevelImplVar) (_make-vector_)) lowerLevel))
(defmethod lowerMacLevel (li) (let (lowerLevel) (setf lowerLevel (makeLevelInfo :blockName (slot-value li 'blockName) :implScope nil :isTopLevel nil :explScopeWarn (slot-value li 'explScopeWarn) :nickToRealNames (slot-value li '_nickToRealNames))) (setf (slot-value lowerLevel 'currImplVar) (slot-value li '_lowerLevelImplVar)) (setf (slot-value li '_lowerLevelImplVar) (_make-vector_)) lowerLevel))
(defmethod addSymbSynonym (li nickName realName) (setf (_getitem_ (slot-value li '_nickToRealNames) nickName) realName))
(defmethod getRealSymbol (li symb) (cond ((has_key (slot-value li '_nickToRealNames) symb) (_getitem_ (slot-value li '_nickToRealNames) symb)) (t symb)))
(defmethod setImplVarForLowerLevel (li symbList) (setf (slot-value li '_lowerLevelImplVar) symbList))
(defun _formSymbAsImplVarForLowerLevel (symbList form) (let (tf) (setf tf form) (cond ((_==_ (_getitem_ tf 0) SHORTCUT_TYPE) (setf tf form) (do () ((_!=_ (_getitem_ tf 0) SHORTCUT_TYPE)) (setf tf (_getitem_ tf 2))))) (cond ((_==_ (_getitem_ tf 0) ATOM_TYPE) (tl-append symbList (_getitem_ tf 1))))))
(defun _formSymbAsImplVar (level form) (let (tf) (setf tf form) (cond ((_==_ (_getitem_ tf 0) SHORTCUT_TYPE) (setf tf form) (do () ((_!=_ (_getitem_ tf 0) SHORTCUT_TYPE)) (setf tf (_getitem_ tf 2))))) (tl-case (_getitem_ tf 0) nil ((FORM_TYPE) (cond ((_==_ (_getitem_ (_getitem_ tf 1) 0) (list ATOM_TYPE "values")) (tl-for (innerForm (_getitem_ (_getitem_ tf 1) (_make-slice_ 1 nil nil))) (nil) (_formSymbAsImplVar level innerForm))))) ((ATOM_TYPE) (cond ((slot-value level 'implScope) (cond ((_and_ (_==_ (tl-count (slot-value level 'currImplVar) (_getitem_ tf 1)) 0) (_==_ (tl-count (_getitem_ tf 1) #\:) 0)) (tl-append (slot-value level 'currImplVar) (_getitem_ tf 1)) (tl-append (slot-value level 'newVars) (_getitem_ tf 1))))) (t (cond ((_and_ (slot-value level 'explScopeWarn) (_==_ (tl-count (slot-value level 'currImplVar) (_getitem_ tf 1)) 0)) (signalSyntaxError (_%_ "Assignment to unknown variable '~A'. You have to use 'let'-type constructs, or declare variable global." (_getitem_ tf 1)))))))))))
(defun _macLambdaListForm (elems level) (let (form) (setf form (list FORM_TYPE (_make-vector_))) (let (symbList) (setf symbList (_make-vector_)) (do ((ind 0) (option "no-option")) ((_>=_ ind (len elems))) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) ind elems nil)) (cond ((_not_ elemFound) (return-from nil ()))) (cond ((_and_ (_==_ (slot-value (_getitem_ elems ind) 'type) SYMB_ELEM) (_!=_ (tl-count MAC_LAMBDA_LIST_OPTIONS (slot-value (_getitem_ elems ind) 'value)) 0)) (cond ((_and_ (_!=_ (slot-value (_getitem_ elems ind) 'value) "&whole") (_!=_ (slot-value (_getitem_ elems ind) 'value) "&environment")) (setf option (slot-value (_getitem_ elems ind) 'value)))) (tl-append (_getitem_ form 1) (list ATOM_TYPE (slot-value (_getitem_ elems ind) 'value))) (_+=_ ind 1)) ((_==_ (slot-value (_getitem_ elems ind) 'type) ".") (let (brackInd) (setf brackInd (getRequiredElemInd "(" (_+_ ind 1) elems)) (let (trueVal innerLamdaListForm) (setf (values trueVal innerLamdaListForm ind) (_procSpecificList brackInd elems level MAC_LAMBDA_LIST)) (extend (_getitem_ form 1) innerLamdaListForm)))) ((_==_ (slot-value (_getitem_ elems ind) 'type) "*") (cond ((_or_ (_==_ option "no-option") (_==_ option "&optional")) (setf option "&rest") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&rest"))) ((_!=_ option "&rest") (signalSyntaxError (_%_ "The '&rest' parameter on line ~D, position ~D, cannot follow option '~A'" (list (slot-value (_getitem_ elems ind) 'lineNum) (slot-value (_getitem_ elems ind) 'start) option))))) (let (restForm) (setf (values restForm ind) (getOneForm (_+_ ind 1) elems level nil)) (tl-append (_getitem_ form 1) restForm))) ((_==_ (slot-value (_getitem_ elems ind) 'type) "**") (cond ((_or_ (_==_ option "no-option") (_==_ option "&optional")) (setf option "&rest") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&body"))) ((_!=_ option "&rest") (signalSyntaxError (_%_ "The '&body' parameter on line ~D, position ~D, cannot follow option '~A'" (list (slot-value (_getitem_ elems ind) 'lineNum) (slot-value (_getitem_ elems ind) 'start) option))))) (let (restForm) (setf (values restForm ind) (getOneForm (_+_ ind 1) elems level nil)) (tl-append (_getitem_ form 1) restForm))) (t (let (keyPresent arrowInd) (setf (values keyPresent arrowInd) (getElemIndInOperExpr "->" ind elems)) (let (svarFormEnd svarForm keyForm questInd svarPresent) (setf svarPresent (setf questInd (setf keyForm (setf svarForm (setf svarFormEnd nil))))) (cond (keyPresent (let (keyFormEnd) (setf (values keyForm keyFormEnd) (getOneForm 0 (_getitem_ elems (_make-slice_ ind arrowInd nil)) level nil)) (cond ((_not_ keyForm) (signalSyntaxError (_%_ "Missing a keyword before '->' on line ~D, position ~D" (list (slot-value (_getitem_ elems arrowInd) 'lineNum) (slot-value (_getitem_ elems arrowInd) 'start)))))) (cond ((_or_ (_or_ (_==_ option "no-option") (_==_ option "&optional")) (_==_ option "&rest")) (setf option "&key") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&key"))) ((_!=_ option "&key") (signalSyntaxError (_%_ "The '&key' parameter on line ~D, position ~D, cannot follow option '~A'" (list (slot-value (_getitem_ elems ind) 'lineNum) (slot-value (_getitem_ elems ind) 'start) option))))) (setf (values svarPresent questInd) (getElemIndInOperExpr "=?" (_+_ arrowInd 1) elems)))) (t (setf (values svarPresent questInd) (getElemIndInOperExpr "=?" ind elems)))) (cond (svarPresent (setf (values svarForm svarFormEnd) (getOneForm (_+_ questInd 1) elems level nil)) (cond ((_not_ svarForm) (signalSyntaxError (_%_ "Missing a variable name after '=?' on line ~D, position ~D" (list (slot-value (_getitem_ elems questInd) 'lineNum) (slot-value (_getitem_ elems questInd) 'start)))))) (cond ((_==_ option "no-option") (setf option "&optional") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&optional"))) ((_==_ option "&rest") (setf option "&key") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&key"))) ((_and_ (_!=_ option "&optional") (_!=_ option "&key")) (signalSyntaxError (_%_ "'=?' on line ~D, position ~D, has no sense after option '~A'" (list (slot-value (_getitem_ elems questInd) 'lineNum) (slot-value (_getitem_ elems questInd) 'start) option))))))) (cond ((_and_ keyPresent svarPresent) (let (varForms varFormsEnd) (setf (values varForms varFormsEnd) (getFormsSeparByElem "=" 0 (_getitem_ elems (_make-slice_ (_+_ arrowInd 1) questInd nil)) level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ varForms 0)) (setf ind svarFormEnd) (case (len varForms) ((1) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list keyForm (_getitem_ varForms 0)))) (list ATOM_TYPE LISP_NIL) svarForm))))) ((2) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list keyForm (_getitem_ varForms 0)))) (_getitem_ varForms 1) svarForm)))))))) ((_and_ (_not_ keyPresent) svarPresent) (let (varForms varFormsEnd) (setf (values varForms varFormsEnd) (getFormsSeparByElem "=" 0 (_getitem_ elems (_make-slice_ ind questInd nil)) level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ varForms 0)) (setf ind svarFormEnd) (case (len varForms) ((1) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (_getitem_ varForms 0) (list ATOM_TYPE LISP_NIL) svarForm))))) ((2) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (_getitem_ varForms 0) (_getitem_ varForms 1) svarForm)))))))) ((_and_ keyPresent (_not_ svarPresent)) (let (varForms) (setf (values varForms ind) (getFormsSeparByElem "=" (_+_ arrowInd 1) elems level)) (case (len varForms) ((1) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list keyForm (_getitem_ varForms 0))))))))) ((2) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list keyForm (_getitem_ varForms 0)))) (_getitem_ varForms 1))))))))) ((_and_ (_not_ keyPresent) (_not_ svarPresent)) (let (varForms) (setf (values varForms ind) (getFormsSeparByElem "=" ind elems level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ varForms 0)) (case (len varForms) ((1) (tl-append (_getitem_ form 1) (_getitem_ varForms 0))) ((2) (tl-case option nil (("no-option") (setf option "&optional") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&optional"))) (("&rest") (setf option "&key") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&key"))) (("&allow-other-keys") (setf option "&aux") (tl-append (_getitem_ form 1) (list ATOM_TYPE "&aux")))) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (_getitem_ varForms 0) (_getitem_ varForms 1)))))))))))))))) (setImplVarForLowerLevel level symbList) form)))
(defun _letListForm (innerElems level) (let (form) (setf form (list FORM_TYPE (_make-vector_))) (let (symbList) (setf symbList (_make-vector_)) (do ((ind 0)) ((_>=_ ind (len innerElems))) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) ind innerElems nil)) (cond ((_not_ elemFound) (return-from nil ()))) (let (forms) (setf (values forms ind) (getFormsSeparByElem "=" ind innerElems level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ forms 0)) (case (len forms) ((2) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (_getitem_ forms 0) (_getitem_ forms 1)))))) ((1) (tl-append (_getitem_ form 1) (_getitem_ forms 0))))))) (setImplVarForLowerLevel level symbList) form)))
(defun _doVarListForm (innerElems level) (let (form) (setf form (list FORM_TYPE (_make-vector_))) (let (symbList) (setf symbList (_make-vector_)) (do ((ind 0)) ((_>=_ ind (len innerElems))) (let (stepForm arrowInd end) (setf (values stepForm arrowInd end) (getFormAfterElem "->" ind innerElems level)) (cond (stepForm (let (forms) (setf forms (getFormsSeparByElem "=" 0 (_getitem_ innerElems (_make-slice_ ind arrowInd nil)) level)) (case (len forms) ((2) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (_getitem_ forms 0) (_getitem_ forms 1) stepForm))))) ((1) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (_getitem_ forms 0) (list ATOM_TYPE LISP_NIL) stepForm)))))))) (t (let (forms) (setf (values forms end) (getFormsSeparByElem "=" ind innerElems level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ forms 0)) (case (len forms) ((2) (tl-append (_getitem_ form 1) (list FORM_TYPE (_make-vector_ :initContent (list (_getitem_ forms 0) (_getitem_ forms 1)))))) ((1) (tl-append (_getitem_ form 1) (_getitem_ forms 0))))))) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) end innerElems nil)) (cond ((_not_ elemFound) (return-from nil ())))))) (setImplVarForLowerLevel level symbList) form)))
(defun _procName (start elems level onSameLine) (let (elemFound ind) (setf (values elemFound ind) (getRequiredElemInd2 SYMB_ELEM start elems onSameLine)) (cond (elemFound (return-from _procName (values t (_make-vector_ :initContent (list (list ATOM_TYPE (getRealSymbol level (slot-value (_getitem_ elems ind) 'value))))) (_+_ ind 1))))) (setf (values elemFound ind) (getShortcutInd start elems onSameLine)) (cond (elemFound (do () ((_not_ elemFound)) (setf (values elemFound ind) (getShortcutInd (_+_ ind 1) elems))) (setf ind (getRequiredElemInd SYMB_ELEM ind elems)) (setf (slot-value (_getitem_ elems ind) 'value) (getRealSymbol level (slot-value (_getitem_ elems ind) 'value))) (let (form) (setf form (getOneForm 0 (_getitem_ elems (_make-slice_ start (_+_ ind 1) nil)) level nil)) (return-from _procName (values t (_make-vector_ :initContent (list form)) (_+_ ind 1)))))) (setf (values elemFound ind) (getRequiredElemInd2 STR_START_ELEM start elems onSameLine)) (cond (elemFound (let (strAtom end) (setf (values strAtom end) (getStringAtom ind elems)) (return-from _procName (values t (_make-vector_ :initContent (list strAtom)) end))))) (setf (values elemFound ind) (getRequiredElemInd2 ":" start elems onSameLine)) (cond (elemFound (setf ind (getRequiredElemInd SYMB_ELEM (_+_ ind 1) elems)) (return-from _procName (values t (_make-vector_ :initContent (list (list ATOM_TYPE (_+_ ":" (slot-value (_getitem_ elems ind) 'value))))) (_+_ ind 1))))) (values nil (_make-vector_ :initContent (list (list ATOM_TYPE LISP_NIL))) start)))
(defun procName (start elems level addLineNums) (declare (ignore addLineNums)) (_procName start elems level t))
(defun procName2 (start elems level addLineNums) (declare (ignore addLineNums)) (_procName start elems level nil))
(defun procFunName (start elems level addLineNums) (declare (ignore addLineNums)) (let (elemFound ind) (setf (values elemFound ind) (getRequiredElemInd2 SPEC_SYMB_ELEM start elems nil)) (let (isSetter) (setf (values isSetter ind) (cond ((_and_ elemFound (_==_ (slot-value (_getitem_ elems ind) 'value) SETTER_SPEC_SYMB)) (values t (_+_ ind 1))) (t (values nil ind)))) (let (succ formList end) (setf (values succ formList end) (_procName ind elems level nil)) (setf (slot-value level '_lowerLevelFuncName) (_getitem_ (_getitem_ formList 0) 1)) (cond (isSetter (values succ (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE SETTER_FUNC) (_getitem_ formList 0)))))) end)) (t (values succ formList end)))))))
(defun procFunNameFromLevelInfo (start elems level addLineNums) (declare (ignore addLineNums)) (let (funcName) (setf funcName (slot-value level 'blockName)) (cond ((_not_ funcName) (let (errorLineNum) (setf errorLineNum (cond ((_<_ start (len elems)) (slot-value (_getitem_ elems start) 'lineNum)) (t (cond ((_==_ (len elems) 0) (signalSyntaxError "Function name is underfined")) (t (slot-value (_getitem_ elems (_unary-_ 1)) 'lineNum)))))) (signalSyntaxError (_%_ "Function name on line ~D is underfined" errorLineNum)))) (t (values t (_make-vector_ :initContent (list (list ATOM_TYPE funcName))) start)))))
(defun procDoTestResultList (start elems level addLineNums) (let (ind) (setf ind (handler-case (progn (getRequiredElemInd "(" start elems nil)) (tl-syntax-error () (return-from procDoTestResultList (values nil (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE LISP_NIL)))))) start))))) (let (innerElems) (setf (values innerElems ind) (getElemsInBrackets ind elems)) (let (forms) (setf forms (getForms innerElems level addLineNums)) (cond ((_==_ (len forms) 0) (setf forms (_make-vector_ :initContent (list (list ATOM_TYPE LISP_NIL)))))) (values t (_make-vector_ :initContent (list (list FORM_TYPE forms))) (_+_ ind 1))))))
(defun procOperExpr (start elems level addLineNums) (declare (ignore addLineNums)) (let (form end) (setf (values form end) (getOneForm start elems level nil)) (cond (form (values t (_make-vector_ :initContent (list form)) end)) (t (values nil (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_)))) start)))))
(defun _operExprInBrack (start elems level addLineNums singleExpr) (let (brackInd) (setf brackInd (handler-case (progn (getRequiredElemInd "(" start elems)) (tl-syntax-error () (return-from _operExprInBrack (values nil (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_)))) start))))) (let (innerElems ind) (setf (values innerElems ind) (getElemsInBrackets brackInd elems)) (let (forms) (setf forms (getForms innerElems level addLineNums)) (cond ((_==_ (len forms) 0) (signalSyntaxError (_%_ "Missing form(s) in brackets, starting line ~D, position ~D" (list (slot-value (_getitem_ elems brackInd) 'lineNum) (slot-value (_getitem_ elems brackInd) 'start))))) ((_and_ singleExpr (_>_ (len forms) 1)) (signalSyntaxError (_%_ "Expect one form in brackets, starting line ~D, position ~D, but got ~D forms" (list (slot-value (_getitem_ elems brackInd) 'lineNum) (slot-value (_getitem_ elems brackInd) 'start) (len forms)))))) (values t forms (_+_ ind 1))))))
(defun procOperExprInBrack (start elems level addLineNums) (_operExprInBrack start elems level addLineNums t))
(defun procMultOperExprInBrack (start elems level addLineNums) (let (partFound newForms end) (setf (values partFound newForms end) (_operExprInBrack start elems level addLineNums nil))))
(defun _procSpecificList (start elems level listType) (let (ind) (setf ind (handler-case (progn (getRequiredElemInd "(" start elems nil)) (tl-syntax-error () (return-from _procSpecificList (values nil (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_)))) start))))) (let (innerElems) (setf (values innerElems ind) (getElemsInBrackets ind elems)) (let (form) (setf form (tl-case listType nil ((LAMBDA_LIST MAC_LAMBDA_LIST) (_macLambdaListForm innerElems level)) ((LET_LIST) (_letListForm innerElems level)) ((DO_VAR_LIST) (_doVarListForm innerElems level)))) (values t (_make-vector_ :initContent (list form)) (_+_ ind 1))))))
(defun procDoVarList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level DO_VAR_LIST))
(defun procLetList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level LET_LIST))
(defun procLambdaList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level LAMBDA_LIST))
(defun procMacLambdaList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level MAC_LAMBDA_LIST))
(defun _procBlock (start elems level addLineNums) (let (ind) (setf ind (handler-case (progn (getRequiredElemInd "{" start elems nil)) (tl-syntax-error () (return-from _procBlock (values nil (_make-vector_) start))))) (let (innerElems) (setf (values innerElems ind) (getElemsInBrackets ind elems)) (values t (getForms innerElems level addLineNums) (_+_ ind 1)))))
(defun procBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerRegLevel level) addLineNums))
(defun procMacBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerMacLevel level) addLineNums))
(defun procFunBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerFuncLevel level) addLineNums))
(defun _letLikeElemsInBraces (start elems) (let (ind) (setf ind (handler-case (progn (getRequiredElemInd "{" start elems nil)) (tl-syntax-error () (return-from _letLikeElemsInBraces (values nil (_make-vector_) start))))) (let (innerElems end) (setf (values innerElems end) (getElemsInBrackets ind elems)) (values t (_getitem_ (_letListForm innerElems (makeLevelInfo)) 1) (_+_ end 1)))))
(defun procClassOptions (start elems level addLineNums) (declare (ignore addLineNums) (ignore level)) (_letLikeElemsInBraces start elems))
(defun procStructOptions (start elems level addLineNums) (declare (ignore addLineNums) (ignore level)) (_letLikeElemsInBraces start elems))
(defun _funCallLikeElemsInBraces (start elems level slotNameAtom) (let (ind) (setf ind (handler-case (progn (getRequiredElemInd "{" start elems nil)) (tl-syntax-error () (return-from _funCallLikeElemsInBraces (values nil (_make-vector_) start))))) (let (form end) (setf (values form end) (funcCall ind elems level slotNameAtom)) (values t (_getitem_ form 1) end))))
(defun procClassSlotsList (start elems level addLineNums) (declare (ignore addLineNums)) (let (form) (setf form (list FORM_TYPE (_make-vector_))) (let (brackInd) (setf brackInd (handler-case (progn (getRequiredElemInd "{" start elems nil)) (tl-syntax-error () (return-from procClassSlotsList (values nil (_make-vector_ :initContent (list form)) start))))) (let (innerElems end) (setf (values innerElems end) (getElemsInBrackets brackInd elems)) (do ((ind 0)) ((_>=_ ind (len innerElems))) (let (slPresent slName) (setf (values slPresent slName ind) (_procName ind innerElems level nil)) (cond (slPresent (let (optPresent optForms) (setf (values optPresent optForms ind) (_funCallLikeElemsInBraces ind innerElems level (_getitem_ slName 0))) (cond (optPresent (tl-append (_getitem_ form 1) (list FORM_TYPE optForms))) (t (tl-append (_getitem_ form 1) (_getitem_ slName 0)))))) (t (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM COMM_ELEM ",")) ind innerElems nil)) (cond ((_not_ elemFound) (return-from nil ())))))))) (values t (_make-vector_ :initContent (list form)) (_+_ end 1))))))
(defun procStructSlots (start elems level addLineNums) (let (strPres form end) (setf (values strPres form end) (procClassSlotsList start elems level addLineNums)) (values strPres (_getitem_ (_getitem_ form 0) 1) end)))
(defun procMethQualif (start elems level addLineNums) (declare (ignore addLineNums) (ignore level)) (let (elemFound ind) (setf (values elemFound ind) (getRequiredElemInd2 ":" start elems nil)) (cond (elemFound (setf (values elemFound ind) (getRequiredElemInd2 SYMB_ELEM (_+_ ind 1) elems)) (cond (elemFound (return-from procMethQualif (values t (_make-vector_ :initContent (list (list ATOM_TYPE (_+_ ":" (slot-value (_getitem_ elems ind) 'value))))) (_+_ ind 1))))))) (values nil (_make-vector_) start)))
(const BLOCK_FUNCS (_make-hash-table_ FUN_NAME #'procFunName NAME #'procName NAME2 #'procName2 FUN_NAME_FROM_LEVEL #'procFunNameFromLevelInfo LAMBDA_LIST #'procLambdaList MAC_LAMBDA_LIST #'procMacLambdaList MAC_BODY_BLOCK #'procMacBodyBlock FUN_BODY_BLOCK #'procFunBodyBlock BODY_BLOCK #'procBodyBlock LET_LIST #'procLetList DO_VAR_LIST #'procDoVarList DO_TEST_RES_LIST #'procDoTestResultList OPER_EXPR #'procOperExpr OPER_EXPR_IN_BRACK #'procOperExprInBrack MULT_OPER_EXPR_IN_BRACK #'procMultOperExprInBrack STRUCT_SLOTS #'procStructSlots STRUCT_OPTIONS #'procStructOptions CLASS_SLOTS_LIST #'procClassSlotsList CLASS_OPTIONS #'procClassOptions METH_QUALIF #'procMethQualif))
(defun _isStructPresent (part start elems) (cond ((typep (_getitem_ part 0) 'symbol) (let (blockFunc keyPresent) (setf (values blockFunc keyPresent) (_getitem_ BLOCK_FUNCS (_getitem_ part 0))) (cond ((_not_ keyPresent) (signalSyntaxError (_%_ "Handling of block structure '~A' is not implemented." (_getitem_ part 0))))) ; level info object here should be dummy
 (let (partFound newForms ind) (setf (values partFound newForms ind) (funcall blockFunc start elems (makeLevelInfo) nil)) (values partFound start part)))) ((_!=_ (tl-count AUX_SPEC_SYMB (_getitem_ part 0)) 0) (handler-case (progn (let (ind) (setf ind (getRequiredElemInd SPEC_SYMB_ELEM start elems nil)) (cond ((_==_ (_getitem_ part 0) (slot-value (_getitem_ elems ind) 'value)) (values t (_+_ ind 1) (_getitem_ part (_make-slice_ 1 nil nil)))) (t (values nil start part))))) (tl-syntax-error () (values nil start part)))) (t (signalSyntaxError (_%_ "Programming error: inner forms' descriptions in TL_BLOCK should start from either AUX_SPEC_SYMB or a block structure symbol; instead got: ~A" part)))))
(defun _readBlockStructElems (blockDescr firstElemInd elems level addLineNums) (let (forms) (setf forms (_make-vector_)) (let (ind) (setf ind firstElemInd) (tl-for (descr blockDescr) (nil) (let (isOptional) (setf isOptional nil) (let (multiple) (setf multiple nil) (let (part) (setf part (typecase descr (list (tl-for (opt (_getitem_ descr (_make-slice_ 1 nil nil))) (nil) (cond ((_==_ opt OPTIONAL) (setf isOptional t)) ((_==_ opt MULT) (setf multiple t)))) (_getitem_ descr 0)) ((or symbol vector) descr) (t (error (_%_ "Programming error: wrong element in Const.TL_BLOCK - ~A" descr))))) (typecase part (symbol (let (blockFunc keyPresent) (setf (values blockFunc keyPresent) (_getitem_ BLOCK_FUNCS part)) (cond ((_not_ keyPresent) (signalSyntaxError (_%_ "Handling of block structure '~A' is not implemented." part)))) (let (partFound newForms) (setf (values partFound newForms ind) (funcall blockFunc ind elems level addLineNums)) (cond (partFound (cond (multiple (tl-append forms (_make-vector_ :initContent (list newForms))) (do () ((_not_ partFound)) (setf (values partFound newForms ind) (funcall blockFunc ind elems level addLineNums)) (cond (partFound (tl-append (_getitem_ forms (_unary-_ 1)) newForms))))) (t (tl-append forms newForms)))) (t (cond (isOptional (tl-append forms newForms)) (t (signalSyntaxError (_%_ "Required '~A' part of a block structure is missing on line ~D" (list part (slot-value (_getitem_ elems ind) 'lineNum))))))))))) (vector (let (partFound partToRead) (setf (values partFound ind partToRead) (_isStructPresent part ind elems)) (cond (partFound (let (newForms) (setf (values newForms ind) (_readBlockStructElems partToRead ind elems level addLineNums)) (cond (multiple (tl-append forms (_make-vector_ :initContent (list newForms))) (do () (nil) (setf (values partFound ind partToRead) (_isStructPresent part ind elems)) (cond (partFound (setf (values newForms ind) (_readBlockStructElems partToRead ind elems level addLineNums)) (tl-append (_getitem_ forms (_unary-_ 1)) newForms)) (t (return-from nil ()))))) (t (tl-append forms newForms))))) (t (cond (isOptional (tl-append forms (_make-vector_))) (t (signalSyntaxError (_%_ "Required special symbol '~A' is missing on line ~D, position ~D" (list (_getitem_ part 0) (slot-value (_getitem_ elems ind) 'lineNum) (slot-value (_getitem_ elems ind) 'start)))))))))) (t (error (_%_ "Programming error: wrong element in Const.TL_BLOCK - ~A" part)))))))) (values forms ind))))
(defun _descrProcessing (descr blockParts) (typecase descr (string (_make-vector_ :initContent (list (list ATOM_TYPE descr)))) (integer (_getitem_ blockParts descr)) (list (let (isOptional) (setf isOptional nil) (let (multiple) (setf multiple nil) (let (partInd) (setf partInd (_getitem_ descr 0)) (let (descrInd) (setf descrInd 1) (do () (nil) (cond ((_==_ (_getitem_ descr descrInd) OPTIONAL) (setf isOptional t) (setf descrInd (_+_ descrInd 1))) ((_==_ (_getitem_ descr descrInd) MULT) (setf multiple t) (setf descrInd (_+_ descrInd 1))) (t (return-from nil ())))) (cond ((_==_ (len (_getitem_ blockParts partInd)) 0) (cond (isOptional (cond ((_<=_ (len descr) (_+_ descrInd 1)) (_make-vector_)) (t (_descrProcessing (_getitem_ descr (_+_ descrInd 1)) blockParts)))) (t (error "Programming error: not optional element is empty in _writeBlockStructForm")))) (t (cond (multiple (tl-for (part (_getitem_ blockParts partInd) (res (_make-vector_))) (res) (extend res (_descrProcessing (_getitem_ descr descrInd) part)))) (t (_descrProcessing (_getitem_ descr descrInd) (_getitem_ blockParts partInd))))))))))) (vector (_make-vector_ :initContent (list (_writeBlockStructForm descr blockParts)))) (t (error (_%_ "Programming error: description of unknown type in TL_BLOCK's form: ~A" descr)))))
(defun _writeBlockStructForm (formDescr blockParts) (tl-for (descr formDescr (form (list FORM_TYPE (_make-vector_)))) (form) (extend (_getitem_ form 1) (_descrProcessing descr blockParts))))
(defun getBlockForm (firstElemInd elems level addLineNums) (let (blockName) (setf blockName (slot-value (_getitem_ elems firstElemInd) 'value)) (let (blockParts end) (setf (values blockParts end) (_readBlockStructElems (_getitem_ (_getitem_ TL_BLOCK blockName) 0) (_+_ firstElemInd 1) elems level addLineNums)) (values (_writeBlockStructForm (_getitem_ (_getitem_ TL_BLOCK blockName) 1) blockParts) end))))
(defun getBracketedForm (indOpenBr elems level addLineNums) (let (innerElems indClosBr) (setf (values innerElems indClosBr) (getElemsInBrackets indOpenBr elems)) (values (list FORM_TYPE (getForms innerElems level addLineNums)) (_+_ indClosBr 1))))
(defun getSimpleArrayForm (start elems level) (let (innerElems indClosBr) (setf (values innerElems indClosBr) (getElemsInBrackets start elems)) (let (form) (setf form (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE MAKE_SIMPLE_ARRAY_FUNC))))) (let (initElems) (setf initElems (getForms innerElems level nil)) (cond ((_!=_ (len initElems) 0) (tl-append (_getitem_ form 1) (list ATOM_TYPE ":initContent")) (tl-append (_getitem_ form 1) (list FORM_TYPE (_+_ (_make-vector_ :initContent (list (list ATOM_TYPE "list"))) initElems))))) (values form (_+_ indClosBr 1))))))
(defun getListForm (start elems level) (let (innerElems indClosBr) (setf (values innerElems indClosBr) (getElemsInBrackets start elems)) (let (form) (setf form (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE MAKE_LIST_FUNC))))) (extend (_getitem_ form 1) (getForms innerElems level nil)) (values form (_+_ indClosBr 1)))))
(defun getFormAfterElem (elemType start elems level) (let (elemFound separInd) (setf (values elemFound separInd) (getElemIndInOperExpr elemType start elems)) (cond (elemFound (let (form end) (setf (values form end) (getOneForm (_+_ separInd 1) elems level nil)) (cond ((_not_ form) (signalSyntaxError (_%_ "Missing a form after '~A' on line ~D, position ~D" (list (slot-value (_getitem_ elems separInd) 'type) (slot-value (_getitem_ elems separInd) 'lineNum) (slot-value (_getitem_ elems separInd) 'start)))))) (values form separInd end))) (t (values nil nil separInd)))))
(defun getFormsSeparByElem (elemType start elems level) (let (forms) (setf forms (_make-vector_)) (let (secondForm separInd end) (setf (values secondForm separInd end) (getFormAfterElem elemType start elems level)) (cond (secondForm (let (firstForm endFirstForm) (setf (values firstForm endFirstForm) (getOneForm 0 (_getitem_ elems (_make-slice_ start separInd nil)) level nil)) (cond (firstForm (tl-append forms firstForm)) (t (signalSyntaxError (_%_ "Missing a form before '~A' on line ~D, position ~D" (list (slot-value (_getitem_ elems separInd) 'type) (slot-value (_getitem_ elems separInd) 'lineNum) (slot-value (_getitem_ elems separInd) 'start)))))) (tl-append forms secondForm))) (t (let (firstForm) (setf (values firstForm end) (getOneForm start elems level nil)) (cond (firstForm (tl-append forms firstForm)))))) (values forms end))))
(defun getDictForm (start elems level) (let (innerElems indClosBr) (setf (values innerElems indClosBr) (getElemsInBrackets start elems)) (let (form) (setf form (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE MAKE_DICTIONARY_FUNC))))) (do ((ind 0)) ((_>=_ ind (len innerElems))) (let (forms) (setf (values forms ind) (getFormsSeparByElem "->" ind innerElems level)) (tl-append (_getitem_ form 1) (_getitem_ forms 0)) (case (len forms) ((2) (tl-append (_getitem_ form 1) (_getitem_ forms 1))) ((1) (tl-append (_getitem_ form 1) (list ATOM_TYPE LISP_NIL)))) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) ind innerElems nil)) (cond ((_not_ elemFound) (return-from nil ())))))) (values form (_+_ indClosBr 1)))))
(defun getNFormsInBrack (start elems level numForms) (let (innerElems indClosBr) (setf (values innerElems indClosBr) (getElemsInBrackets start elems)) (let (forms) (setf forms (getForms innerElems level nil)) (cond ((_==_ (len forms) 0) (signalSyntaxError (_%_ "Empty brackets, starting line ~D, position ~D" (list (slot-value (_getitem_ elems start) 'lineNum) (slot-value (_getitem_ elems start) 'start))))) ((_!=_ (len forms) numForms) (signalSyntaxError (_%_ "Brackets, starting line ~D, position ~D, contain ~D forms instead of ~D" (list (slot-value (_getitem_ elems start) 'lineNum) (slot-value (_getitem_ elems start) 'start) (len forms) numForms))))) (values forms (_+_ indClosBr 1)))))
(defun getComplNumForm (start elems level) (let (ind) (setf ind (getRequiredElemInd "(" (_+_ start 1) elems)) (let (forms end) (setf (values forms end) (getNFormsInBrack ind elems level 2)) (values (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE MAKE_COMPLEX_NUM_FUNC) (_getitem_ forms 0) (_getitem_ forms 1)))) end))))
(defun funcCall (start elems level lastForm) (let (innerElems indClosBr) (setf (values innerElems indClosBr) (getElemsInBrackets start elems)) (let (form) (setf form (list FORM_TYPE (_make-vector_))) (cond (lastForm (tl-append (_getitem_ form 1) lastForm))) (do ((ind 0)) ((_>=_ ind (len innerElems))) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) ind innerElems nil)) (cond ((_not_ elemFound) (return-from nil ()))) (cond ((_==_ (slot-value (_getitem_ innerElems ind) 'type) ".") (let (brackInd) (setf brackInd (getRequiredElemInd "(" (_+_ ind 1) innerElems)) (let (innerListForm) (setf (values innerListForm ind) (funcCall brackInd innerElems level nil)) (tl-append (_getitem_ form 1) innerListForm)))) (t (let (forms) (setf (values forms ind) (getFormsSeparByElem "=" ind innerElems level)) (extend (_getitem_ form 1) forms)))))) (values form (_+_ indClosBr 1)))))
(defun getitemFuncCall (start elems level lastForm) (let (form) (setf form (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE GET_ITEM_FUNC) lastForm)))) (let (innerElems indClosBr) (setf (values innerElems indClosBr) (getElemsInBrackets start elems)) (let (arrowPres arrowInd) (setf (values arrowPres arrowInd) (getElemIndInOperExpr "->" 0 innerElems)) (tl-append (_getitem_ form 1) (cond (arrowPres (let (indexForm) (setf indexForm (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE MAKE_SLICE_FUNC))))) (let (startForm) (setf startForm (getOneForm 0 (_getitem_ innerElems (_make-slice_ 0 arrowInd nil)) level nil)) (let (endForm endEndForm) (setf (values endForm endEndForm) (getOneForm (_+_ arrowInd 1) innerElems level nil)) (let (elemFound ind) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) endEndForm innerElems nil)) (let (stepForm) (setf stepForm (cond (elemFound (getOneForm ind innerElems level nil)) (t nil))) (cond (startForm (tl-append (_getitem_ indexForm 1) startForm)) (t (tl-append (_getitem_ indexForm 1) (list ATOM_TYPE LISP_NIL)))) (cond (endForm (tl-append (_getitem_ indexForm 1) endForm)) (t (cond ((_not_ startForm) (signalSyntaxError (_%_ "No index present in brackets on line ~D, position ~D" (list (slot-value (_getitem_ elems start) 'lineNum) (slot-value (_getitem_ elems start) 'start)))))) (tl-append (_getitem_ indexForm 1) (list ATOM_TYPE LISP_NIL)))) (cond (stepForm (tl-append (_getitem_ indexForm 1) stepForm)) (t (tl-append (_getitem_ indexForm 1) (list ATOM_TYPE LISP_NIL)))) indexForm)))))) (t (let (indexForms) (setf indexForms (getForms innerElems level nil)) (case (len indexForms) ((1) (_getitem_ indexForms 0)) ((0) (signalSyntaxError (_%_ "Expected index is missing in brackets on line ~D, position ~D" (list (slot-value (_getitem_ elems start) 'lineNum) (slot-value (_getitem_ elems start) 'start))))) (otherwise (list FORM_TYPE (_+_ (_make-vector_ :initContent (list (list ATOM_TYPE MAKE_LIST_FUNC))) indexForms)))))))) (values form (_+_ indClosBr 1))))))
(defun slotOrFuncCall (start elems level lastForm addLineNums) (let (nameInd) (setf nameInd (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems)) (let (elemFound ind) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM)) (_+_ nameInd 1) elems)) (cond (elemFound (tl-case (slot-value (_getitem_ elems ind) 'type) nil (("(") (let (form) (setf (values form ind) (funcCall ind elems level lastForm)) (insert (_getitem_ form 1) 0 (list ATOM_TYPE (getRealSymbol level (slot-value (_getitem_ elems nameInd) 'value)))) (return-from slotOrFuncCall (values form ind)))) (("{") (return-from slotOrFuncCall (extendWithBodyBlock ind elems level (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE (getRealSymbol level (slot-value (_getitem_ elems nameInd) 'value))) lastForm))) addLineNums)))))) (values (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE GET_OBJ_SLOT_FUNC) lastForm (list SHORTCUT_TYPE "'" (list ATOM_TYPE (getRealSymbol level (slot-value (_getitem_ elems nameInd) 'value))))))) (_+_ nameInd 1)))))
(defun packOrKeywName (start elems lastForm) (cond (lastForm (let (updatedLastForm) (setf updatedLastForm lastForm) (let (packageNamePresent) (setf packageNamePresent nil) (cond ((_==_ (_getitem_ updatedLastForm 0) ATOM_TYPE) (setf updatedLastForm (list ATOM_TYPE (_+_ (_getitem_ updatedLastForm 1) (slot-value (_getitem_ elems start) 'type)))) (setf packageNamePresent t))) (let (ind) (setf ind (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems)) (cond (packageNamePresent (values nil (list ATOM_TYPE (_+_ (_getitem_ updatedLastForm 1) (slot-value (_getitem_ elems ind) 'value))) (_+_ ind 1))) (t (values (list ATOM_TYPE (_+_ (slot-value (_getitem_ elems start) 'type) (slot-value (_getitem_ elems ind) 'value))) updatedLastForm (_+_ ind 1)))))))) (t (let (ind) (setf ind (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems)) (values (list ATOM_TYPE (_+_ (slot-value (_getitem_ elems start) 'type) (slot-value (_getitem_ elems ind) 'value))) nil (_+_ ind 1))))))
(defun extendWithBodyBlock (start elems level lastForm addLineNums) (let (trueVal forms end) (setf (values trueVal forms end) (procBodyBlock start elems level addLineNums)) (let (form) (setf form lastForm) (cond ((_!=_ (_getitem_ form 0) FORM_TYPE) (setf form (list FORM_TYPE (_make-vector_ :initContent (list form)))))) (extend (_getitem_ form 1) forms) (values form end))))
(defun getStringAtom (start elems) (do ((atom (list ATOM_TYPE (slot-value (_getitem_ elems start) 'value))) (ind (_+_ start 1))) ((_>=_ ind (len elems)) (signalSyntaxError (_%_ "Cannot find the end of the string started on line ~D, position ~D" (list (slot-value (_getitem_ elems start) 'lineNum) (slot-value (_getitem_ elems start) 'start))))) (tl-case (slot-value (_getitem_ elems ind) 'type) ((error (_%_ "Programming error: Before string ends, have an unexpected type of StrElem - '~A', on line ~D, position ~D" (list (slot-value (_getitem_ elems ind) 'type) (slot-value (_getitem_ elems ind) 'lineNum) (slot-value (_getitem_ elems ind) 'start))))) ((LINE_END_ELEM) (setf ind (growOnIndex elems (_+_ ind 1)))) ((STR_MID_ELEM) (_+=_ (_getitem_ atom 1) (slot-value (_getitem_ elems ind) 'value)) (_+=_ ind 1)) ((STR_END_ELEM) (_+=_ (_getitem_ atom 1) (slot-value (_getitem_ elems ind) 'value)) (return-from nil (values atom (_+_ ind 1)))))))
(defun getCLispAtom (start elems) (do ((atom (list ATOM_TYPE "")) (ind (_+_ start 1))) ((_>=_ ind (len elems)) (signalSyntaxError (_%_ "Cannot find the end of the common lisp code started on line ~D, position ~D" (list (slot-value (_getitem_ elems start) 'lineNum) (slot-value (_getitem_ elems start) 'start))))) (tl-case (slot-value (_getitem_ elems ind) 'type) ((error (_%_ "Programming error: Before Common Lisp code ends, have an unexpected type of StrElem - '~A', from line ~D, position ~D" (list (slot-value (_getitem_ elems ind) 'type) (slot-value (_getitem_ elems ind) 'lineNum) (slot-value (_getitem_ elems ind) 'start))))) ((LINE_END_ELEM) (setf ind (growOnIndex elems (_+_ ind 1)))) ((CLISP_MID_ELEM) (_+=_ (_getitem_ atom 1) (slot-value (_getitem_ elems ind) 'value)) (_+=_ ind 1)) ((CLISP_END_ELEM) (_+=_ (_getitem_ atom 1) (slot-value (_getitem_ elems ind) 'value)) (return-from nil (values atom (_+_ ind 1)))))))
(defun twLispDirectiveProc (start elems level) (tl-case (slot-value (_getitem_ elems start) 'value) ((error (_%_ "Handling of a TwinLisp directive '~A' on line ~D, position ~D, is not implemented, yet." (list (slot-value (_getitem_ elems start) 'value) (slot-value (_getitem_ elems start) 'lineNum) (slot-value (_getitem_ elems start) 'start))))) ((TL_DIR_GLOBAL) (let (ind) (setf ind (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems nil)) (cond ((_==_ (tl-count (slot-value level 'currImplVar) (slot-value (_getitem_ elems ind) 'value)) 0) (tl-append (slot-value level 'currImplVar) (slot-value (_getitem_ elems ind) 'value)))) (_+_ ind 1))) ((TL_DIR_LEXSCOPE) (let (ind) (setf ind (getRequiredElemInd SPEC_SYMB_ELEM (_+_ start 1) elems nil)) (cond ((_==_ (slot-value (_getitem_ elems ind) 'value) TL_EXPL_SCOPE) (setf (slot-value level 'implScope) nil)) ((_==_ (slot-value (_getitem_ elems ind) 'value) TL_IMPL_SCOPE) (setf (slot-value level 'implScope) t)) (t (signalSyntaxError (_%_ "Unexpected element '~A' on line ~D, position ~D" (list (slot-value (_getitem_ elems ind) 'value) (slot-value (_getitem_ elems ind) 'lineNum) (slot-value (_getitem_ elems ind) 'start)))))) (_+_ ind 1))) ((TL_DIR_USE) (let (packName) (setf packName "") (let (elemFound ind) (setf (values elemFound ind) (getRequiredElemInd2 SYMB_ELEM (_+_ start 1) elems nil)) (cond (elemFound (_+=_ packName (_+_ (slot-value (_getitem_ elems ind) 'value) ":")) (_+=_ ind 1))) (setf (values elemFound ind) (getRequiredElemInd2 ":" ind elems nil)) (cond (elemFound (_+=_ packName ":") (_+=_ ind 1))) (setf ind (getRequiredElemInd "{" ind elems nil)) (let (innerElems) (setf (values innerElems ind) (getElemsInBrackets ind elems)) (let (end) (setf end (_+_ ind 1)) (do ((ind 0)) ((_>=_ ind (len innerElems))) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) ind innerElems nil)) (cond ((_not_ elemFound) (return-from nil ()))) (setf ind (getRequiredElemInd SYMB_ELEM ind innerElems nil)) (let (symbName) (setf symbName (slot-value (_getitem_ innerElems ind) 'value)) (cond ((_<_ (_+_ ind 1) (len innerElems)) (setf (values elemFound ind) (getRequiredElemInd2 "=" (_+_ ind 1) innerElems))) (t (setf elemFound nil))) (let (nickName) (setf nickName (cond (elemFound (cond ((_<_ (_+_ ind 1) (len innerElems)) (setf ind (getRequiredElemInd SYMB_ELEM (_+_ ind 1) innerElems nil))) (t (signalSyntaxError (_%_ "Expected element '~A', on line ~D is missing" (list SYMB_ELEM (slot-value (_getitem_ innerElems ind) 'lineNum)))))) (slot-value (_getitem_ innerElems ind) 'value)) (t symbName))) (addSymbSynonym level nickName (_+_ packName symbName)) (_+=_ ind 1)))) end)))))))
(const _COMMENT :comment)
(const _OP :operator)
(const _UN_OP :unar-oper)
(const _UN_BIN_OP :unar-or-bin-oper)
(const _BIN_OP :bin-oper)
(const _EXPR :expression)
(const _SHORTCUT :shortcut)
(const _NONE :none)
(defun _lastOpExType (operAndExpr) (cond ((_>_ (len operAndExpr) 0) (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 0)) (t _NONE)))
(defun getOperAndExpr (startInd elems level addLineNums) (do ((operAndExpr (_make-vector_)) (ind startInd)) ((_>=_ ind (len elems)) (values operAndExpr ind)) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM)) ind elems)) ; Does not go to the next line
 (cond ((_not_ elemFound) (return-from nil (values operAndExpr ind)))) (let (el) (setf el (_getitem_ elems ind)) (cond ((_or_ (_==_ (slot-value el 'type) ",") (_==_ (slot-value el 'type) LINE_END_ELEM)) (return-from nil (values operAndExpr ind))) ((_==_ (slot-value el 'type) COMM_ELEM) (cond ((_==_ (len operAndExpr) 0) (tl-append operAndExpr (list _COMMENT (list COMMENT_TYPE (slot-value el 'value)))) (_+=_ ind 1))) (return-from nil (values operAndExpr ind))) ((_==_ (slot-value el 'type) SYMB_ELEM) (tl-append operAndExpr (list _EXPR (list ATOM_TYPE (getRealSymbol level (slot-value el 'value))))) (_+=_ ind 1)) ((_or_ (_==_ (slot-value el 'type) NUM_ELEM) (_==_ (slot-value el 'type) SYNT_STRUCT_ELEM)) (tl-append operAndExpr (list _EXPR (list ATOM_TYPE (slot-value el 'value)))) (_+=_ ind 1)) ((_==_ (slot-value el 'type) STR_START_ELEM) (let (atom) (setf (values atom ind) (getStringAtom ind elems)) (tl-append operAndExpr (list _EXPR atom)))) ((_==_ (slot-value el 'type) CLISP_START_ELEM) (let (atom) (setf (values atom ind) (getCLispAtom ind elems)) (tl-append operAndExpr (list _EXPR atom)))) ((_or_ (_==_ (slot-value el 'type) ":") (_==_ (slot-value el 'type) "::")) (let (lastForm) (setf lastForm (cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1)) (t nil))) (let (form) (setf (values form lastForm ind) (packOrKeywName ind elems lastForm)) (cond (lastForm (setf (_getitem_ operAndExpr (_unary-_ 1)) (list _EXPR lastForm)))) (cond (form (tl-append operAndExpr (list _EXPR form))))))) ((_==_ (slot-value el 'type) SPEC_SYMB_ELEM) (cond ((has_key TL_BLOCK (slot-value el 'value)) (let (form) (setf (values form ind) (getBlockForm ind elems level addLineNums)) (tl-append operAndExpr (list _EXPR form)))) ((_!=_ (tl-count TL_DIRECT_SPEC_SYMB (slot-value el 'value)) 0) (setf ind (twLispDirectiveProc ind elems level))) (t (signalSyntaxError (_%_ "Unexpected element '~A' on line ~D, position ~D" (list (slot-value el 'value) (slot-value el 'lineNum) (slot-value el 'start))))))) ((_==_ (slot-value el 'type) "~(") (let (form) (setf (values form ind) (getBracketedForm ind elems level addLineNums)) (tl-append operAndExpr (list _EXPR form)))) ((_==_ (slot-value el 'type) "~[") (let (form) (setf (values form ind) (getListForm ind elems level)) (tl-append operAndExpr (list _EXPR form)))) ((_==_ (slot-value el 'type) "(") (cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (let (form) (setf (values form ind) (funcCall ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1))) (setf (_getitem_ operAndExpr (_unary-_ 1)) (list _EXPR form)))) (t (let (forms) (setf (values forms ind) (getNFormsInBrack ind elems level 1)) (tl-append operAndExpr (list _EXPR (_getitem_ forms 0))))))) ((_==_ (slot-value el 'type) "[") (cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (let (form) (setf (values form ind) (getitemFuncCall ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1))) (setf (_getitem_ operAndExpr (_unary-_ 1)) (list _EXPR form)))) (t (let (form) (setf (values form ind) (getSimpleArrayForm ind elems level)) (tl-append operAndExpr (list _EXPR form)))))) ((_==_ (slot-value el 'type) "{") (cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (let (form) (setf (values form ind) (extendWithBodyBlock ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1) addLineNums)) (setf (_getitem_ operAndExpr (_unary-_ 1)) (list _EXPR form)))) (t (let (form) (setf (values form ind) (getDictForm ind elems level)) (tl-append operAndExpr (list _EXPR form)))))) ((_and_ (_==_ (slot-value el 'type) ".") (_==_ (_lastOpExType operAndExpr) _EXPR)) (let (form) (setf (values form ind) (slotOrFuncCall ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1) addLineNums)) (setf (_getitem_ operAndExpr (_unary-_ 1)) (list _EXPR form)))) ((has_key SHORTCUT_OPERS (slot-value el 'type)) (tl-append operAndExpr (list _SHORTCUT el)) (_+=_ ind 1)) ((_!=_ (tl-count COMPL_NUM_OPER (slot-value el 'type)) 0) (let (form) (setf (values form ind) (getComplNumForm ind elems level)) (tl-append operAndExpr (list _EXPR form)))) ((has_key UNAR_OPERS (slot-value el 'type)) (cond ((has_key BIN_OPERS (slot-value el 'type)) (tl-append operAndExpr (list _UN_BIN_OP el))) (t (tl-append operAndExpr (list _UN_OP el)))) (_+=_ ind 1)) ((has_key BIN_OPERS (slot-value el 'type)) (tl-append operAndExpr (list _BIN_OP el)) (_+=_ ind 1)) (t (signalSyntaxError (_%_ "Unexpected element of type '~A' on line ~D at position ~D" (list (slot-value el 'type) (slot-value el 'lineNum) (slot-value el 'start))))))))))
(defun _reduceBinaryOper (operStack exprStack nextOper) (let (nextOpPrec) (setf nextOpPrec (_getitem_ (_getitem_ BIN_OPERS (slot-value nextOper 'type)) 1)) (do () ((_==_ (len operStack) 0)) (let (lastOpType) (setf lastOpType (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) (let (lastOpPrec) (setf lastOpPrec (_getitem_ (_getitem_ BIN_OPERS lastOpType) 1)) (cond ((_or_ (_<_ lastOpPrec nextOpPrec) (_and_ (_==_ lastOpPrec nextOpPrec) (_or_ (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) LEFT_ASSOC) (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) MULT_ARGS_ASSOC)))) (let (reducedExpr) (setf reducedExpr nil) (cond ((_and_ (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) MULT_ARGS_ASSOC) (_==_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) FORM_TYPE)) (cond ((_==_ (_getitem_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) 0) (list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0))) (setf reducedExpr (list (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) (_+_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) (_make-vector_ :initContent (list (_getitem_ exprStack (_unary-_ 1))))))))))) (cond ((_not_ reducedExpr) (setf reducedExpr (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0)) (_getitem_ exprStack (_unary-_ 2)) (_getitem_ exprStack (_unary-_ 1)))))))) (tl-pop exprStack) (setf (_getitem_ exprStack (_unary-_ 1)) reducedExpr) (tl-pop operStack))) (t (return-from nil ()))))))))
(defun _reduceUnaryOper (operStack exprStack expr) (let (reducedExpr) (setf reducedExpr expr) (do () ((_==_ (len operStack) 0)) (cond ((_==_ (_getitem_ (_getitem_ operStack (_unary-_ 1)) 0) _UN_OP) (let (funcName) (setf funcName (_getitem_ (_getitem_ UNAR_OPERS (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) 0)) (setf reducedExpr (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE funcName) reducedExpr)))) (tl-pop operStack))) (t (return-from nil ())))) (tl-append exprStack reducedExpr)))
(defun _reduceShorcut (operStack exprStack opex) (let (reducedExpr) (setf reducedExpr (tl-case (_getitem_ opex 0) nil ((_EXPR) (_getitem_ opex 1)) ((_BIN_OP _UN_BIN_OP) (list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS (slot-value (_getitem_ opex 1) 'type)) 0))) ((_UN_OP) (list ATOM_TYPE (_getitem_ (_getitem_ UNAR_OPERS (slot-value (_getitem_ opex 1) 'type)) 0))))) (do () ((_==_ (len operStack) 0)) (cond ((_==_ (_getitem_ (_getitem_ operStack (_unary-_ 1)) 0) _SHORTCUT) (setf reducedExpr (list SHORTCUT_TYPE (_getitem_ SHORTCUT_OPERS (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) reducedExpr)) (tl-pop operStack)) (t (return-from nil ())))) (_reduceUnaryOper operStack exprStack reducedExpr)))
(defun _getFinalForm (operStack exprStack level) "This works with the assumption that only binary operators could have been left" (cond ((_==_ (len exprStack) 0) (cond ((_==_ (len operStack) 0) (return-from _getFinalForm nil)) (t (signalSyntaxError (_%_ "Missing expression(s) to apply operator '~A' on line ~D, position ~D" (list (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type) (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'lineNum) (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'start)))))))) (do () ((_==_ (len operStack) 0)) (let (lastOpType) (setf lastOpType (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) (let (reducedExpr) (setf reducedExpr nil) (cond ((_and_ (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) MULT_ARGS_ASSOC) (_==_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) FORM_TYPE)) (cond ((_==_ (_getitem_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) 0) (list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0))) (setf reducedExpr (list (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) (_+_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) (_make-vector_ :initContent (list (_getitem_ exprStack (_unary-_ 1))))))))))) (cond ((_not_ reducedExpr) (cond ((_==_ lastOpType "=") (_formSymbAsImplVar level (_getitem_ exprStack (_unary-_ 2))))) (setf reducedExpr (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0)) (_getitem_ exprStack (_unary-_ 2)) (_getitem_ exprStack (_unary-_ 1)))))))) (tl-pop exprStack) (setf (_getitem_ exprStack (_unary-_ 1)) reducedExpr) (tl-pop operStack)))) (_getitem_ exprStack (_unary-_ 1)))
(defun getOperForm (operAndExpr level) "Takes mixture of expr's and oper's and puts 'em into expr, whos form is returned.
    _SHORTCUT has precedence 0, and RIGHT_ASSOC. Note: _SHORTCUT changes the following oper to expr.
    Looking at UNAR_OPERS we note that all unary operators are RIGHT_ASSOC. Since there are no LEFT_ASSOC unary operators, their precedence does not matter. So, here we'll assume that *all unary* operators are RIGHT_ASSOC, and we won't bother with looking ahead, etc.
    Two consequent expr's is an error. Later, check for this should be moved to getOperAndExpr, were info about line positions is available, and more informative error message can be generated." (let (operStack) (setf operStack (_make-vector_)) (let (exprStack) (setf exprStack (_make-vector_)) (let (lastElemType) (setf lastElemType _NONE) (do ((ind 0)) ((_>=_ ind (len operAndExpr))) (let (opex) (setf opex (_getitem_ operAndExpr ind)) (let (curr) (setf curr (_getitem_ opex 0)) (tl-case lastElemType ((error (_%_ "Programming error: lastElemType has invalid value '~A'" curr))) ((_EXPR) (tl-case curr ((error (_%_ "Programming error: type of element in operAndExpr has invalid value '~A'" curr))) ((_EXPR _UN_OP _SHORTCUT) (signalSyntaxError "It is illegal to have two consequent expressions in an operator form")) ((_BIN_OP _UN_BIN_OP) (_reduceBinaryOper operStack exprStack (_getitem_ opex 1)) (tl-append operStack (list _BIN_OP (_getitem_ opex 1))) (setf lastElemType _OP)) ((_COMMENT) (error "Programming error: getOperAndExpr should separate operator expressions and comments")))) ((_OP) (tl-case curr ((error (_%_ "Programming error: type of element in operAndExpr has invalid value '~A'" curr))) ((_BIN_OP) (signalSyntaxError (_%_ "Unexpected operator '~A' on line ~D, position ~D" (list (slot-value (_getitem_ opex 1) 'type) (slot-value (_getitem_ opex 1) 'lineNum) (slot-value (_getitem_ opex 1) 'start))))) ((_UN_OP _UN_BIN_OP) (tl-append operStack (list _UN_OP (_getitem_ opex 1)))) ((_SHORTCUT) (tl-append operStack opex) (setf lastElemType _SHORTCUT)) ((_EXPR) (_reduceUnaryOper operStack exprStack (_getitem_ opex 1)) (setf lastElemType _EXPR)) ((_COMMENT) (signalSyntaxError (_%_ "Comment prematurely ends operator form on line ~D, after position ~D" (list (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'lineNum) (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'end))))))) ((_NONE) (tl-case curr ((signalSyntaxError (_%_ "Programming error: type of element in operAndExpr has invalid value '~A'" curr))) ((_BIN_OP) (signalSyntaxError (_%_ "Operator '~A' on line ~D, position ~D, is not preceded by any expression" (list (slot-value (_getitem_ opex 1) 'type) (slot-value (_getitem_ opex 1) 'lineNum) (slot-value (_getitem_ opex 1) 'start))))) ((_UN_OP _UN_BIN_OP) (tl-append operStack (list _UN_OP (_getitem_ opex 1))) (setf lastElemType _OP)) ((_SHORTCUT) (tl-append operStack opex) (setf lastElemType _SHORTCUT)) ((_EXPR) (tl-append exprStack (_getitem_ opex 1)) (setf lastElemType _EXPR)) ((_COMMENT) (return-from getOperForm (_getitem_ opex 1))))) ((_SHORTCUT) (tl-case curr ((_reduceShorcut operStack exprStack opex) (setf lastElemType _EXPR)) ((_SHORTCUT) (tl-append operStack opex)) ((_COMMENT) (signalSyntaxError (_%_ "Comment prematurely ends operator form on line ~D, after position ~D" (list (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'lineNum) (slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'end)))))))) (_+=_ ind 1)))) (cond ((_or_ (_==_ lastElemType _OP) (_==_ lastElemType _SHORTCUT)) (signalSyntaxError "Premature end of operator expression"))) (_getFinalForm operStack exprStack level)))))
(defun getOneForm (startInd elems level addLineNums) ; returns only one first form or atom
 (let (operAndExpr end) (setf (values operAndExpr end) (getOperAndExpr startInd elems level addLineNums)) (let (form) (setf form (getOperForm operAndExpr level)) (values form end))))
(defun getForms (elems level &optional (addLineNums nil)) (let (formsAndVars) (setf formsAndVars (_make-vector_)) (do ((ind 0)) ((_>=_ ind (len elems))) (let (elemFound) (setf (values elemFound ind) (skipElems (_make-vector_ :initContent (list WHITE_ELEM ",")) ind elems nil)) (cond ((_not_ elemFound) (return-from nil ()))) (cond (addLineNums (tl-append formsAndVars (list (_make-vector_) (list COMMENT_TYPE (_%_ "; source line # ~D" (slot-value (_getitem_ elems ind) 'lineNum))))))) (let (form) (setf (values form ind) (getOneForm ind elems level addLineNums)) (cond (form (tl-append formsAndVars (list (slot-value level 'newVars) form)) (setf (slot-value level 'newVars) (_make-vector_))))))) (let (forms) (setf forms (_make-vector_)) (cond ((slot-value level 'isTopLevel) (tl-for (varAndForm formsAndVars) (nil) (tl-append forms (_getitem_ varAndForm 1)))) (t (let (innerForms) (setf innerForms forms) (tl-for (varAndForm formsAndVars) (nil) (cond ((_!=_ (len (_getitem_ varAndForm 0)) 0) (let (form) (setf form (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_)))))) (tl-for (symbName (_getitem_ varAndForm 0)) (nil) (tl-append (_getitem_ (_getitem_ (_getitem_ form 1) 1) 1) (list ATOM_TYPE symbName))) (tl-append innerForms form) (setf innerForms (_getitem_ form 1))))) (tl-append innerForms (_getitem_ varAndForm 1)))))) forms)))
