#!/usr/bin/env bash

# Copyright (C) 2007 Juan Manuel Borges Caño

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

TW_AUTHOR="[@]pkgauthor[@]"
TW_DESCRIPTION="[@]pkgdescription[@]"
TW="$(basename $0)"
TW_BUGREPORT="[@]pkgbugreport[@]"
TW_DATADIR="[@]pkgdatadir[@]"

function tw_twd
{
	if [[ -f "$1" ]]
	then
		TW_TERM=$(sed -e 's,(,\\(,g' -e 's,),\\),g' <<< "$2")
		gawk -F" : " '$1 ~ /'"$TW_TERM"'/' "$1"
		exit 0
	else
		TW_DICTIONARY="$1"
		printf "The dictionary $TW_DICTIONARY doesn't exists.\n"
		exit 1
	fi
}

function tw_freetranslation
{
	case "${1##*.}" in
		en-es) TW_LANGUAGE="English/Spanish";;
		es-en) TW_LANGUAGE="Spanish/English";;
		en-fr) TW_LANGUAGE="English/French";;
		fr-en) TW_LANGUAGE="French/English";;
		en-de) TW_LANGUAGE="English/German";;
		de-en) TW_LANGUAGE="German/English";;
		en-it) TW_LANGUAGE="English/Italian";;
		it-en) TW_LANGUAGE="Italian/English";;
		en-nl) TW_LANGUAGE="English/Dutch";;
		nl-en) TW_LANGUAGE="Dutch/English";;
		en-pt) TW_LANGUAGE="English/Portuguese";;
		pt-en) TW_LANGUAGE="Portuguese/English";;
#		en-ru) TW_LANGUAGE="English/Russian";;
#		ru-en) TW_LANGUAGE="Russian/English";;
		en-no) TW_LANGUAGE="English/Norwegian";;
#		en-jp) TW_LANGUAGE="English/Japanese";;
#		jp-en) TW_LANGUAGE="Japanese/English";;
#		en-zh) TW_LANGUAGE="English/SimplifiedChinese";;
#		en-zt) TW_LANGUAGE="English/TraditionalChinese";;
	esac
	TW_TERM=$(iconv -f "UTF-8" -t "ISO-8859-15" <<< "$2")
	curl -s -d "srctext=${TW_TERM}" -d "language=${TW_LANGUAGE}" \
	-d "sequence=core" http://ets.freetranslation.com | \
	iconv -f "ISO-8859-15" -t "UTF-8"
	printf "\n"
}

function tw_ls_dictionaries_freetranslation
{
	printf "www.freetranslation.com.de-en\n"
	printf "www.freetranslation.com.en-de\n"
	printf "www.freetranslation.com.en-es\n"
	printf "www.freetranslation.com.en-fr\n"
	printf "www.freetranslation.com.en-it\n"
#	printf "www.freetranslation.com.en-jp\n"
	printf "www.freetranslation.com.en-nl\n"
	printf "www.freetranslation.com.en-no\n"
	printf "www.freetranslation.com.en-pt\n"
#	printf "www.freetranslation.com.en-ru\n"
	printf "www.freetranslation.com.es-en\n"
	printf "www.freetranslation.com.fr-en\n"
	printf "www.freetranslation.com.it-en\n"
#	printf "www.freetranslation.com.jp-en\n"
	printf "www.freetranslation.com.nl-en\n"
	printf "www.freetranslation.com.pt-en\n"
#	printf "www.freetranslation.com.ru-en\n"
#	printf "www.freetranslation.com.zh-en\n"
#	printf "www.freetranslation.com.zt-en\n"
}

function tw_google_language_tools
{
	case "${1##*.}" in
		zh_zt) TW_LANGUAGE="zh-CN|zh-TW";;
		zt_zh) TW_LANGUAGE="zh_TW|zh-CN";;
		en_zh) TW_LANGUAGE="en|zh-CN";;
		en_zt) TW_LANGUAGE="en|zh_TW";;
		*)TW_LANGUAGE=$(printf ${1##*.} | tr '-' '|');;
	esac
	TW_TERM="$2"
	curl -s -A "Mozilla/5.0" -d "hl=en" -d "ie=UTF8" -d "text=${TW_TERM}" \
	-d "langpair=${TW_LANGUAGE}" http://translate.google.com/translate_t | \
	grep "gtrans" | gawk -F"gtrans" '{print $2}' | cut -d'"' -f2
}

function tw_ls_dictionaries_google_language_tools
{
	printf "translate.google.com.ar-en\n"
	printf "translate.google.com.de-en\n"
	printf "translate.google.com.de-fr\n"
	printf "translate.google.com.en-ar\n"
	printf "translate.google.com.en-de\n"
	printf "translate.google.com.en-es\n"
	printf "translate.google.com.en-it\n"
	printf "translate.google.com.en-ja\n"
	printf "translate.google.com.en-ko\n"
	printf "translate.google.com.en-pt\n"
	printf "translate.google.com.en-ru\n"
	printf "translate.google.com.en-zh\n"
	printf "translate.google.com.en-zt\n"
	printf "translate.google.com.es-en\n"
	printf "translate.google.com.fr-de\n"
	printf "translate.google.com.fr-en\n"
	printf "translate.google.com.it-en\n"
	printf "translate.google.com.ja-en\n"
	printf "translate.google.com.ko-en\n"
	printf "translate.google.com.pt-en\n"
	printf "translate.google.com.pt-en\n"
	printf "translate.google.com.ru-en\n"
	printf "translate.google.com.zh-en\n"
	printf "translate.google.com.zh-zt\n"
	printf "translate.google.com.zt-zh\n"
}

function tw_ls_dictionaries
{
	for f in ${TW_DATADIR}/*.twd
	do
		printf "$(basename $f .twd)\n"
	done
	tw_ls_dictionaries_google_language_tools
	tw_ls_dictionaries_freetranslation
 	exit 0
}

function tw_usage
{
	printf "Usage: $TW [OPTION] dictionary term\n"
	printf "$TW_DESCRIPTION\n"
	printf "\n"
	printf "Mandatory arguments for long options are mandatory for short options too.\n"
	printf "  -l, --list\t\t\tlist available dictionaries\n"
	printf "  -h, --help\t\t\tshows a help message\n"
	printf "  -v, --version\t\t\tshows the program version\n"
	printf "\n"
	printf "Report bugs to <$TW_BUGREPORT>.\n"
	exit 0
}

function tw_version
{
	printf "[@]pkgversion[@]\n"
	exit 0
}

TEMP=$(getopt -o "lhv" \
	-l "list,help,version" -n "$TW" -- "$@")
eval set -- "$TEMP"
while [[ ! -z "$1" ]]
do
	case "$1" in
		"-l" | "--list") tw_ls_dictionaries; shift;;
		"-h" | "--help") tw_usage; shift;;
		"-v" | "--version") tw_version; shift;;
		--) shift; break;;
		*) printf "Internal error!\n"; exit 1;;
	esac
done

case "${1%.*}" in
	www.freetranslation.com) tw_freetranslation "$1" "$2";;
	translate.google.com) tw_google_language_tools "$1" "$2";;
	*) tw_twd "${TW_DATADIR}/${1}.twd" "$2";;
esac
