// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "MainWindow.h"
#include "Settings.h"
#include <KApplication>
#include <KAction>
#include <KLocale>
#include <KActionCollection>
#include <KStandardAction>
#include <KVBox>
#include <KHBox>
#include <QGroupBox>
#include <QProcess>
#include <QLabel>

MainWindow::MainWindow(QWidget *parent): KXmlGuiWindow(parent)
{
	KVBox *centralWidget = new KVBox();

	term = new KTextEdit(centralWidget);
	KHBox *dictionariesWidget = new KHBox(centralWidget);
	new QLabel(i18n("Filter:"), dictionariesWidget);
	filter = new KLineEdit(dictionariesWidget);
	dictionaries.filtered = new KComboBox(dictionariesWidget);
	translate = new KPushButton(KIcon("arrow-down"), i18n("Translate"), centralWidget);
	translation = new KTextEdit(centralWidget);


	setCentralWidget(centralWidget);

	QProcess tw;
	tw.start("tw", QStringList("--list"));
	tw.waitForFinished();
	dictionaries.list = new QStringList(QString::fromUtf8(tw.readAllStandardOutput()).split('\n', QString::SkipEmptyParts));
	dictionaries.filtered->insertItems(0, *dictionaries.list);
	dictionaries.filtered->setCurrentItem(Settings::dictionary());

	connect(translate, SIGNAL(clicked(bool)), this, SLOT(slotTranslate()));
	connect(filter, SIGNAL(returnPressed()), this, SLOT(slotFilter()));

	setupActions();
	setupGUI(QSize(420, 280));
}

MainWindow::~MainWindow()
{
	delete dictionaries.filtered;
	delete dictionaries.list;
}

void
MainWindow::setupActions()
{
	KStandardAction::quit(kapp, SLOT(quit()), actionCollection());
}

void
MainWindow::slotTranslate()
{
	QProcess tw;
	QString dictionary = dictionaries.filtered->currentText();
	QStringList arguments;
	arguments << dictionary << term->toPlainText();
	tw.start("tw", arguments);
	tw.waitForFinished();
	translation->setText(QString::fromUtf8(tw.readAllStandardOutput()));
	Settings::setDictionary(dictionary);
	Settings::self()->writeConfig();
}

void
MainWindow::slotFilter()
{
	dictionaries.filtered->clear();
	dictionaries.filtered->insertItems(0, dictionaries.list->filter(filter->text()));
}
