/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gtk-tw.h"

#include "gtk-tw-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 22 "gtk-tw.gob"

	#include <config.h>
	#include <glib/gi18n.h>
	enum {
		COL_DICT, COL_TOTAL
	};
	const gchar *ui_info =
	"<ui>"
	"  <toolbar name='ToolBar'>"
	"    <toolitem action='View dictionaries'/>"
	"    <separator/>"
	"    <toolitem action='About'/>"
	"  </toolbar>"
	"</ui>";


#line 43 "gtk-tw.c"
/* self casting macros */
#define SELF(x) GTK_TW(x)
#define SELF_CONST(x) GTK_TW_CONST(x)
#define IS_SELF(x) GTK_IS_TW(x)
#define TYPE_SELF GTK_TYPE_TW
#define SELF_CLASS(x) GTK_TW_CLASS(x)

#define SELF_GET_CLASS(x) GTK_TW_GET_CLASS(x)

/* self typedefs */
typedef GtkTW Self;
typedef GtkTWClass SelfClass;

/* here are local prototypes */
static void gtk_tw_init (GtkTW * o) G_GNUC_UNUSED;
static void gtk_tw_class_init (GtkTWClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkWindowClass *parent_class = NULL;

/* Short form macros */
#define self_new gtk_tw_new
#define self_gconf_init gtk_tw_gconf_init
#define self_update_title gtk_tw_update_title
#define self_exit gtk_tw_exit
#define self_search gtk_tw_search
#define self_get_dict_selection gtk_tw_get_dict_selection
#define self_dict_selection_changed gtk_tw_dict_selection_changed
#define self_dict_list gtk_tw_dict_list
#define self_filter_func gtk_tw_filter_func
#define self_populate_model gtk_tw_populate_model
#define self_create_view_and_model gtk_tw_create_view_and_model
#define self_get_dictionaries gtk_tw_get_dictionaries
#define self_toggle_view_dictionaries gtk_tw_toggle_view_dictionaries
#define self_gconf_dict_changed_callback gtk_tw_gconf_dict_changed_callback
#define self_gconf_viewdicts_changed_callback gtk_tw_gconf_viewdicts_changed_callback
#define self_on_about gtk_tw_on_about
GType
gtk_tw_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GtkTWClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gtk_tw_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GtkTW),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gtk_tw_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_WINDOW, "GtkTW", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GtkTW *)g_object_new(gtk_tw_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GtkTW * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GtkTW *
GET_NEW_VARG (const char *first, ...)
{
	GtkTW *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GtkTW *)g_object_new_valist (gtk_tw_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
gtk_tw_init (GtkTW * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gtk:TW::init"
}
#undef __GOB_FUNCTION__
static void 
gtk_tw_class_init (GtkTWClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gtk:TW::class_init"

	parent_class = g_type_class_ref (GTK_TYPE_WINDOW);

}
#undef __GOB_FUNCTION__



#line 54 "gtk-tw.gob"
GtkWidget * 
gtk_tw_new (gchar * dictionary, gchar * text)
#line 144 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::new"
{
#line 56 "gtk-tw.gob"
	
		const GtkToggleActionEntry toggle_entries[] = {
			{"View dictionaries", GTK_STOCK_FIND, _("View _dictionaries"), _("<control>d"), _("Toggle view dictionaries"), G_CALLBACK(self_toggle_view_dictionaries)}
		};
		guint n_toggle_entries = G_N_ELEMENTS(toggle_entries);
		const GtkActionEntry entries[] = {
			{"About", GTK_STOCK_ABOUT, _("_About..."), _("<control>a"), _("About "PACKAGE), G_CALLBACK(self_on_about)}
		};
		guint n_entries = G_N_ELEMENTS(entries);
		Self *self = GET_NEW;
		self->title = g_strdup(_(PACKAGE));
		gtk_window_set_title(GTK_WINDOW(self), self->title);
		gtk_window_set_default_size(GTK_WINDOW(self), 440, 180);
		gtk_window_set_default_icon_from_file(ICONSDIR"/"PACKAGE".svg", NULL);
		g_signal_connect(G_OBJECT(self), "destroy", G_CALLBACK(self_exit), self);
		GtkWidget *toolbar;
		GtkActionGroup *actions;
		GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
		actions = gtk_action_group_new("Actions");
		gtk_action_group_add_toggle_actions(actions, toggle_entries, n_toggle_entries, self);
		gtk_action_group_add_actions(actions, entries, n_entries, self);
		self->uimanager = gtk_ui_manager_new();
		gtk_ui_manager_insert_action_group(self->uimanager, actions, 0);
		gtk_window_add_accel_group(GTK_WINDOW(self), gtk_ui_manager_get_accel_group(self->uimanager));
		gtk_ui_manager_add_ui_from_string(self->uimanager, ui_info, -1, NULL);
		toolbar =  gtk_ui_manager_get_widget(self->uimanager, "/ToolBar");
		gtk_toolbar_insert(GTK_TOOLBAR(toolbar), gtk_separator_tool_item_new(), -1);
		GtkWidget *hbox = gtk_hbox_new(FALSE, 5);
		GtkWidget *label = gtk_label_new(_("Look up:"));
		self->entry = gtk_entry_new();
		g_signal_connect(G_OBJECT(self->entry), "activate", G_CALLBACK(self_search), self);
		GtkToolItem *toolitem = gtk_tool_item_new();
		gtk_tool_item_set_expand(toolitem, TRUE);
		gtk_tool_item_set_homogeneous(toolitem, TRUE);
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(hbox), self->entry, TRUE, TRUE, 5);
		gtk_container_add(GTK_CONTAINER(toolitem), hbox);
		gtk_toolbar_insert(GTK_TOOLBAR(toolbar), toolitem, -1);
		gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 5);
		GtkWidget *hpaned = gtk_hpaned_new();
		self->dictvbox = gtk_vbox_new(FALSE, 5);
		self->dictentry = gtk_entry_new();
		g_signal_connect(G_OBJECT(self->dictentry), "activate", G_CALLBACK(self_dict_list), self);
		label = gtk_label_new(_("Search:"));
		hbox = gtk_hbox_new(FALSE, 5);
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(hbox), self->dictentry, FALSE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(self->dictvbox), hbox, FALSE, FALSE, 5);
		self_create_view_and_model(self);
		GtkWidget *sw = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_container_add(GTK_CONTAINER(sw), self->view);
		gtk_box_pack_start(GTK_BOX(self->dictvbox), sw, TRUE, TRUE, 5);
		gtk_paned_pack1(GTK_PANED(hpaned), self->dictvbox, TRUE, TRUE);
		self->label = gtk_label_new(NULL);
		gtk_label_set_selectable(GTK_LABEL(self->label), TRUE);
		sw = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw), self->label);
		gtk_paned_pack2(GTK_PANED(hpaned), sw, TRUE, TRUE);
		gtk_paned_set_position(GTK_PANED(hpaned), 250);
		gtk_box_pack_start(GTK_BOX(vbox), hpaned, TRUE, TRUE, 5);
		gtk_container_add(GTK_CONTAINER(self), vbox);
		self->dictbutton = gtk_ui_manager_get_widget(self->uimanager, "/ToolBar/View dictionaries");
		gtk_widget_show_all(GTK_WIDGET(vbox));
		self_gconf_init(self);
		self_update_title(self);
		GtkTreeSelection *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self->view));
		g_signal_connect(G_OBJECT(selection), "changed", G_CALLBACK(self_dict_selection_changed), self);
		gtk_window_set_focus(GTK_WINDOW(self), self->entry);
		gtk_widget_show(GTK_WIDGET(self));
		if(dictionary)
		{
			if(self->dict) g_free(self->dict);
			self->dict = g_strdup(dictionary);
			self_update_title(self);
		}
		if(text)
		{
			gtk_entry_set_text(GTK_ENTRY(self->entry), text);
			g_signal_emit_by_name(self->entry, "activate");
		}
		return GTK_WIDGET(self);
	}}
#line 233 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 141 "gtk-tw.gob"
void 
gtk_tw_gconf_init (GtkTW * self)
#line 239 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::gconf_init"
#line 141 "gtk-tw.gob"
	g_return_if_fail (self != NULL);
#line 141 "gtk-tw.gob"
	g_return_if_fail (GTK_IS_TW (self));
#line 246 "gtk-tw.c"
{
#line 143 "gtk-tw.gob"
	
		self->conf = gconf_client_get_default();
		gchar *dir = g_strdup_printf("/%s", PACKAGE);
		gchar *dict = g_strdup_printf("/%s/dict", PACKAGE);
		self->dict = gconf_client_get_string(self->conf, dict, NULL);
		gconf_client_add_dir(self->conf, dir, GCONF_CLIENT_PRELOAD_NONE, NULL);
		gconf_client_notify_add(self->conf, dict, self_gconf_dict_changed_callback, self, NULL, NULL);
		g_free(dict); g_free(dir);

		gchar *viewdicts = g_strdup_printf("/%s/viewdicts", PACKAGE);
		gconf_client_notify_add(self->conf, viewdicts, self_gconf_viewdicts_changed_callback, self, NULL, NULL);
		gboolean vd = gconf_client_get_bool(self->conf, viewdicts, NULL);
		gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(self->dictbutton), TRUE);
		if(!vd)	gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(self->dictbutton), vd);
		g_free(viewdicts);
	}}
#line 265 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 160 "gtk-tw.gob"
void 
gtk_tw_update_title (GtkTW * self)
#line 271 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::update_title"
#line 160 "gtk-tw.gob"
	g_return_if_fail (self != NULL);
#line 160 "gtk-tw.gob"
	g_return_if_fail (GTK_IS_TW (self));
#line 278 "gtk-tw.c"
{
#line 162 "gtk-tw.gob"
	
		gchar *title;
		if(self->dict) title = g_strdup_printf("%s - %s", self->dict, self->title);
		else title = g_strdup(self->title);
		gtk_window_set_title(GTK_WINDOW(self), title);
		g_free(title);
	}}
#line 288 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 170 "gtk-tw.gob"
void 
gtk_tw_exit (GtkTW * self)
#line 294 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::exit"
#line 170 "gtk-tw.gob"
	g_return_if_fail (self != NULL);
#line 170 "gtk-tw.gob"
	g_return_if_fail (GTK_IS_TW (self));
#line 301 "gtk-tw.c"
{
#line 172 "gtk-tw.gob"
	
		if(self->dict)
		{
			gchar *dict = g_strdup_printf("/%s/dict", PACKAGE);
			gconf_client_set_string(self->conf, dict, self->dict, NULL);
			g_free(dict);
		}
		gchar *viewdicts = g_strdup_printf("/%s/viewdicts", PACKAGE);
		gboolean vd = gtk_toggle_tool_button_get_active(GTK_TOGGLE_TOOL_BUTTON(self->dictbutton));
		gconf_client_set_bool(self->conf, viewdicts, vd, NULL);
		g_free(viewdicts);
		if(self->title) g_free(self->title);
		gtk_main_quit();
	}}
#line 318 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 187 "gtk-tw.gob"
void 
gtk_tw_search (GtkEntry * entry, gpointer data)
#line 324 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::search"
{
#line 189 "gtk-tw.gob"
	
		Self *self = SELF(data);
		if(self->dict)
		{
			const gchar *term = gtk_entry_get_text(entry);
			gchar *standard_output, *command = g_strdup_printf("tw %s -- \"%s\"", self->dict, term);
			g_spawn_command_line_sync(command, &standard_output, NULL, NULL, NULL);
			g_free(command);
			gtk_label_set_text(GTK_LABEL(self->label), standard_output);
		}
		else
			gtk_label_set_text(GTK_LABEL(self->label), _("Please, select a dictionary."));
	}}
#line 342 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 203 "gtk-tw.gob"
gchar * 
gtk_tw_get_dict_selection (GtkTW * self)
#line 348 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::get_dict_selection"
#line 203 "gtk-tw.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 203 "gtk-tw.gob"
	g_return_val_if_fail (GTK_IS_TW (self), (gchar * )0);
#line 355 "gtk-tw.c"
{
#line 205 "gtk-tw.gob"
	
		GtkTreeSelection *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self->view));
		GtkTreeIter iter;
		gchar *dict = NULL;
		if(gtk_tree_selection_get_selected(selection, NULL, &iter))
			gtk_tree_model_get(self->filter, &iter, COL_DICT, &dict, -1);
		return dict;
	}}
#line 366 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 214 "gtk-tw.gob"
void 
gtk_tw_dict_selection_changed (GtkTreeSelection * treeselection, gpointer data)
#line 372 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::dict_selection_changed"
{
#line 216 "gtk-tw.gob"
	
		Self *self = SELF(data);
		gchar *dict = self_get_dict_selection(self);
		if(dict)
		{
			if(self->dict) g_free(self->dict);
			self->dict = g_strdup(dict);
			g_free(dict);
		}
		self_update_title(self);
	}}
#line 388 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 228 "gtk-tw.gob"
void 
gtk_tw_dict_list (GtkEntry * entry, gpointer data)
#line 394 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::dict_list"
{
#line 230 "gtk-tw.gob"
	
		Self *self = SELF(data);
		gtk_tree_model_filter_refilter(GTK_TREE_MODEL_FILTER(self->filter));
	}}
#line 403 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 235 "gtk-tw.gob"
gboolean 
gtk_tw_filter_func (GtkTreeModel * model, GtkTreeIter * iter, gpointer data)
#line 409 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::filter_func"
{
#line 237 "gtk-tw.gob"
	
		Self *self = data;
		gchar *dict;
		const gchar *filter = gtk_entry_get_text(GTK_ENTRY(self->dictentry));
		gtk_tree_model_get(model, iter, COL_DICT, &dict, -1);
		return (strcmp(filter, "") == 0) || (strstr(dict, filter) != NULL);
	}}
#line 421 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 245 "gtk-tw.gob"
void 
gtk_tw_populate_model (GtkTW * self)
#line 427 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::populate_model"
#line 245 "gtk-tw.gob"
	g_return_if_fail (self != NULL);
#line 245 "gtk-tw.gob"
	g_return_if_fail (GTK_IS_TW (self));
#line 434 "gtk-tw.c"
{
#line 247 "gtk-tw.gob"
	
		guint i;
		GtkTreeIter iter;
		GSList *dicts = self_get_dictionaries();
		for(i = 0; i < g_slist_length(dicts); i++)
			gtk_list_store_insert_with_values(self->list, &iter, i, COL_DICT, g_slist_nth_data(dicts, i), -1);
		g_slist_free(dicts);
	}}
#line 445 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 256 "gtk-tw.gob"
void 
gtk_tw_create_view_and_model (GtkTW * self)
#line 451 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::create_view_and_model"
#line 256 "gtk-tw.gob"
	g_return_if_fail (self != NULL);
#line 256 "gtk-tw.gob"
	g_return_if_fail (GTK_IS_TW (self));
#line 458 "gtk-tw.c"
{
#line 258 "gtk-tw.gob"
	
		GtkTreeViewColumn *col;
		GtkCellRenderer *renderer;
		self->list = gtk_list_store_new(COL_TOTAL, G_TYPE_STRING);
		self->filter = gtk_tree_model_filter_new(GTK_TREE_MODEL(self->list), NULL);
		gtk_tree_model_filter_set_visible_func(GTK_TREE_MODEL_FILTER(self->filter), self_filter_func, self, NULL);
		self_populate_model(self);
		self->view = gtk_tree_view_new_with_model(self->filter);
		renderer = gtk_cell_renderer_text_new();
		col = gtk_tree_view_column_new_with_attributes(_("Dictionaries"), renderer, "text", COL_DICT, NULL);
		gtk_tree_view_append_column(GTK_TREE_VIEW(self->view), col);
	}}
#line 473 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 271 "gtk-tw.gob"
GSList * 
gtk_tw_get_dictionaries (void)
#line 479 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::get_dictionaries"
{
#line 273 "gtk-tw.gob"
	
		GSList *dicts = NULL;
		gchar *standard_output;
		g_spawn_command_line_sync("bash -c 'LANG=C tw -l'", &standard_output, NULL, NULL, NULL);
		guint i;
		for(i = 0; i < strlen(standard_output); i++)
		{
			GString *str = g_string_new(NULL);
			guint j;
			for(j = 0; standard_output[i+j] != '\n'; j++)
			{
				g_string_append_c(str, standard_output[i+j]);
			}
			dicts = g_slist_append(dicts, g_strdup(str->str));
			g_string_free(str, TRUE);
			i += j;
		}
		return dicts;
	}}
#line 503 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 293 "gtk-tw.gob"
void 
gtk_tw_toggle_view_dictionaries (GtkToggleAction * action, gpointer data)
#line 509 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::toggle_view_dictionaries"
{
#line 295 "gtk-tw.gob"
	
		Self *self = SELF(data);
		if(gtk_toggle_action_get_active(action))
		{
			gtk_window_resize(GTK_WINDOW(self), 640, 340);
			gtk_widget_show(self->dictvbox);
		}
		else
		{
			gtk_window_resize(GTK_WINDOW(self), 440, 180);
			gtk_widget_hide(self->dictvbox);
		}
	}}
#line 527 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 309 "gtk-tw.gob"
void 
gtk_tw_gconf_dict_changed_callback (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data)
#line 533 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::gconf_dict_changed_callback"
{
#line 311 "gtk-tw.gob"
	
		Self *self = SELF(user_data);
		GConfValue *value = gconf_entry_get_value(entry);
		if (value != NULL && value->type == GCONF_VALUE_STRING)
			self->dict = g_strdup(gconf_value_get_string(value));
		self_update_title(self);
	}}
#line 545 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 319 "gtk-tw.gob"
void 
gtk_tw_gconf_viewdicts_changed_callback (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data)
#line 551 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::gconf_viewdicts_changed_callback"
{
#line 321 "gtk-tw.gob"
	
		Self *self = SELF(user_data);
		GConfValue *value = gconf_entry_get_value(entry);
		if (value != NULL && value->type == GCONF_VALUE_BOOL)
		{
			gboolean vd = gconf_value_get_bool(value);
			gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(self->dictbutton), TRUE);
			gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(self->dictbutton), vd);
		}
	}}
#line 566 "gtk-tw.c"
#undef __GOB_FUNCTION__

#line 332 "gtk-tw.gob"
void 
gtk_tw_on_about (GtkEntry * entry, gpointer data)
#line 572 "gtk-tw.c"
{
#define __GOB_FUNCTION__ "Gtk:TW::on_about"
{
#line 334 "gtk-tw.gob"
	
		Self *self = SELF(data);
		const gchar *authors[] = {"Juan Manuel Borges Caño <juanmabc3@gmail.com>", NULL};
		const gchar *artists[] = {_("The unofficial tango package"), NULL};
		const gchar *copyright = "Copyright © Juan Manuel Borges Caño";
		const gchar *license = 
			_(" This program is free software; you can redistribute it and/or modify\n"
			"it under the terms of the GNU General Public License as published by\n"
			"the Free Software Foundation; either version 2 of the License, or\n"
			"(at your option) any later version.\n"
			"\n"
			" This program is distributed in the hope that it will be useful,\n"
			"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
			"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
			"GNU General Public License for more details.\n"
			"\n"
			" You should have received a copy of the GNU General Public License\n"
			"along with this program; if not, write to the Free Software\n"
			"Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA");
		const gchar *comments = _("Graphical Translate Word.");
		const gchar *version = VERSION;
		const gchar *website = "http://savannah.nongnu.org/projects/twandgtw";
		gtk_show_about_dialog(GTK_WINDOW(self), "authors", authors, "artists", artists, "copyright", copyright, "license", license, "comments", comments, "version", version, "website", website, NULL);

	}}
#line 602 "gtk-tw.c"
#undef __GOB_FUNCTION__
