/* manage_input.c -- input management functions
 *
 * Copyright © 2021 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

//#include <gio/gio.h>
//#include <vte/vte.h>
#include <gtk/gtk.h>
//#include <string.h>
//#include "../config.h"
//#include <glib/gi18n-lib.h>
//#include <glib/gprintf.h>

#include "../include/manage_input.h"
//#include "../include/tutoterm.h"
//#include "../include/tutoterm_window.h"
//#include "../include/index_win.h"
//#include "../include/input_output.h"
//#include "../include/liststore.h"

static void
newchar ()
{
  
}

static void
newline ()
{
}

static void
newword ()
{
}

static void
erase ()
{
}

/**
 * manage_input:
 * @ttMainWindow: a @GtkWidget
 * @event: a @GtkEventKey
 * @ttListStore: a @GtkListStore
 *
 * return: a @gboolean
 */
gboolean
manage_input (GtkWidget* widget,
	      GdkEventKey* event,
	      gpointer *user_data)
{
  (void) widget;
  (void) user_data;
  
  /// If the key is ascii (letters, digits, [-+/*"',.%=@|])
  gchar *keyname = gdk_keyval_name (event->keyval);
  if (event->keyval >= 0x021 && event->keyval <= 0x07e)
    {
      newchar (keyname);
      g_debug ("Common terminal key pressed (%s)", keyname);
    }
  else if (event->is_modifier)
    {
      g_debug ("Modifier key pressed (sorry, it's not yet managed!)");
    }
  else
    {
      /// If the key is non-ascii (navigation keys for example)      
    }
}
