/* input_output.c -- text tutorial functions for TutoTerm
 *
 * Copyright © 2017,2019 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#define UNUSED(x) (void)(x)

#include <gtk/gtk.h>
#include <string.h>

#include "../config.h"
#include <glib/gi18n-lib.h>
#include "../include/input_output.h"

/**
 * SECTION: input_output
 * @short_description: Text tutorial functions
 * @title: input_output
 * @section_id: input_output
 * @include: gtk/gtk.h,string.h
 */

/**
 * fill_tttext_with_input_description:
 * @ttListStore: a @GtkListStore
 */
void
fill_tttext_with_input_description (GtkListStore* ttListStore)
{
  g_debug ("Couocu");
  gtk_tree_model_foreach (GTK_TREE_MODEL (ttListStore),
			  set_description, NULL);
}

/**
 * fill_tttext_with_context_comment:
 * @ttListStore: a @GtkListStore
 */
void
fill_tttext_with_context_comment (GtkListStore* ttListStore)
{
  gtk_tree_model_foreach (GTK_TREE_MODEL (ttListStore),
			  set_comment, NULL);
}

/* TODO: write a description
 *
 */
gboolean
set_comment (GtkTreeModel* ttListStore, GtkTreePath* path,
	     GtkTreeIter* iter, gpointer user_data)
{
  gchar *command, *postComment;
  UNUSED (path);
  UNUSED (user_data);

  gtk_tree_model_get (ttListStore, iter, 0, &command,
		      3, &postComment, -1);
  
  if ((strncmp (ttPrevInput, command, strlen (command)) == 0))
    {
      strcpy (ttText, postComment);
      g_free (command);
      return TRUE;
    }
  strcpy (ttText, _("Type a command to get its description."));
  g_free (command);
  g_free (postComment);
  return FALSE;
}

/* TODO: write a description
 *
 */
gboolean
set_description (GtkTreeModel *ttListStore, GtkTreePath *path,
		 GtkTreeIter *iter, gpointer user_data)
{
  gchar *command, *description, *example;
  UNUSED (path);
  UNUSED (user_data);
  gtk_tree_model_get (ttListStore, iter, 0, &command, 1, &description,
		      2, &example, -1);

  if ((strncmp (ttInput, command, strlen (command)) == 0))
    {
      strcpy (ttText, g_markup_printf_escaped
	      (_("<span color=\"red\">Command: <span weight=\"bold\">%s</span></span> : %s"), command, description));
      
      if (strlen (example))
	strcpy (ttTextExample, g_markup_printf_escaped ("%s", example));
      
      g_free (command);
      g_free (description);
      g_free (example);
      return TRUE;
    }
  strcpy (ttText, "");
  strcpy (ttTextExample, "");
  g_free (command);
  g_free (description);
  g_free (example);
  return FALSE;
}

/* TODO: write a description
 *
 */
void
update_input (gchar* keyval)
{
  size_t length = strlen (ttInput);
  /* TODO:
   * Bon, déjà, cette fonction ne devrait pas s'appeler update_input.
   * Ensuite, rien ne sert de relancer un scan complet de la liste
   * des commandes à chaque nouvel appui sur la touche du clavier !
   * Mettre à jour une chaine de caractère (ttInput) n'est pas la
   * bonne méthode. Il faut que cette fonction réfléchisse :
   *  1. Est-on en train d'écrire une commande ?
   *  2.  "   "  "   "        "   une option ?
   *  3.  "   "  "   "        "   un argument ?
   *  4. Est-on en train de faire une faute (ou en tout cas d'écrire
   * une commande non prise en charge) ?
   *  5. Est-on en train d'effacer ce qu'on a écrit ?
   *  6. A-t-on fini d'écrire ?
   * etc.
   */
  if (strcmp (keyval, "BackSpace") == 0)
    {
      if (length >= 1)
	ttInput[length-1] = '\0';
    } else if (strcmp (keyval, "Return") == 0)
    {
      strcpy (ttPrevInput, ttInput);
      strcpy (ttInput, "");
      strcpy (ttText, "");
    } else if (strcmp (keyval, "space") == 0)
    {
      ttInput[length] = ' ';
      ttInput[length+1] = '\0';
    } else if (strlen (keyval) == 1)
    {
      strcat (ttInput, keyval);
    }
}
