/* input_output.h -- text tutorial functions for TutoTerm
 *
 * Copyright © 2017,2019 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __INPUT_OUTPUT_H
#define __INPUT_OUTPUT_H

#include <gtk/gtk.h>

void      fill_tttext_with_input_description  (GtkListStore* ttListStore);
void      fill_tttext_with_context_comment    (GtkListStore* ttListStore);
gboolean  set_description                     (GtkTreeModel *ttListStore,
					       GtkTreePath *path,
					       GtkTreeIter  *iter,
					       gpointer user_data);
gboolean  set_comment                         (GtkTreeModel* ttListStore,
					       GtkTreePath* path,
					       GtkTreeIter* iter,
					       gpointer user_data);
void      update_input                        (gchar* keyval);

gchar ttCommand[256], ttOptions[256], ttArgument[256];
gchar ttInput[512], ttPrevInput[512], ttText[1024], ttTextExample[512];

#endif /* __INPUT_OUTPUT_H */
