/* index_win.c -- index creating & handling functions for TutoTerm
 *
 * Copyright © 2017,2019 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

#include <libintl.h>
#include "../config.h"
#define _(String) gettext (String)
#include "../include/index_win.h"

/* get_tttree:
 * @ttListStore: a #GtkTreeModel
 *
 * Parse information from a GtkTreeModel
 *
 * Returns: a @GtkWidget (aka. @GtkTreeView) displaying information.
 */
GtkWidget*
get_tttree (GtkTreeModel* ttListStore)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GtkWidget *ttTree;
  ttTree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (ttListStore));
  renderer = gtk_cell_renderer_text_new ();

  column =
    gtk_tree_view_column_new_with_attributes (_("Command"), renderer,
					      "text", 0, NULL);
  gtk_tree_view_column_set_sort_column_id (column, 1);
  gtk_tree_view_append_column (GTK_TREE_VIEW (ttTree), column);
  column =
    gtk_tree_view_column_new_with_attributes (_("Description"), renderer,
					      "text", 1, NULL);
  gtk_tree_view_column_set_sort_column_id (column, 1);
  gtk_tree_view_append_column (GTK_TREE_VIEW (ttTree), column);

  return ttTree;
}

/* TODO: write a description
 *
 */
void
index_window (GtkWidget* button, GtkListStore* ttListStore)
{
  GtkWidget *ttIndexBox, *ttIndexWindow, *ttScrollbar, *ttTree;
  
  ttIndexWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_transient_for (GTK_WINDOW (ttIndexWindow),
				GTK_WINDOW (gtk_widget_get_toplevel (button)));
  gtk_window_set_title (GTK_WINDOW (ttIndexWindow), _("Command index"));
  gtk_window_set_default_size (GTK_WINDOW (ttIndexWindow), 500, 300);

  ttIndexBox = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 1);
  ttScrollbar = gtk_scrolled_window_new (NULL, NULL);

  ttTree = get_tttree (GTK_TREE_MODEL (ttListStore));
  
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ttScrollbar),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (ttScrollbar), ttTree);
  gtk_box_pack_start (GTK_BOX(ttIndexBox), ttScrollbar, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (ttIndexWindow), ttIndexBox);
  gtk_widget_show_all (ttIndexWindow);
}
