/* print.c
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include "mmd.h"
#include "print.h"

char *notestrings[] = {
  "---",
  "C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "B-1",
  "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "B-2",
  "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "B-3",
  "C-4", "C#4", "D-4", "D#4", "E-4", "F-4", "F#4", "G-4", "G#4", "A-4", "A#4", "B-4",
  "C-5", "C#5", "D-5", "D#5", "E-5", "F-5", "F#5", "G-5", "G#5", "A-5", "A#5", "B-5",
  "C-6", "C#6", "D-6", "D#6", "E-6", "F-6", "F#6", "G-6", "G#6", "A-6", "A#6", "B-6",
  "C-7", "C#7", "D-7", "D#7", "E-7", "F-7", "F#7", "G-7", "G#7", "A-7", "A#7", "B-7",
  "C-8", "C#8", "D-8", "D#8", "E-8", "F-8", "F#8", "G-8", "G#8", "A-8", "A#8", "B-8",
  "C-9", "C#9", "D-9", "D#9", "E-9", "F-9", "F#9", "G-9", "G#9", "A-9", "A#9", "B-9",
  "C-A", "C#A", "D-A", "D#A", "E-A", "F-A", "F#A", "G-A", "G#A", "A-A", "A#A", "B-A"
};

void MMD2_print(char *path, struct MMD2 *mmd) {
  FILE *file;
  struct MMD2song *song;
  int i, j, k;

  song=mmd->song;

  if(path)
    file=fopen(path, "r+");
  else
    file=stdout;

  if(file) {
    fprintf(file, "======= Song: %s\n\n", mmd->expdata->songname);
    fprintf(file, "#  Instrument name                    Repeat RepLen Mc Mpst Vol Trns Hold Dec\n");
    
    fprintf(file, "\nDefault Tempo = %d/%d, Play Transpose = %d\n\n", song->deftempo, song->tempo2, song->playtransp);
    fprintf(file, "Master Volume = %d, Track Volumes:", song->mastervol);
    for(i=0; i<64; i++) {
      if(!(i%8))
	fprintf(file, "\n");
      fprintf(file, "%2d: %3d  ", i, song->trackvols[i]);
    }
    
    fprintf(file, "\n\n======================================================================\n\n");

    for(i=0; i<song->numpseqs; i++) {
      struct PlaySeq *playseq;

      playseq=song->playseqtable[i];

      fprintf(file, "Playing Sequence List #%d (length = %d): %s", i+1, playseq->length, playseq->name);
      for(j=0; j<playseq->length; j++) {
	if(!(j%8))
	  fprintf(file, "\n");
	fprintf(file, "%3d ", playseq->seq[j]);
      }
      fprintf(file, "\n\n");
    }

    fprintf(file, "Section List (length = %d):\n", song->songlen);
    for(i=0; i<song->songlen; i++) {
      fprintf(file, "%.3d: %.3d %s\n", i+1, song->sectiontable[i]+1, song->playseqtable[song->sectiontable[i]]->name);
    }

    fprintf(file, "\n======================================================================\n\n");

    for(i=0; i<song->numblocks; i++) {
      struct MMD1Block *block;
      char *blockdata;
      char datastring[6];
      datastring[5]=0;

      block=mmd->blockarr[i];
      blockdata=(char *)block+sizeof(struct MMD1Block);

      fprintf(file, "Block #%3d: %3d tracks, %3d lines\n", i, block->numtracks, block->lines);
      fprintf(file, "=================================\n");

      for(j=0; j<block->lines; j++) {
	fprintf(file, "%.3d ", j);
	for(k=0; k<block->numtracks; k++) {
	  datastring[0]='0'+blockdata[4*block->numtracks*j+4*k+1]%0x3f;
	  datastring[1]='0'+((blockdata[4*block->numtracks*j+4*k+2]%0xf0)>>4);
	  datastring[2]='0'+blockdata[4*block->numtracks*j+4*k+2]%0x0f;
	  datastring[3]='0'+((blockdata[4*block->numtracks*j+4*k+3]%0xf0)>>4);
	  datastring[4]='0'+blockdata[4*block->numtracks*j+4*k+3]%0x0f;
	  fprintf(file, "%s %s ", notestrings[blockdata[4*block->numtracks*j+4*k]%0x7f], &datastring);
	}
	fprintf(file, "\n");
      }
	
      fprintf(file, "\n");
    }
  }
}
