/* main.c
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <glib.h>
#include "editor.h"
#include "callbacks.h"

extern GtkWidget *gui_window_main;

int main(int argc, char *argv[]) {
#ifdef G_THREADS_IMPL_POSIX

  if(!g_thread_supported())
    g_thread_init(NULL);
  gnome_init("Tutka", VERSION, argc, argv);

  if(argc>1)
    editor_open(argv[1]);
  else
    editor_open(NULL);

  gui_open();

  gdk_threads_enter();
  gtk_main();
  gdk_threads_leave();

  editor_close();

  return 0;
#else
  fprintf(stderr, "No POSIX threads implementation. Tutka needs to be compiled against one.\n");

  return -1;
#endif
}
