/* editor.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _EDITOR_H
#define _EDITOR_H

#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>
#include <pthread.h>

#define MODE_IDLE 0
#define MODE_PLAY_SONG 1
#define MODE_PLAY_BLOCK 2
#define DEFAULT_TEMPO 130
#define TRACK_STATUS_MIDI_CHANNEL 0
#define TRACK_STATUS_NOTE 1
#define TRACK_STATUS_VOLUME 2
#define TRACK_STATUS_HOLD 3

/* 128 MIDI controllers plus aftertouch, channel pressure and pitch wheel */
#define VALUES (128+3)
#define VALUES_AFTERTOUCH 128
#define VALUES_CHANNEL_PRESSURE 129
#define VALUES_PITCH_WHEEL 130

struct editor {
  /* MIDI device stream pointer */
  FILE *midi;
  /* The song currently being edited */
  struct song *song;
  /* Current location in song */
  unsigned short section, playseq, playseqpos, block;
  /* Editor modes */
  unsigned char octave, instrument, edit, space, mode;
  /* Status of tracks; notes playing */
  char *trackstatus;
  /* MIDI controller values; one for each controller on each channel */
  unsigned char midicontrollervalues[16*VALUES];
  /* For measuring how long the song has been playing */
  struct timeval playingstarted, playedsofar;
  /* The initialization status of the player thread */
  int threadstatus;
  /* Player thread pointer */
  pthread_t thread;
};

/* Initializes the editor and either opens an existing song or creates new */
void editor_open(char *);
/* Deinitializes the editor */
void editor_close();

#endif
