/* midi.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _MIDI_H
#define _MIDI_H

/* Stops a note playing on a MIDI channel using requested velocity */
void midi_note_off(unsigned char, unsigned char, unsigned char);
/* Plays a note on a MIDI channel using requested velocity */
void midi_note_on(unsigned char, unsigned char, unsigned char);
/* Sets the aftertouch pressure of a note playing on a MIDI channel */
void midi_aftertouch(unsigned char, unsigned char, unsigned char);
/* Sets the MIDI controller value of a MIDI channel */
void midi_controller(unsigned char, unsigned char, unsigned char);
/* Send a program change on a MIDI channel */
void midi_program_change(unsigned char, unsigned char);
/* Sets the channel pressure of a MIDI channel */
void midi_channel_pressure(unsigned char, unsigned char);
/* Sets the pitch wheel value of a MIDI channel */
void midi_pitch_wheel(unsigned char, unsigned short);
/* Sends a MIDI SysEX message */
void midi_system_exclusive(unsigned char *, unsigned short);

#endif
