/* gui.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GUI_H
#define _GUI_H

#include <gtk/gtk.h>

/* Main window functions */
void gui_create();
void gui_main_refresh();
void gui_main_show();
void gui_main_octave_activate(GtkMenuItem *, gpointer);
void gui_main_toggled(GtkToggleButton *, gpointer);
void gui_main_changed(GtkAdjustment *, gpointer);

/* Tracker functions */
static int tracker_keyevent (GtkWidget *, GdkEventKey *, gpointer);

/* Info functions */
void gui_info_refresh();
void gui_timer_refresh(unsigned int);

/* Tempo window functions */
void gui_tempo_refresh();
void gui_tempo_show();
void gui_tempo_hide();
void gui_tempo_changed(GtkAdjustment *, gpointer);
void gui_tpl_changed(GtkAdjustment *, gpointer);

/* Track volumes window functions */
void gui_trackvolumes_refresh();
void gui_trackvolumes_show();
void gui_trackvolumes_hide();
void gui_trackvolumes_changed();
void gui_trackvolumes_toggled(GtkToggleButton *, gpointer);

/* Section list window functions */
void gui_sectionlist_show();
void gui_sectionlist_hide();
void gui_sectionlist_refresh();
void gui_sectionlist_select_row(GtkWidget *, gint, gint, GdkEventButton *, gpointer);
void gui_sectionlist_insert();
void gui_sectionlist_append();
void gui_sectionlist_delete();
void gui_sectionlist_previous();
void gui_sectionlist_next();

/* Playing sequence window functions */
void gui_playseq_show();
void gui_playseq_hide();
void gui_playseq_refresh();
void gui_playseq_select_row(GtkWidget *, gint, gint, GdkEventButton *, gpointer);
void gui_playseq_insert();
void gui_playseq_append();
void gui_playseq_delete();
void gui_playseq_insertnew();
void gui_playseq_appendnew();
void gui_playseq_deletecurrent();
void gui_playseq_previous();
void gui_playseq_next();
void gui_playseq_activate_name(GtkWidget *, GtkWidget *);

/* Block list window functions */
void gui_blocklist_show();
void gui_blocklist_hide();
void gui_blocklist_refresh();
void gui_blocklist_select_row(GtkWidget *, gint, gint, GdkEventButton *, gpointer);
void gui_blocklist_activate_name(GtkWidget *, GtkWidget *);
void gui_blocklist_insert();
void gui_blocklist_append();
void gui_blocklist_delete();
void gui_blocklist_tracks_changed(GtkAdjustment *, gpointer);
void gui_blocklist_length_changed(GtkAdjustment *, gpointer);
void gui_blocklist_effectpages_changed(GtkAdjustment *, gpointer);

/* Instrument properties window functions */
void gui_instrument_show();
void gui_instrument_hide();
void gui_instrument_volume_changed(GtkAdjustment *, gpointer);
void gui_instrument_midichannel_changed(GtkAdjustment *, gpointer);
void gui_instrument_transpose_changed(GtkAdjustment *, gpointer);
void gui_instrument_hold_changed(GtkAdjustment *, gpointer);

#endif
