/* editor.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _EDITOR_H
#define _EDITOR_H

#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

#define MODE_IDLE 0
#define MODE_PLAY_SONG 1
#define MODE_PLAY_BLOCK 2
#define DEFAULT_TEMPO 130

struct editor {
  FILE *midi;
  struct song *song;
  unsigned short section, playseq, playseqpos, block;
  unsigned char octave, instrument, edit, space, mode;
  char *trackstatus;
  struct timeval playingstarted, playedsofar;
};

void editor_open(char *);
void editor_close();

#endif
