/* player.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PLAYER_H
#define _PLAYER_H

#define EFFECT_MIDI_COMMAND_VALUE 0x00
#define EFFECT_PITCH_WHEEL 0x01
#define EFFECT_END_BLOCK 0x02
#define EFFECT_PLAYSEQ_POSITION 0x03
#define EFFECT_STOP 0x04
#define EFFECT_MIDI_COMMAND 0x05
#define EFFECT_NOTE_DELAY 0x0b
#define EFFECT_VELOCITY 0x0c
#define EFFECT_CHANNEL_PRESSURE 0x0d
#define EFFECT_TPL 0x0e
#define EFFECT_TEMPO 0x0f
#define EFFECT_NOT_DEFINED 0x10

void play_song();
void continue_song();
void play_block();
void continue_block();
void stop();

/* SIGALRT signal handler for triggering the playroutine */
void play_handler(int);
void play_playseq_advance();
void play_section_advance();
/* Sets the timer structure according to a given BPM count */
void play_set_timer(unsigned short);
/* Plays a note using given instrument on a given channel */
void play_note(unsigned short, unsigned char, unsigned char, unsigned char);
/* Stops notes playing at the moment */
void stop_notes();
/* Stops all notes */
void stop_all_notes();
void refresh_playseq_and_block();

#endif
