/* midi.c
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "editor.h"

extern struct editor editor;

void midi_note_off(unsigned char channel, unsigned char note,
		   unsigned char velocity) {
  unsigned char data[3];

  if(editor.midi!=NULL) {
    data[0]=0x80|channel;
    data[1]=note&0x7f;
    data[2]=velocity&0x7f;
    
    fwrite(data, 3, 1, editor.midi);
    fflush(editor.midi);
  }
}

void midi_note_on(unsigned char channel, unsigned char note,
		   unsigned char velocity) {
  unsigned char data[3];

  if(editor.midi!=NULL) {
    data[0]=0x90|channel;
    data[1]=note&0x7f;
    data[2]=velocity&0x7f;
    
    fwrite(data, 3, 1, editor.midi);
    fflush(editor.midi);
  }
}

void midi_aftertouch(unsigned char channel, unsigned char note,
		     unsigned char pressure) {
  unsigned char data[3];

  if(editor.midi!=NULL) {
    data[0]=0xa0|channel;
    data[1]=note&0x7f;
    data[2]=pressure&0x7f;
    
    fwrite(data, 3, 1, editor.midi);
    fflush(editor.midi);
  }
}

void midi_controller(unsigned char channel, unsigned char controller,
		     unsigned char value) {
  unsigned char data[3];

  if(editor.midi!=NULL) {
    data[0]=0xb0|channel;
    data[1]=controller&0x7f;
    data[2]=value&0x7f;
    
    fwrite(data, 3, 1, editor.midi);
    fflush(editor.midi);
  }
}

void midi_program_change(unsigned char channel, unsigned char program) {
  unsigned char data[2];

  if(editor.midi!=NULL) {
    data[0]=0xc0|channel;
    data[1]=program&0x7f;
    
    fwrite(data, 2, 1, editor.midi);
    fflush(editor.midi);
  }
}

void midi_channel_pressure(unsigned char channel, unsigned char pressure) {
  unsigned char data[2];

  if(editor.midi!=NULL) {
    data[0]=0xd0|channel;
    data[1]=pressure&0x7f;
    
    fwrite(data, 2, 1, editor.midi);
    fflush(editor.midi);
  }
}

void midi_pitch_wheel(unsigned char channel, unsigned short value) {
  unsigned char data[3];

  if(editor.midi!=NULL) {
    data[0]=0xe0|channel;
    data[1]=value&0x7f;
    data[2]=(value>>7)&0x7f;
    
    fwrite(data, 3, 1, editor.midi);
    fflush(editor.midi);
  }
}

void midi_system_exclusive(unsigned char *message, unsigned short length) {
  unsigned char *data=(unsigned char *)calloc(length+2, sizeof(unsigned char));

  if(editor.midi!=NULL) {
    data[0]=0xf0;
    memcpy(data+1, message, length);
    data[length+1]=0xf7;
    
    fwrite(data, length+2, 1, editor.midi);
    fflush(editor.midi);
  }

  free(data);
}
