/* main.c
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "mmd.h"
#include "song.h"
#include "print.h"
#include "gui.h"
#include "editor.h"
#include "player.h"

struct editor editor;

int main(int argc, char *argv[]) {
  gtk_init(&argc, &argv);

  gui_create();

  if(argc>1)
    editor_open(argv[1]);
  else
    editor_open(NULL);

  gui_main_show();

  gtk_main();

  editor_close();

  return(0);
}

/* Initializes the editor */
void editor_open(char *filename) {
  int i;

  editor_close();

  memset(&editor, 0, sizeof(struct editor));

  editor.midi=fopen("/dev/midi", "r+");
  if(editor.midi==NULL)
    fprintf(stderr, "Could not open /dev/midi. MIDI disabled.\n");

  if(filename!=NULL)
    editor.song=song_load(filename);
  else
    editor.song=song_alloc();

  /* Initialize notes playing array */
  editor.trackstatus=(char *)calloc(4*editor.song->maxtracks, 1);
  for(i=0; i<editor.song->maxtracks; i++) {
    editor.trackstatus[i*4]=-1;
    editor.trackstatus[i*4+1]=-1;
    editor.trackstatus[i*4+2]=-1;
    editor.trackstatus[i*4+3]=-1;
  }
  editor.space=1;

  gui_main_refresh();
  gui_blocklist_refresh();
  gui_playseq_refresh();
  gui_section_refresh();
  gui_instrument_refresh();
}

/* Deinitializes the editor */
void editor_close() {
  if(editor.trackstatus!=NULL) {
    stop();
    stop_notes();

    free(editor.trackstatus);
    editor.trackstatus=NULL;
  }

  if(editor.song!=NULL) {
    song_free(editor.song);
    editor.song=NULL;
  }

  if(editor.midi!=NULL) {
    fclose(editor.midi);
    editor.midi=NULL;
  }
}
