/* smf.h
 *
 * Copyright 2002-2011 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _SMF_H
#define _SMF_H

struct smf_MThd {
  /* This will be 'M','T','h','d' */
  char ID[4];
  /* This will be 6 */
  unsigned long Length;

  /* Here are the 6 bytes */
  unsigned short Format;
  unsigned short NumTracks;
  unsigned short Division;
};

struct smf_MTrk {
  /* This will be 'M','T','r','k' */
  char ID[4];
  /* This will be the actual size of Data[] */
  unsigned long Length;

  /* Here are the data bytes */
  /* Its actual size is Data[Length] */
  unsigned char *Data;
};

struct smf {
  struct smf_MThd *MThd;
  struct smf_MTrk **MTrks;
};

/* SMF alloc, free and parse functions */
void smf_save(struct smf *, char *);
void smf_free(struct smf *);

#endif
