/* conversion.h
 *
 * Copyright 2002-2006 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CONVERSION_H
#define _CONVERSION_H

#include "mmd.h"
#include "smf.h"
#include "song.h"

/* Converts an MMD2 module to a song */
struct song *MMD2_convert_song(struct MMD2 *);
/* Converts a song to an MMD2 module */
struct MMD2 *song_convert_MMD2(struct song *);
/* Converts a song to a standard MIDI file */
struct smf *song_convert_smf(struct song *);

#endif
