/* block.h
 *
 * Copyright 2002-2005 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _BLOCK_H
#define _BLOCK_H

#include <libxml/tree.h>

struct block {
  /* Name */
  char *name;
  /* Number of tracks */
  unsigned int tracks;
  /* Number of lines */
  unsigned int length;
  /* Notation data */
  unsigned char *notes;
  /* Number of command pages */
  unsigned int commandpages;
  /* Command block array */
  unsigned char *commands;
};

/* Allocates a block */
struct block *block_alloc(int, int, int);
void block_free(struct block *);
/* Sets a note in a block */
void block_set_note(struct block *, unsigned int, unsigned int, unsigned char, unsigned char, unsigned char);
/* Sets an instrument in a block */
void block_set_instrument(struct block *, unsigned int, unsigned int, unsigned char);
/* Sets a part of a command in a block */
void block_set_command(struct block *, unsigned int, unsigned int, unsigned int, unsigned char, unsigned char);
/* Sets a command in a block */
void block_set_command_full(struct block *, unsigned int, unsigned int, unsigned int, unsigned char, unsigned char);
/* Sets the number of tracks in a block */
void block_set_tracks(struct block *, unsigned int);
/* Sets the length of a block */
void block_set_length(struct block *, unsigned int);
/* Sets the number of command pages in a block */
void block_set_commandpages(struct block *, unsigned int);
/* Sets the name of the block */
void block_set_name(struct block *, char *);
/* Copies a part of a block to a new block */
struct block *block_copy(struct block *, int, int, int, int);
/* Pastes a block to another block in the given position */
void block_paste(struct block *, struct block *, int, int);
/* Clears a part of a block */
void block_clear(struct block *, int, int, int, int);
/* Parses a block element in an XML file */
struct block *block_parse(xmlDocPtr, xmlNsPtr, xmlNodePtr);
/* Saves a block to an XML document */
void block_save(struct block *, int, xmlNodePtr);
/* Transposes a block or a part of it */
void block_transpose(struct block *, int, int, int, int, int, int);
/* Expands/shrinks a block or a part of it */
void block_expandshrink(struct block *, int, int, int, int, int);
/* Changes or swaps an instrument to another */
void block_changeinstrument(struct block *, int, int, int, int, int, int, int);

#endif
