/* main.c
 *
 * Copyright 2002-2005 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <libgnome/libgnome.h>
#include <glade/glade.h>
#include <glib.h>
#include "editor.h"
#include "gui.h"
#include "conversion.h"

extern gboolean gui_quit;
char *nullcheck_error_string = "%s() called with null %s\n";

int main(int argc, char *argv[])
{
  struct editor *editor = NULL;
  int i;

  if (!g_thread_supported()) {
    g_thread_init(NULL);
    gdk_threads_init();
  } else {
    fprintf(stderr, "No threads implementation. Tutka requires threads.\n");
    return -1;
  }

  gnome_init("Tutka", VERSION, argc, argv);
  glade_gnome_init();

  editor = editor_open();

  if (editor != NULL) {
    /* Open a song in the editor */
    if (argc > 1)
      editor_song_open(editor, argv[1]);
    else
      editor_song_open(editor, NULL);

    /* Main loop */
    gdk_threads_enter();
    while (!gui_quit) {
      unsigned char *data = NULL;

      /* Handle all GUI events */
      while (gtk_events_pending())
	gtk_main_iteration_do(FALSE);

      /* Read MIDI input if there is any pending */
      for (i = 0; i < editor->nummidiinterfaces; i++)
        while ((data = midi_read_raw(editor->midiinterfaces[i])) != NULL) {
          editor_midi_input(editor, data);
          free(data);
        }

      /* Refresh the GUI */
      gui_refresh(editor->gui);

      /* Sleep for a while */
      usleep(40);
    }
    gdk_threads_leave();

    editor_close(editor);
  }

  return 0;
}
