/* gui.h
 *
 * Copyright 2002-2004 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GUI_H
#define _GUI_H

#include <gnome.h>
#include <glade/glade.h>
#include "trackerwidget.h"
#include "editor.h"

struct gui {
  struct editor *editor;

  GladeXML *xml;
  GtkWidget *window_main;
  GtkWidget *window_about;
  unsigned int *numplayseqs, *numblocks;

  /* FIX: These should not be here. Current Message number */
  int messagelist_message;
  unsigned char messagelist_autostop;

  unsigned int refresh_mask, callback_refresh_mask;
  struct block *refresh_tracker_block;
  int refresh_tracker_patpos;
  GMutex *refresh_mutex;
};

enum {
  GUI_AREA_SONG,
  GUI_AREA_BLOCK,
  GUI_AREA_TRACK,
  GUI_AREA_SELECTION
};

enum {
  GUI_REFRESH_INSTRUMENT_SHIFT,
  GUI_REFRESH_TEMPO_SHIFT,
  GUI_REFRESH_WINDOW_TITLE_SHIFT,
  GUI_REFRESH_STATUSBAR_SHIFT,
  GUI_REFRESH_INFO_SHIFT,
  GUI_REFRESH_TIMER_SHIFT,
  GUI_REFRESH_BLOCKLIST_SHIFT,
  GUI_REFRESH_PLAYSEQ_SHIFT,
  GUI_REFRESH_PLAYSEQ_RECREATE_SHIFT,
  GUI_REFRESH_PLAYSEQLIST_SHIFT,
  GUI_REFRESH_SECTIONLIST_SHIFT,
  GUI_REFRESH_MESSAGELIST_SHIFT,
  GUI_REFRESH_TRACKVOLUMES_SHIFT,
  GUI_REFRESH_SONG_SHIFT,
  GUI_REFRESH_TRACKER_SHIFT
};

enum {
  GUI_REFRESH_INSTRUMENT = (1 << GUI_REFRESH_INSTRUMENT_SHIFT),
  GUI_REFRESH_TEMPO = (1 << GUI_REFRESH_TEMPO_SHIFT),
  GUI_REFRESH_WINDOW_TITLE = (1 << GUI_REFRESH_WINDOW_TITLE_SHIFT),
  GUI_REFRESH_STATUSBAR = (1 << GUI_REFRESH_STATUSBAR_SHIFT),
  GUI_REFRESH_INFO = (1 << GUI_REFRESH_INFO_SHIFT),
  GUI_REFRESH_TIMER = (1 << GUI_REFRESH_TIMER_SHIFT),
  GUI_REFRESH_BLOCKLIST = (1 << GUI_REFRESH_BLOCKLIST_SHIFT),
  GUI_REFRESH_PLAYSEQ = (1 << GUI_REFRESH_PLAYSEQ_SHIFT),
  GUI_REFRESH_PLAYSEQ_RECREATE = (1 << GUI_REFRESH_PLAYSEQ_RECREATE_SHIFT),
  GUI_REFRESH_PLAYSEQLIST = (1 << GUI_REFRESH_PLAYSEQLIST_SHIFT),
  GUI_REFRESH_SECTIONLIST = (1 << GUI_REFRESH_SECTIONLIST_SHIFT),
  GUI_REFRESH_MESSAGELIST = (1 << GUI_REFRESH_MESSAGELIST_SHIFT),
  GUI_REFRESH_TRACKVOLUMES = (1 << GUI_REFRESH_TRACKVOLUMES_SHIFT),
  GUI_REFRESH_SONG = (1 << GUI_REFRESH_SONG_SHIFT),
  GUI_REFRESH_TRACKER = (1 << GUI_REFRESH_TRACKER_SHIFT)
};

enum {
  GUI_SECTIONLIST_COLUMN_SECTION,
  GUI_SECTIONLIST_COLUMN_PLAYSEQ_NUMBER,
  GUI_SECTIONLIST_COLUMN_PLAYSEQ_NAME
};

enum {
  GUI_PLAYSEQLIST_COLUMN_NUMBER,
  GUI_PLAYSEQLIST_COLUMN_NAME
};

enum {
  GUI_PLAYSEQ_COLUMN_POSITION,
  GUI_PLAYSEQ_COLUMN_BLOCK_NUMBER,
  GUI_PLAYSEQ_COLUMN_BLOCK_NAME
};

enum {
  GUI_BLOCKLIST_COLUMN_NUMBER,
  GUI_BLOCKLIST_COLUMN_NAME,
  GUI_BLOCKLIST_COLUMN_TRACKS,
  GUI_BLOCKLIST_COLUMN_LENGTH,
  GUI_BLOCKLIST_COLUMN_COMMAND_PAGES
};

enum {
  GUI_MESSAGELIST_COLUMN_NUMBER,
  GUI_MESSAGELIST_COLUMN_NAME,
  GUI_MESSAGELIST_COLUMN_LENGTH,
  GUI_MESSAGELIST_COLUMN_AUTOSEND
};

/* Opening and closing the GUI */
struct gui *gui_open(struct editor *);
void gui_close(struct gui *);

/* For setting elements to refresh from the player thread only */
void gui_set_refresh(struct gui *, unsigned int);

/* These can only be called from the GUI thread */
void gui_set_callback_refresh(struct gui *, unsigned int);
void gui_refresh(struct gui *);
void gui_refresh_all(struct gui *);
void gui_instrument_refresh(struct gui *);
void gui_tempo_refresh(struct gui *);
void gui_window_title_refresh(struct gui *);
void gui_statusbar_refresh(struct gui *);
void gui_info_refresh(struct gui *);
void gui_timer_refresh(struct gui *, unsigned int);
void gui_blocklist_refresh(struct gui *, gboolean);
void gui_playseq_refresh(struct gui *, gboolean);
void gui_playseqlist_refresh(struct gui *, gboolean);
void gui_sectionlist_refresh(struct gui *, gboolean);
void gui_sectionlist_buttons_refresh(struct gui *);
void gui_messagelist_refresh(struct gui *, gboolean);
void gui_trackvolumes_refresh(struct gui *);
void gui_preferences_refresh(struct gui *);
void gui_tracker_refresh(struct gui *);
void gui_song_refresh(struct gui *);

Tracker *gui_get_tracker(struct gui *);
int gui_get_tracker_position(struct gui *);

#endif
