/* instrument.h
 *
 * Copyright 2002-2003 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _INSTRUMENT_H
#define _INSTRUMENT_H

#include <libxml/tree.h>

struct instrument {
  /* Name */
  char *name;
  /* MIDI preset */
  unsigned short midipreset;
  /* MIDI channel */
  unsigned char midichannel;
  /* Default velocity */
  unsigned char defaultvelocity;
  /* Transpose */
  char transpose;
  /* Holding time in ticks*/
  unsigned char hold;
};

struct instrument *instrument_alloc();
void instrument_free(struct instrument *);
/* Parses an instrument element in an XML file */
struct instrument *instrument_parse(xmlDocPtr, xmlNsPtr, xmlNodePtr);
/* Saves an instrument to an XML document */
void instrument_save(struct instrument *, int, xmlNodePtr);

#endif
