/* main.c
 *
 * Copyright 2002-2003 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libgnome/libgnome.h>
#include <glade/glade.h>
#include <glib.h>
#include <unistd.h>

#include "editor.h"
#include "gui.h"

extern gboolean gui_quit;

int main(int argc, char *argv[]) {
  struct editor *editor=NULL;

  if(!g_thread_supported()) {
    g_thread_init(NULL);
    gdk_threads_init();
  } else {
    fprintf(stderr, "No threads implementation. Tutka requires threads.\n");
    return -1;
  }

  gnome_init("Tutka", VERSION, argc, argv);
  glade_gnome_init();

  editor=editor_open(PACKAGE_DATA_DIR "/glade/tutka.glade");

  if(editor!=NULL) {
    /* Open a song in the editor */
    if(argc>1)
      editor_song_open(editor, argv[1]);
    else
      editor_song_open(editor, NULL);
    
    /* Main loop */
    gdk_threads_enter();
    while(!gui_quit) {
      while(gtk_events_pending())
	gtk_main_iteration_do(FALSE);
      gui_refresh(editor->gui);
      usleep(40);
    }
    gdk_threads_leave();

    editor_close(editor);
  }

  return 0;
}
