/* midi.h
 *
 * Copyright 2002-2003 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _MIDI_H
#define _MIDI_H

#include <libxml/tree.h>

struct sysex {
  /* Name */
  char *name;
  /* Length in bytes */
  unsigned int length;
  /* Dump data */
  unsigned char *data;
  /* Automatically send after loading? */
  unsigned int autosend;
};

/* Opens a MIDI device */
FILE *midi_open(char *);
/* Closes a MIDI device */
void midi_close(FILE *);
/* Stops a note playing on a MIDI channel using requested velocity */
void midi_note_off(FILE *, unsigned char, unsigned char, unsigned char);
/* Plays a note on a MIDI channel using requested velocity */
void midi_note_on(FILE *, unsigned char, unsigned char, unsigned char);
/* Sets the aftertouch pressure of a note playing on a MIDI channel */
void midi_aftertouch(FILE *, unsigned char, unsigned char, unsigned char);
/* Sets the MIDI controller value of a MIDI channel */
void midi_controller(FILE *, unsigned char, unsigned char, unsigned char);
/* Send a program change on a MIDI channel */
void midi_program_change(FILE *, unsigned char, unsigned char);
/* Sets the channel pressure of a MIDI channel */
void midi_channel_pressure(FILE *, unsigned char, unsigned char);
/* Sets the pitch wheel value of a MIDI channel */
void midi_pitch_wheel(FILE *, unsigned char, unsigned short);
/* Sends a MIDI SysEx message */
void midi_system_exclusive(FILE *, unsigned char *, unsigned short);
/* Send a clock message */
void midi_clock(FILE *);
/* Receives a MIDI SysEx message */
void midi_read_system_exclusive(FILE *, struct sysex *, int);
/* Sets the length of a MIDI SysEx message */
void sysex_set_length(struct sysex *, unsigned int);
/* Sets the auto send flag of a MIDI SysEx message */
void sysex_set_autosend(struct sysex *, unsigned int);
/* Parses a SysEx element in an XML file */
struct sysex *sysex_parse(xmlDocPtr, xmlNsPtr, xmlNodePtr);
/* Saves a SysEx message to an XML file */
void sysex_save(struct sysex *, int, xmlNodePtr);

#endif
