// sdl_graphics.h - SDL graphics implementation
//
// Copyright (C) 2000, 2001 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SDL_GRAPHICS_H
#define SDL_GRAPHICS_H

#include <cstddef>
#include "SDL.h"

#include "graphics.h"

namespace sdl {

	// target surface, i.e., surface to draw on.
	// This is an implementation of ABC graphics::tsurface.
	// It also provides function access() for its SDL_Surface* to be known.
	class tsurface : public graphics::tsurface {
	public:
		tsurface(SDL_Surface* sur);

		void flip();
		void fullscreen(bool what);
		void grab_input(bool what);
		void show_cursor(bool what);
		void set_gamma(double r, double g, double b);

		int w() const { return s->w; }
		int h() const { return s->h; }

		void clear(int r, int g, int b);
		void clear_rect(int x, int y, int w, int h, int r, int g, int b);
		void clip_rect(int x, int y, int w, int h);
		void unclip();

		graphics::raw_image* make_raw_image(const std::string& filename);
		graphics::image* make_image(const graphics::raw_image* src);
		graphics::image* make_image(const graphics::raw_image* src, int w, int h, double bright = 1.0);
		graphics::deep_image* make_deep_image(const graphics::raw_image* src, int n, const graphics::projector& p, double w, double h);
		graphics::tunnel_drawable* make_tunnel(const graphics::raw_image* src, const graphics::mapper* m);
		graphics::dial* make_dial(const graphics::raw_image* src, double amin, double amax, int w, int h);

		SDL_Surface* access() const { return s; }
	private:
		SDL_Surface* s;
		SDL_PixelFormat format; // for alpha

		tsurface(const tsurface&);
		tsurface& operator=(const tsurface&);
	};

} // namespace sdl

#endif // !SDL_GRAPHICS_H

// Local Variables:
// mode: c++
// End:
