// sdl_audio.h - SDL audio implementation
//
// Copyright (C) 2001 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SDL_AUDIO_H
#define SDL_AUDIO_H

#include <list>
#include "SDL.h"

#include "audio.h"

namespace sdl {

	class active_sound;
	class sound;

	class taudio : public audio::taudio {

		friend class sound;

	public:
		taudio(int frequency, int samples);
		~taudio();

		audio::raw_sound* make_raw_sound(const std::string& filename);
		audio::sound* make_sound(const audio::raw_sound* src);
		void time_passed(int msec);

		void get(Uint8* stream, int len);

		void take_sound(active_sound* s);

		const SDL_AudioSpec* get_spec() const { return &spec; }
	private:
		bool audio_available;
		SDL_AudioSpec spec;
		std::list<active_sound*> sounds;
		int msamples_left;

		Uint8* buf;
		int buf_len, buf_start, buf_used;
		void mix_sounds(int offs, int len);

		taudio(const taudio&);
		taudio operator=(const taudio&);
	};

} // namespace sdl

#endif // !SDL_AUDIO_H

// Local Variables:
// mode: c++
// End:
