// enemy.h - provides factories for enemy balls
//
// Copyright (C) 2001 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef ENEMY_H
#define ENEMY_H

#include "ball.h"

namespace balls {
	// enemy_register() provides factories for the following enemy balls:
	// tickler
	// tickler_thrower
	// punch
	// punch_thrower
	// speedy
	// speedy_thrower
	// crazy
	// crazy_thrower
	// crawler
	// crawler_thrower
	// multics
	void enemy_register(factory_map& factories);
}

#endif // !ENEMY_H

// Local Variables:
// mode: c++
// End:
